// This file is part of the AliceVision project.
// Copyright (c) 2016 AliceVision contributors.
// Copyright (c) 2012 openMVG contributors.
// This Source Code Form is subject to the terms of the Mozilla Public License,
// v. 2.0. If a copy of the MPL was not distributed with this file,
// You can obtain one at https://mozilla.org/MPL/2.0/.

#pragma once

// Accumulator trait to perform safe summation over a specified type
namespace aliceVision {

template<typename T>
struct Accumulator
{
    typedef T Type;
};
template<>
struct Accumulator<unsigned char>
{
    typedef float Type;
};
template<>
struct Accumulator<unsigned short>
{
    typedef float Type;
};
template<>
struct Accumulator<unsigned int>
{
    typedef float Type;
};
template<>
struct Accumulator<char>
{
    typedef float Type;
};
template<>
struct Accumulator<short>
{
    typedef float Type;
};
template<>
struct Accumulator<int>
{
    typedef float Type;
};
template<>
struct Accumulator<bool>
{
    typedef unsigned int Type;
};

}  // namespace aliceVision
