/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_soe_ip_h__
#define __ls10_dev_soe_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_SOE                               0x3fff:0x0000 /* RW--D */
#define NV_SOE_FALCON_IRQSTAT                                                                           0x0008     /* R--4R */
#define NV_SOE_FALCON_IRQSTAT__DEVICE_MAP                                                               0x00000002 /*       */
#define NV_SOE_FALCON_IRQSTAT_GPTMR                                                                     0:0            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_GPTMR_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_GPTMR_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_WDTMR                                                                     1:1            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_WDTMR_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_WDTMR_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_MTHD                                                                      2:2            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_MTHD_FALSE                                                                0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_MTHD_TRUE                                                                 0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_CTXSW                                                                     3:3            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_CTXSW_FALSE                                                               0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_CTXSW_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_HALT                                                                      4:4            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_HALT_FALSE                                                                0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_HALT_TRUE                                                                 0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXTERR                                                                    5:5            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXTERR_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXTERR_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN0                                                                    6:6            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_SWGEN0_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN0_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN1                                                                    7:7            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_SWGEN1_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_SWGEN1_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT                                                                       15:8           /*       */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ1                                                               8:8            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ1_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ1_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ2                                                               9:9            /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ2_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ2_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ3                                                               10:10          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ3_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ3_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ4                                                               11:11          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ4_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ4_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ5                                                               12:12          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ5_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ5_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ6                                                               13:13          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ6_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ6_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ7                                                               14:14          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ7_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ7_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ8                                                               15:15          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ8_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_EXT_EXTIRQ8_FALSE                                                         0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_DMA                                                                       16:16          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_DMA_TRUE                                                                  0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_DMA_FALSE                                                                 0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_SHA                                                                       17:17          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_SHA_TRUE                                                                  0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SHA_FALSE                                                                 0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_MEMERR                                                                    18:18          /* R-IVF */
#define NV_SOE_FALCON_IRQSTAT_MEMERR_TRUE                                                               0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_MEMERR_FALSE                                                              0x00000000     /* R-I-V */
#define NV_SOE_FALCON_IRQSTAT_CTXSW_ERROR                                                               19:19          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_CTXSW_ERROR_TRUE                                                          0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_CTXSW_ERROR_FALSE                                                         0x00000000     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_GDMA                                                                      20:20          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_GDMA_TRUE                                                                 0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_GDMA_FALSE                                                                0x00000000     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ICD                                                                       22:22          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_ICD_TRUE                                                                  0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_ICD_FALSE                                                                 0x00000000     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_IOPMP                                                                     23:23          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_IOPMP_TRUE                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_IOPMP_FALSE                                                               0x00000000     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_CORE_MISMATCH                                                             24:24          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_CORE_MISMATCH_TRUE                                                        0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_CORE_MISMATCH_FALSE                                                       0x00000000     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SE_SAP                                                                    25:25          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_SE_SAP_SET                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SE_PKA                                                                    26:26          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_SE_PKA_SET                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SE_RNG                                                                    27:27          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_SE_RNG_SET                                                                0x00000001     /* R---V */
#define NV_SOE_FALCON_IRQSTAT_SE_KEYMOVER                                                               28:28          /* R-XVF */
#define NV_SOE_FALCON_IRQSTAT_SE_KEYMOVER_SET                                                           0x00000001     /* R---V */
#define NV_SOE_FALCON_CGCTL                                                                             0x00a0     /* RW-4R */
#define NV_SOE_FALCON_CGCTL__DEVICE_MAP                                                                 0x00000000 /*       */
#define NV_SOE_FALCON_CGCTL_CG_OVERRIDE                                                                 0:0            /* RWIVF */
#define NV_SOE_FALCON_CGCTL_CG_OVERRIDE_INIT                                                            0x00000000     /* RWI-V */
#define NV_SOE_FALCON_CG2                                                                               0x0134     /* RW-4R */
#define NV_SOE_FALCON_CG2__DEVICE_MAP                                                                   0x00000000 /*       */
#define NV_SOE_FALCON_CG2_SLCG                                                                          17:1           /*       */
#define NV_SOE_FALCON_CG2_SLCG_ENABLED                                                                  0              /*       */
#define NV_SOE_FALCON_CG2_SLCG_DISABLED                                                                 0x1FFFF        /*       */
#define NV_SOE_FALCON_CG2_SLCG__PROD                                                                    0x000A0        /*       */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DMA                                                               1:1            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DMA_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DMA_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM                                                        2:2            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM_ENABLED                                                0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GC6_SR_FSM_DISABLED                                               0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PIPE                                                              3:3            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PIPE_ENABLED                                                      0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PIPE_DISABLED                                                     0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DIV                                                               4:4            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DIV_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_DIV_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_ICD                                                               5:5            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_ICD_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_ICD_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CFG                                                               6:6            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CFG_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CFG_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CTXSW                                                             7:7            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CTXSW_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_CTXSW_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PMB                                                               8:8            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PMB_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_PMB_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_RF                                                                9:9            /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_RF_ENABLED                                                        0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_RF_DISABLED                                                       0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_MUL                                                               10:10          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_MUL_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_MUL_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_LDST                                                              11:11          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_LDST_ENABLED                                                      0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_LDST_DISABLED                                                     0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSYNC                                                             12:12          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSYNC_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSYNC_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GPTMR                                                             13:13          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GPTMR_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GPTMR_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_WDTMR                                                             14:14          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_WDTMR_ENABLED                                                     0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_WDTMR_DISABLED                                                    0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_IRQSTAT                                                           15:15          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_IRQSTAT_ENABLED                                                   0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_IRQSTAT_DISABLED                                                  0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TOP                                                               16:16          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TOP_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TOP_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FBIF                                                                     17:17          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FBIF_ENABLED                                                             0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FBIF_DISABLED                                                            0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_SHA                                                               18:18          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_SHA__PROD                                                         0x00000001     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_SHA_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_SHA_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GDMA                                                              19:19          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GDMA__PROD                                                        0x00000001     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GDMA_ENABLED                                                      0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_GDMA_DISABLED                                                     0x00000001     /* RWI-V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSE                                                               20:20          /* RWIVF */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSE__PROD                                                         0x00000001     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSE_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_FALCON_CG2_SLCG_FALCON_TSE_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_RISCV_IRQMASK                                                                            0x1528     /* R--4R */
#define NV_SOE_RISCV_IRQMASK__DEVICE_MAP                                                                0x00000002 /*       */
#define NV_SOE_RISCV_IRQMASK_GPTMR                                                                      0:0            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_GPTMR_UNSET                                                                0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_GPTMR_SET                                                                  0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQMASK_WDTMR                                                                      1:1            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_WDTMR_UNSET                                                                0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_WDTMR_SET                                                                  0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQMASK_MTHD                                                                       2:2            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_MTHD_UNSET                                                                 0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_MTHD_SET                                                                   0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQMASK_CTXSW                                                                      3:3            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_CTXSW_UNSET                                                                0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_CTXSW_SET                                                                  0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQMASK_HALT                                                                       4:4            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_HALT_UNSET                                                                 0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_HALT_SET                                                                   0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQMASK_EXTERR                                                                     5:5            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_EXTERR_UNSET                                                               0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_EXTERR_SET                                                                 0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQMASK_SWGEN0                                                                     6:6            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_SWGEN0_UNSET                                                               0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_SWGEN0_SET                                                                 0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQMASK_SWGEN1                                                                     7:7            /* R-IVF */
#define NV_SOE_RISCV_IRQMASK_SWGEN1_UNSET                                                               0x00000000     /* R-I-V */
#define NV_SOE_RISCV_IRQMASK_SWGEN1_SET                                                                 0x00000001     /* R---V */
#define NV_SOE_RISCV_IRQDEST                                                                            0x152c     /* RW-4R */
#define NV_SOE_RISCV_IRQDEST__DEVICE_MAP                                                                0x00000002 /*       */
#define NV_SOE_RISCV_IRQDEST_GPTMR                                                                      0:0            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_GPTMR_RISCV                                                                0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_GPTMR_HOST                                                                 0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_WDTMR                                                                      1:1            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_WDTMR_RISCV                                                                0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_WDTMR_HOST                                                                 0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_MTHD                                                                       2:2            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_MTHD_RISCV                                                                 0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_MTHD_HOST                                                                  0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_CTXSW                                                                      3:3            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_CTXSW_RISCV                                                                0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_CTXSW_HOST                                                                 0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_HALT                                                                       4:4            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_HALT_RISCV                                                                 0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_HALT_HOST                                                                  0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXTERR                                                                     5:5            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXTERR_RISCV                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXTERR_HOST                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_SWGEN0                                                                     6:6            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_SWGEN0_RISCV                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_SWGEN0_HOST                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_SWGEN1                                                                     7:7            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_SWGEN1_RISCV                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_SWGEN1_HOST                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT                                                                        15:8           /*       */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ1                                                                8:8            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ1_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ1_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ2                                                                9:9            /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ2_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ2_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ3                                                                10:10          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ3_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ3_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ4                                                                11:11          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ4_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ4_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ5                                                                12:12          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ5_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ5_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ6                                                                13:13          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ6_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ6_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ7                                                                14:14          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ7_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ7_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ8                                                                15:15          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ8_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_EXT_EXTIRQ8_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_DMA                                                                        16:16          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_DMA_RISCV                                                                  0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_DMA_HOST                                                                   0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_SHA                                                                        17:17          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_SHA_RISCV                                                                  0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_SHA_HOST                                                                   0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_MEMERR                                                                     18:18          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_MEMERR_RISCV                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_MEMERR_HOST                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_CTXSW_ERROR                                                                19:19          /* R-IVF */
#define NV_SOE_RISCV_IRQDEST_CTXSW_ERROR_RISCV                                                          0x00000000     /* R---V */
#define NV_SOE_RISCV_IRQDEST_CTXSW_ERROR_HOST                                                           0x00000001     /* R-I-V */
#define NV_SOE_RISCV_IRQDEST_GDMA                                                                       20:20          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_GDMA_RISCV                                                                 0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_GDMA_HOST                                                                  0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_ICD                                                                        22:22          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_ICD_RISCV                                                                  0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_ICD_HOST                                                                   0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_IOPMP                                                                      23:23          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_IOPMP_RISCV                                                                0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_IOPMP_HOST                                                                 0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_CORE_MISMATCH                                                              24:24          /* R-IVF */
#define NV_SOE_RISCV_IRQDEST_CORE_MISMATCH_RISCV                                                        0x00000000     /* R---V */
#define NV_SOE_RISCV_IRQDEST_CORE_MISMATCH_HOST                                                         0x00000001     /* R-I-V */
#define NV_SOE_RISCV_IRQDEST_SE_SAP                                                                     25:25          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_SE_SAP_RISCV                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_SE_SAP_HOST                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_SE_PKA                                                                     26:26          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_SE_PKA_RISCV                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_SE_PKA_HOST                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_SE_RNG                                                                     27:27          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_SE_RNG_RISCV                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_SE_RNG_HOST                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_IRQDEST_SE_KEYMOVER                                                                28:28          /* RWIVF */
#define NV_SOE_RISCV_IRQDEST_SE_KEYMOVER_RISCV                                                          0x00000000     /* RWI-V */
#define NV_SOE_RISCV_IRQDEST_SE_KEYMOVER_HOST                                                           0x00000001     /* RW--V */
#define NV_SOE_RISCV_CPUCTL                                                                             0x1388     /* RW-4R */
#define NV_SOE_RISCV_CPUCTL_STARTCPU                                                                    0:0            /* -WIVF */
#define NV_SOE_RISCV_CPUCTL_STARTCPU_FALSE                                                              0x00000000     /* -WI-V */
#define NV_SOE_RISCV_CPUCTL_STARTCPU_TRUE                                                               0x00000001     /* -W--V */
#define NV_SOE_RISCV_CPUCTL_HALTED                                                                      4:4            /* R-IVF */
#define NV_SOE_RISCV_CPUCTL_HALTED_INIT                                                                 0x00000001     /* R-I-V */
#define NV_SOE_RISCV_CPUCTL_HALTED_TRUE                                                                 0x00000001     /* R---V */
#define NV_SOE_RISCV_CPUCTL_HALTED_FALSE                                                                0x00000000     /* R---V */
#define NV_SOE_RISCV_CPUCTL_STOPPED                                                                     5:5            /* R-IVF */
#define NV_SOE_RISCV_CPUCTL_STOPPED_INIT                                                                0x00000000     /* R-I-V */
#define NV_SOE_RISCV_CPUCTL_ACTIVE_STAT                                                                 7:7            /* R-IVF */
#define NV_SOE_RISCV_CPUCTL_ACTIVE_STAT_INACTIVE                                                        0x00000000     /* R-I-V */
#define NV_SOE_RISCV_CPUCTL_ACTIVE_STAT_ACTIVE                                                          0x00000001     /* R---V */
#define NV_SOE_RISCV_CG                                                                                 0x1398     /* RW-4R */
#define NV_SOE_RISCV_CG__DEVICE_MAP                                                                     0x00000000 /*       */
#define NV_SOE_RISCV_CG_SLCG                                                                            1:0            /*       */
#define NV_SOE_RISCV_CG_SLCG_DISABLED                                                                   0              /*       */
#define NV_SOE_RISCV_CG_SLCG_ENABLED                                                                    3              /*       */
#define NV_SOE_RISCV_CG_SLCG__PROD                                                                      3              /*       */
#define NV_SOE_RISCV_CG_SLCG_EXT                                                                        0:0            /* RWIVF */
#define NV_SOE_RISCV_CG_SLCG_EXT_DISABLED                                                               0x00000000     /* RWI-V */
#define NV_SOE_RISCV_CG_SLCG_EXT_ENABLED                                                                0x00000001     /* RW--V */
#define NV_SOE_RISCV_CG_SLCG_CORE                                                                       1:1            /* RWIVF */
#define NV_SOE_RISCV_CG_SLCG_CORE_DISABLED                                                              0x00000000     /* RWI-V */
#define NV_SOE_RISCV_CG_SLCG_CORE_ENABLED                                                               0x00000001     /* RW--V */
#define NV_SOE_RISCV_CG_RSVD                                                                            31:2           /* R-IVF */
#define NV_SOE_RISCV_CG_RSVD_INIT                                                                       0x00000000     /* R-I-V */
#define NV_SOE_RISCV_CG_CORE_SLCG                                                                       1:1            /*       */
#define NV_SOE_RISCV_CG_SLCG_DISABLE                                                                    0              /*       */
#define NV_SOE_RISCV_CG_SLCG_ENABLE                                                                     1              /*       */
#define NV_SOE_RISCV_CG_CORE_SLCG_DISABLE                                                               0              /*       */
#define NV_SOE_RISCV_CG_CORE_SLCG_ENABLE                                                                1              /*       */
#define NV_SOE_PRIV_BLOCKER_CTRL_CG1                                                                    0x0e28     /* RW-4R */
#define NV_SOE_PRIV_BLOCKER_CTRL_CG1_SLCG                                                               0:0            /* RWIVF */
#define NV_SOE_PRIV_BLOCKER_CTRL_CG1_SLCG_DISABLED                                                      0x00000001     /* RWI-V */
#define NV_SOE_PRIV_BLOCKER_CTRL_CG1_SLCG_ENABLED                                                       0x00000000     /* RW--V */
#define NV_SOE_PRIV_BLOCKER_CTRL_CG1_SLCG__PROD                                                         0x00000000     /* RW--V */
#define NV_SOE_BAR0_TMOUT                                                                               0x070c     /* RW-4R */
#define NV_SOE_BAR0_TMOUT_CYCLES                                                                        31:0           /* RWIVF */
#define NV_SOE_BAR0_TMOUT_CYCLES_INIT                                                                   0x01f2a737     /* RWI-V */
#define NV_SOE_BAR0_TMOUT_CYCLES__PROD                                                                  0x01f2a737     /* RW--V */
#define NV_SOE_MISC_CG1                                                                                 0x083c     /* RW-4R */
#define NV_SOE_MISC_CG1_SLCG                                                                            31:0           /* RWIVF */
#define NV_SOE_MISC_CG1_SLCG_ENABLED                                                                    0x00000000     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_DISABLED                                                                   0x8000003d     /* RWI-V */
#define NV_SOE_MISC_CG1_SLCG__PROD                                                                      0x0000003c     /* RW--V */
#define NV_SOE_MISC_CG1_SLCG_FALCON                                                                     0:0            /*       */
#define NV_SOE_MISC_CG1_SLCG_FALCON_ENABLED                                                             0              /*       */
#define NV_SOE_MISC_CG1_SLCG_FALCON_DISABLED                                                            1              /*       */
#define NV_SOE_MISC_CG1_SLCG_SCP                                                                        2:2            /*       */
#define NV_SOE_MISC_CG1_SLCG_SCP_ENABLED                                                                0              /*       */
#define NV_SOE_MISC_CG1_SLCG_SCP_DISABLED                                                               1              /*       */
#define NV_SOE_MISC_CG1_SLCG_CSBMASTER                                                                  3:3            /*       */
#define NV_SOE_MISC_CG1_SLCG_CSBMASTER_ENABLED                                                          0              /*       */
#define NV_SOE_MISC_CG1_SLCG_CSBMASTER_DISABLED                                                         1              /*       */
#define NV_SOE_MISC_CG1_SLCG_BAR0                                                                       4:4            /*       */
#define NV_SOE_MISC_CG1_SLCG_BAR0_ENABLED                                                               0              /*       */
#define NV_SOE_MISC_CG1_SLCG_BAR0_DISABLED                                                              1              /*       */
#define NV_SOE_MISC_CG1_SLCG_MISC                                                                       5:5            /*       */
#define NV_SOE_MISC_CG1_SLCG_MISC_ENABLED                                                               0              /*       */
#define NV_SOE_MISC_CG1_SLCG_MISC_DISABLED                                                              1              /*       */
#define NV_SOE_MISC_CG1_SLCG_TOP                                                                        31:31          /*       */
#define NV_SOE_MISC_CG1_SLCG_TOP_ENABLED                                                                0x00000000     /*       */
#define NV_SOE_MISC_CG1_SLCG_TOP_DISABLED                                                               0x00000001     /*       */
#define NV_SOE_MISC_TOP_CG                                                                              0x0840     /* RW-4R */
#define NV_SOE_MISC_TOP_CG_IDLE_CG_DLY_CNT                                                              5:0            /* RWIVF */
#define NV_SOE_MISC_TOP_CG_IDLE_CG_DLY_CNT_INIT                                                         0x0000001f     /* RWI-V */
#endif // __ls10_dev_soe_ip_h__
