#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Solar Flux
# send your bug reports to contact@dotslashplay.it
###

script_version=20241126.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='solar-flux'
GAME_NAME='Solar Flux'

## This DRM-free archive is no longer available for sale from humblebundle.com
ARCHIVE_BASE_0_NAME='SolarFluxLinux.zip'
ARCHIVE_BASE_0_MD5='9e2faa973a4affef9ddb1205f5f82019'
ARCHIVE_BASE_0_SIZE='213929'
ARCHIVE_BASE_0_VERSION='1.0-humble1'

CONTENT_PATH_DEFAULT='Solar Flux Linux'
CONTENT_GAME_BIN_FILES='
lib/solarflux'
CONTENT_GAME_DATA_FILES='
data'

APP_MAIN_EXE='lib/solarflux'
APP_MAIN_ICON='data/icon.bmp'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
