/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "CppExtensionTabPresenter.h"

#include "QtPropertyFieldEditor.h"
#include "TextFieldEditor.h"
#include "ExpandableFieldEditor.h"

// -------------------- constructor --------------------
CppExtensionTabPresenter::CppExtensionTabPresenter(CamiTKExtensionModelPresenter* presenter, VariantDataModel& dataModel, QWidget* parent) : ExtensionTabPresenter(presenter, dataModel, parent) {
    //-- C++ specific properties
    QWidget* expandableInnerWidget = new QWidget();
    QGridLayout* expandableInnerGridLayout = new QGridLayout(expandableInnerWidget);
    expandableInnerGridLayout->setContentsMargins(0, 0, 0, 0);

    // add rebuild field only if the extension if of hot plug type
    if (presenter->isHotPlug()) {
        QtPropertyFieldEditor* alwaysRebuildFieldEditor = new QtPropertyFieldEditor(presenter, dataModel["alwaysRebuild"], "Always Rebuild", "Always rebuild the user action libraries when the extension is loaded (e.g. each time camitk-imp is started)", true);
        alwaysRebuildFieldEditor->appendRowTo(expandableInnerGridLayout);
    }

    TextFieldEditor* textFieldEditor = new TextFieldEditor(presenter, dataModel["extensionDependencies"], "Dependencies", QString(R"(<p>List of the extension dependencies expressed as camitk extension macro options. Possible values are: </p>
        <ul>
            <li><tt>NEEDS_ITK</tt></li>
            <li><tt>NEEDS_LIBXML2</tt></li>
            <li><tt>NEEDS_OPENCV</tt></li>
            <li><tt>NEEDS_IGSTK</tt></li>
            <li><tt>NEEDS_XSD</tt></li>
            <li><tt>NEEDS_GDCM</tt></li>
            <li><tt>NEEDS_ACTION_EXTENSION action1 action2 ...</tt></li>
            <li><tt>NEEDS_VIEWER_EXTENSION viewer1 viewer2 ...</tt></li>
            <li><tt>NEEDS_COMPONENT_EXTENSION component1 component2 ...</tt></li>
            <li><tt>NEEDS_CEP_LIBRARIES CEPLib1 CEPLib2 ...</tt></li>
            <li><tt>INCLUDE_DIRECTORIES dir1 dir2 ...</tt></li>
            <li><tt>DEFINES flag1 flag2 ...</tt></li>
            <li><tt>CXX_FLAGS flag1 flag2 ...</tt></li>
            <li><tt>EXTERNAL_SOURCES file1 file2 ...</tt></li>
            <li><tt>EXTERNAL_LIBRARIES lib1 lib2 ...</tt></li>
            <li><tt>HEADERS_TO_INSTALL header1.h header2.h ...</tt></li>
            <li><tt>INSTALL_ALL_HEADERS</tt></li>
            <li><tt>TARGET_NAME non-default-targetname</tt></li>
        </ul>
        <p><b>Note:</b> you don't have to fill this now. The first run of the extension generator will generate a default <tt>CMakeLists.txt</tt>. You can edit it anytime after this first generation, depending on your requirements. Once generated the first time, <tt>CMakeLists.txt</tt> will never be overwritten by the extension generator.</p>)"));
    textFieldEditor->setLanguage("cmake");
    textFieldEditor->appendRowTo(expandableInnerGridLayout);
    ExpandableFieldEditor* advancedEditor = new ExpandableFieldEditor(presenter, expandableInnerWidget, dataModel, "Advanced", false, false);
    advancedEditor->appendRowTo(extensionTabLayout);
}
