"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooManyMasters = exports.MissingPeakTuple = exports.MissingPoints = exports.NoAxes = exports.IndexOverflow = void 0;
const IndexOverflow = (kind, index) => new RangeError(`Index ${kind} overflow: ${index}`);
exports.IndexOverflow = IndexOverflow;
const NoAxes = () => new Error(`No axes found in font`);
exports.NoAxes = NoAxes;
const MissingPoints = () => new Error(`No point list defined`);
exports.MissingPoints = MissingPoints;
const MissingPeakTuple = () => new Error(`Cannot find peak tuple`);
exports.MissingPeakTuple = MissingPeakTuple;
const TooManyMasters = () => new RangeError("Too many masters are involved");
exports.TooManyMasters = TooManyMasters;
//# sourceMappingURL=variation.js.map