// Data types
import { DnsRecordType } from "./globalDataTypes";
// Components
import { FieldConfig } from "src/components/Form/Field";

// DNS Record Type Configurations
export const dnsRecordConfigs: Record<DnsRecordType, FieldConfig[]> = {
  A: [
    {
      type: "text",
      name: "a_part_ip_address",
      label: "IP address",
      isRequired: true,
      dataCy: "modal-text-input-a-part-ip-address",
    },
    {
      type: "checkbox",
      name: "a_extra_create_reverse",
      label: "Create reverse record",
      tooltip: "Create reverse record for this IP Address",
      defaultValue: false,
      dataCy: "modal-checkbox-a-extra-create-reverse",
    },
  ],
  AAAA: [
    {
      type: "text",
      name: "aaaa_part_ip_address",
      label: "IP address",
      isRequired: true,
      dataCy: "modal-text-input-aaaa-part-ip-address",
    },
    {
      type: "checkbox",
      name: "aaaa_extra_create_reverse",
      label: "Create reverse record",
      tooltip: "Create reverse record for this IP Address",
      defaultValue: false,
      dataCy: "modal-checkbox-aaaa-extra-create-reverse",
    },
  ],
  A6: [
    {
      type: "text",
      name: "a6_part_data",
      label: "Record data",
      isRequired: true,
      dataCy: "modal-textarea-a6-part-data",
    },
  ],
  AFSDB: [
    {
      type: "number",
      name: "afsdb_part_subtype",
      label: "Subtype",
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-afsdb-part-subtype",
    },
    {
      type: "text",
      name: "afsdb_part_hostname",
      label: "Hostname",
      isRequired: true,
      dataCy: "modal-text-input-afsdb-part-hostname",
    },
  ],
  CERT: [
    {
      type: "number",
      name: "cert_part_type",
      label: "Type",
      isRequired: true,
      numCharsShown: 6,
      maxValue: 65535,
      defaultValue: 0,
      dataCy: "modal-number-input-cert-part-type",
    },
    {
      type: "number",
      name: "cert_part_key_tag",
      label: "Key tag",
      isRequired: true,
      numCharsShown: 6,
      maxValue: 65535,
      defaultValue: 0,
      dataCy: "modal-number-input-cert-part-key-tag",
    },
    {
      type: "number",
      name: "cert_part_algorithm",
      label: "Algorithm",
      isRequired: true,
      numCharsShown: 4,
      maxValue: 255,
      defaultValue: 0,
      dataCy: "modal-number-input-cert-part-algorithm",
    },
    {
      type: "textarea",
      name: "cert_part_certificate_or_crl",
      label: "Certificate or CRL",
      isRequired: true,
      rows: 8,
      dataCy: "modal-textarea-cert-part-certificate-or-crl",
    },
  ],
  CNAME: [
    {
      type: "text",
      name: "cname_part_hostname",
      label: "Hostname",
      isRequired: true,
      tooltip: "A hostname which this alias hostname points to",
      dataCy: "modal-text-input-cname-part-hostname",
    },
  ],
  DNAME: [
    {
      type: "text",
      name: "dname_part_target",
      label: "Target",
      isRequired: true,
      dataCy: "modal-text-input-dname-part-target",
    },
  ],
  DS: [
    {
      type: "number",
      name: "ds_part_key_tag",
      label: "Key tag",
      isRequired: true,
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-ds-part-key-tag",
    },
    {
      type: "number",
      name: "ds_part_algorithm",
      label: "Algorithm",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-ds-part-algorithm",
    },
    {
      type: "number",
      name: "ds_part_digest_type",
      label: "Digest type",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-ds-part-digest-type",
    },
    {
      type: "textarea",
      name: "ds_part_digest",
      label: "Digest",
      isRequired: true,
      rows: 8,
      dataCy: "modal-textarea-ds-part-digest",
    },
  ],
  DLV: [
    {
      type: "number",
      name: "dlv_part_key_tag",
      label: "Key tag",
      isRequired: true,
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-dlv-part-key-tag",
    },
    {
      type: "number",
      name: "dlv_part_algorithm",
      label: "Algorithm",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-dlv-part-algorithm",
    },
    {
      type: "number",
      name: "dlv_part_digest_type",
      label: "Digest type",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-dlv-part-digest-type",
    },
    {
      type: "textarea",
      name: "dlv_part_digest",
      label: "Digest",
      isRequired: true,
      rows: 8,
      dataCy: "modal-textarea-dlv-part-digest",
    },
  ],
  KX: [
    {
      type: "number",
      name: "kx_part_preference",
      label: "Preference",
      isRequired: true,
      tooltip:
        "Preference given to this exchanger. Lower values are more preferred",
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-kx-part-preference",
    },
    {
      type: "text",
      name: "kx_part_exchanger",
      label: "Exchanger",
      isRequired: true,
      tooltip: "A host willing to act as a key exchanger",
      dataCy: "modal-text-input-kx-part-exchanger",
    },
  ],
  LOC: [
    {
      type: "number",
      name: "loc_part_lat_deg",
      label: "Degrees latitude",
      isRequired: true,
      maxValue: 90,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-lat-deg",
    },
    {
      type: "number",
      name: "loc_part_lat_min",
      label: "Minutes latitude",
      maxValue: 59,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-lat-min",
    },
    {
      type: "number",
      name: "loc_part_lat_sec",
      label: "Seconds latitude",
      maxValue: 59.999,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-lat-sec",
    },
    {
      type: "radio",
      name: "loc_part_lat_dir",
      label: "Direction latitude",
      options: [
        { label: "N", value: "N" },
        { label: "S", value: "S" },
      ],
      defaultValue: "N",
      dataCy: "modal-radio-loc-part-lat-dir",
    },
    {
      type: "number",
      name: "loc_part_lon_deg",
      label: "Degrees longitude",
      isRequired: true,
      maxValue: 180,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-lon-deg",
    },
    {
      type: "number",
      name: "loc_part_lon_min",
      label: "Minutes longitude",
      maxValue: 59,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-lon-min",
    },
    {
      type: "number",
      name: "loc_part_lon_sec",
      label: "Seconds longitude",
      maxValue: 59.999,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-lon-sec",
    },
    {
      type: "radio",
      name: "loc_part_lon_dir",
      label: "Direction longitude",
      options: [
        { label: "E", value: "E" },
        { label: "W", value: "W" },
      ],
      defaultValue: "E",
      dataCy: "modal-radio-loc-part-lon-dir",
    },
    {
      type: "number",
      name: "loc_part_altitude",
      label: "Altitude",
      minValue: -100000.0,
      maxValue: 42849672.95,
      numCharsShown: 11,
      defaultValue: 0,
      isRequired: true,
      dataCy: "modal-number-input-loc-part-altitude",
    },
    {
      type: "number",
      name: "loc_part_size",
      label: "Size",
      minValue: 0.0,
      maxValue: 90000000.0,
      numCharsShown: 11,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-size",
    },
    {
      type: "number",
      name: "loc_part_h_precision",
      label: "Horizontal precision",
      minValue: 0.0,
      maxValue: 90000000.0,
      numCharsShown: 11,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-h-precision",
    },
    {
      type: "number",
      name: "loc_part_v_precision",
      label: "Vertical precision",
      minValue: 0.0,
      maxValue: 90000000.0,
      numCharsShown: 11,
      defaultValue: 0,
      dataCy: "modal-number-input-loc-part-v-precision",
    },
  ],
  MX: [
    {
      type: "number",
      name: "mx_part_preference",
      label: "Preference",
      isRequired: true,
      tooltip:
        "Preference given to this exchanger. Lower values are more preferred",
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-mx-part-preference",
    },
    {
      type: "text",
      name: "mx_part_exchanger",
      label: "Exchanger",
      isRequired: true,
      tooltip: "A host willing to act as a key exchanger",
      dataCy: "modal-text-input-mx-part-exchanger",
    },
  ],
  NAPTR: [
    {
      type: "number",
      name: "naptr_part_order",
      label: "Order",
      isRequired: true,
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-naptr-part-order",
    },
    {
      type: "number",
      name: "naptr_part_preference",
      label: "Preference",
      isRequired: true,
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-naptr-part-preference",
    },
    {
      type: "select",
      name: "naptr_part_flags",
      label: "Flags",
      isRequired: true,
      options: [
        { key: "S", value: "S" },
        { key: "U", value: "U" },
        { key: "P", value: "P" },
        { key: "A", value: "A" },
      ],
      defaultValue: "S",
      dataCy: "modal-select-naptr-part-flags",
    },
    {
      type: "text",
      name: "naptr_part_service",
      label: "Service",
      isRequired: true,
      dataCy: "modal-text-input-naptr-part-service",
    },
    {
      type: "text",
      name: "naptr_part_regexp",
      label: "Regular expression",
      isRequired: true,
      dataCy: "modal-text-input-naptr-part-regexp",
    },
    {
      type: "text",
      name: "naptr_part_replacement",
      label: "Replacement",
      isRequired: true,
      dataCy: "modal-text-input-naptr-part-replacement",
    },
  ],
  NS: [
    {
      type: "text",
      name: "ns_part_hostname",
      label: "Hostname",
      isRequired: true,
      dataCy: "modal-text-input-ns-part-hostname",
    },
    {
      type: "checkbox",
      name: "force",
      label: "Skip DNS check",
      defaultValue: false,
      dataCy: "modal-checkbox-ns-part-skip-dns-check",
    },
  ],
  PTR: [
    {
      type: "text",
      name: "ptr_part_hostname",
      label: "Hostname",
      isRequired: true,
      tooltip: "The hostname this reverse record points to",
      dataCy: "modal-text-input-ptr-part-hostname",
    },
  ],
  SRV: [
    {
      type: "number",
      name: "srv_part_priority",
      label: "Priority",
      isRequired: true,
      tooltip:
        "Lower number means higher priority. Clients will attempt to contact the server with the lowest-numbered priority they can reach.",
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-srv-part-priority",
    },
    {
      type: "number",
      name: "srv_part_weight",
      label: "Weight",
      isRequired: true,
      tooltip: "Relative weight for entries with the same priority",
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-srv-part-weight",
    },
    {
      type: "number",
      name: "srv_part_port",
      label: "Port",
      isRequired: true,
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-srv-part-port",
    },
    {
      type: "text",
      name: "srv_part_target",
      label: "Target",
      isRequired: true,
      tooltip:
        "The domain name of the target host or '.' if the service is decidedly not available at this domain",
      dataCy: "modal-text-input-srv-part-target",
    },
  ],
  SSHFP: [
    {
      type: "number",
      name: "sshfp_part_algorithm",
      label: "Algorithm",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-sshfp-part-algorithm",
    },
    {
      type: "number",
      name: "sshfp_part_fp_type",
      label: "Fingerprint type",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-sshfp-part-fp-type",
    },
    {
      type: "textarea",
      name: "sshfp_part_fingerprint",
      label: "Fingerprint",
      isRequired: true,
      rows: 6,
      dataCy: "modal-textarea-sshfp-part-fingerprint",
    },
  ],
  TLSA: [
    {
      type: "number",
      name: "tlsa_part_cert_usage",
      label: "Certificate usage",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-tlsa-part-cert-usage",
    },
    {
      type: "number",
      name: "tlsa_part_selector",
      label: "Selector",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-tlsa-part-selector",
    },
    {
      type: "number",
      name: "tlsa_part_matching_type",
      label: "Matching type",
      isRequired: true,
      maxValue: 255,
      numCharsShown: 4,
      defaultValue: 0,
      dataCy: "modal-number-input-tlsa-part-matching-type",
    },
    {
      type: "textarea",
      name: "tlsa_part_cert_association_data",
      label: "Certificate association data",
      isRequired: true,
      rows: 6,
      dataCy: "modal-textarea-tlsa-part-cert-association-data",
    },
  ],
  TXT: [
    {
      type: "text",
      name: "txt_part_data",
      label: "Text data",
      isRequired: true,
      dataCy: "modal-textarea-txt-part-data",
    },
  ],
  URI: [
    {
      type: "number",
      name: "uri_part_priority",
      label: "Priority",
      isRequired: true,
      tooltip:
        "Lower number means higher priority. Clients will attempt to contact the URI with the lowest-numbered priority they can reach.",
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-uri-part-priority",
    },
    {
      type: "number",
      name: "uri_part_weight",
      label: "Weight",
      isRequired: true,
      tooltip: "Relative weight for entries with the same priority",
      maxValue: 65535,
      numCharsShown: 6,
      defaultValue: 0,
      dataCy: "modal-number-input-uri-part-weight",
    },
    {
      type: "text",
      name: "uri_part_target",
      label: "Target uniform resource identifier",
      isRequired: true,
      tooltip: "Target Uniform Resource Identifier according to RFC 3986",
      dataCy: "modal-text-input-uri-part-target",
    },
  ],
};
