//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListLoggers.json
func ExampleLoggerClient_NewListByServicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLoggerClient().NewListByServicePager("rg1", "apimService1", &armapimanagement.LoggerClientListByServiceOptions{Filter: nil,
		Top:  nil,
		Skip: nil,
	})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LoggerCollection = armapimanagement.LoggerCollection{
		// 	Count: to.Ptr[int64](3),
		// 	Value: []*armapimanagement.LoggerContract{
		// 		{
		// 			Name: to.Ptr("azuremonitor"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/loggers"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/loggers/azuremonitor"),
		// 			Properties: &armapimanagement.LoggerContractProperties{
		// 				IsBuffered: to.Ptr(true),
		// 				LoggerType: to.Ptr(armapimanagement.LoggerTypeAzureMonitor),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("vvktest"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/loggers"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/loggers/vvktest"),
		// 			Properties: &armapimanagement.LoggerContractProperties{
		// 				Credentials: map[string]*string{
		// 					"instrumentationKey": to.Ptr("{{Logger-Credentials-5b1a17ef2b3f91153004b10d}}"),
		// 				},
		// 				IsBuffered: to.Ptr(true),
		// 				LoggerType: to.Ptr(armapimanagement.LoggerTypeApplicationInsights),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("applicationinsights"),
		// 			Type: to.Ptr("Microsoft.ApiManagement/service/loggers"),
		// 			ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/loggers/applicationinsights"),
		// 			Properties: &armapimanagement.LoggerContractProperties{
		// 				Description: to.Ptr("miaoappinsight"),
		// 				Credentials: map[string]*string{
		// 					"instrumentationKey": to.Ptr("{{Logger-Credentials-5b2056062b3f911ae84a3069}}"),
		// 				},
		// 				IsBuffered: to.Ptr(true),
		// 				LoggerType: to.Ptr(armapimanagement.LoggerTypeApplicationInsights),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementHeadLogger.json
func ExampleLoggerClient_GetEntityTag() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewLoggerClient().GetEntityTag(ctx, "rg1", "apimService1", "templateLogger", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementGetLogger.json
func ExampleLoggerClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLoggerClient().Get(ctx, "rg1", "apimService1", "templateLogger", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LoggerContract = armapimanagement.LoggerContract{
	// 	Name: to.Ptr("kloudapilogger1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/loggers"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/loggers/kloudapilogger1"),
	// 	Properties: &armapimanagement.LoggerContractProperties{
	// 		Description: to.Ptr("testeventhub3again"),
	// 		Credentials: map[string]*string{
	// 			"name": to.Ptr("testeventhub4"),
	// 			"connectionString": to.Ptr("Endpoint=sb://eventhubapim.servicebus.windows.net/;SharedAccessKeyName=Sender;SharedAccessKey=************"),
	// 		},
	// 		IsBuffered: to.Ptr(true),
	// 		LoggerType: to.Ptr(armapimanagement.LoggerTypeAzureEventHub),
	// 		ResourceID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.EventHub/namespaces/eventhubapim"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateAILogger.json
func ExampleLoggerClient_CreateOrUpdate_apiManagementCreateAiLogger() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLoggerClient().CreateOrUpdate(ctx, "rg1", "apimService1", "loggerId", armapimanagement.LoggerContract{
		Properties: &armapimanagement.LoggerContractProperties{
			Description: to.Ptr("adding a new logger"),
			Credentials: map[string]*string{
				"instrumentationKey": to.Ptr("11................a1"),
			},
			LoggerType: to.Ptr(armapimanagement.LoggerTypeApplicationInsights),
		},
	}, &armapimanagement.LoggerClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LoggerContract = armapimanagement.LoggerContract{
	// 	Name: to.Ptr("loggerId"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/loggers"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/loggers/loggerId"),
	// 	Properties: &armapimanagement.LoggerContractProperties{
	// 		Credentials: map[string]*string{
	// 			"instrumentationKey": to.Ptr("{{5a.......2a}}"),
	// 		},
	// 		IsBuffered: to.Ptr(false),
	// 		LoggerType: to.Ptr(armapimanagement.LoggerTypeApplicationInsights),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementCreateEHLogger.json
func ExampleLoggerClient_CreateOrUpdate_apiManagementCreateEhLogger() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLoggerClient().CreateOrUpdate(ctx, "rg1", "apimService1", "eh1", armapimanagement.LoggerContract{
		Properties: &armapimanagement.LoggerContractProperties{
			Description: to.Ptr("adding a new logger"),
			Credentials: map[string]*string{
				"name":             to.Ptr("hydraeventhub"),
				"connectionString": to.Ptr("Endpoint=sb://hydraeventhub-ns.servicebus.windows.net/;SharedAccessKeyName=RootManageSharedAccessKey;SharedAccessKey=********="),
			},
			LoggerType: to.Ptr(armapimanagement.LoggerTypeAzureEventHub),
		},
	}, &armapimanagement.LoggerClientCreateOrUpdateOptions{IfMatch: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LoggerContract = armapimanagement.LoggerContract{
	// 	Name: to.Ptr("eh1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/loggers"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/loggers/eh1"),
	// 	Properties: &armapimanagement.LoggerContractProperties{
	// 		Description: to.Ptr("adding a new logger"),
	// 		Credentials: map[string]*string{
	// 			"connectionString": to.Ptr("{{Logger-Credentials-5f28745bbebeeb13cc3f7301}}"),
	// 		},
	// 		IsBuffered: to.Ptr(true),
	// 		LoggerType: to.Ptr(armapimanagement.LoggerTypeAzureEventHub),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementUpdateLogger.json
func ExampleLoggerClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLoggerClient().Update(ctx, "rg1", "apimService1", "eh1", "*", armapimanagement.LoggerUpdateContract{
		Properties: &armapimanagement.LoggerUpdateParameters{
			Description: to.Ptr("updating description"),
			LoggerType:  to.Ptr(armapimanagement.LoggerTypeAzureEventHub),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LoggerContract = armapimanagement.LoggerContract{
	// 	Name: to.Ptr("eh1"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/loggers"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/loggers/eh1"),
	// 	Properties: &armapimanagement.LoggerContractProperties{
	// 		Description: to.Ptr("updating description"),
	// 		Credentials: map[string]*string{
	// 			"connectionString": to.Ptr("{{Logger-Credentials-5f28745bbebeeb13cc3f7301}}"),
	// 		},
	// 		IsBuffered: to.Ptr(true),
	// 		LoggerType: to.Ptr(armapimanagement.LoggerTypeAzureEventHub),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementDeleteLogger.json
func ExampleLoggerClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewLoggerClient().Delete(ctx, "rg1", "apimService1", "loggerId", "*", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
