//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appconfiguration/armappconfiguration/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ConfigurationStoresServer is a fake server for instances of the armappconfiguration.ConfigurationStoresClient type.
type ConfigurationStoresServer struct {
	// BeginCreate is the fake for method ConfigurationStoresClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, configStoreName string, configStoreCreationParameters armappconfiguration.ConfigurationStore, options *armappconfiguration.ConfigurationStoresClientBeginCreateOptions) (resp azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ConfigurationStoresClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, configStoreName string, options *armappconfiguration.ConfigurationStoresClientBeginDeleteOptions) (resp azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConfigurationStoresClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, configStoreName string, options *armappconfiguration.ConfigurationStoresClientGetOptions) (resp azfake.Responder[armappconfiguration.ConfigurationStoresClientGetResponse], errResp azfake.ErrorResponder)

	// GetDeleted is the fake for method ConfigurationStoresClient.GetDeleted
	// HTTP status codes to indicate success: http.StatusOK
	GetDeleted func(ctx context.Context, location string, configStoreName string, options *armappconfiguration.ConfigurationStoresClientGetDeletedOptions) (resp azfake.Responder[armappconfiguration.ConfigurationStoresClientGetDeletedResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ConfigurationStoresClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armappconfiguration.ConfigurationStoresClientListOptions) (resp azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListResponse])

	// NewListByResourceGroupPager is the fake for method ConfigurationStoresClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armappconfiguration.ConfigurationStoresClientListByResourceGroupOptions) (resp azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListByResourceGroupResponse])

	// NewListDeletedPager is the fake for method ConfigurationStoresClient.NewListDeletedPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListDeletedPager func(options *armappconfiguration.ConfigurationStoresClientListDeletedOptions) (resp azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListDeletedResponse])

	// NewListKeysPager is the fake for method ConfigurationStoresClient.NewListKeysPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListKeysPager func(resourceGroupName string, configStoreName string, options *armappconfiguration.ConfigurationStoresClientListKeysOptions) (resp azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListKeysResponse])

	// BeginPurgeDeleted is the fake for method ConfigurationStoresClient.BeginPurgeDeleted
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginPurgeDeleted func(ctx context.Context, location string, configStoreName string, options *armappconfiguration.ConfigurationStoresClientBeginPurgeDeletedOptions) (resp azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientPurgeDeletedResponse], errResp azfake.ErrorResponder)

	// RegenerateKey is the fake for method ConfigurationStoresClient.RegenerateKey
	// HTTP status codes to indicate success: http.StatusOK
	RegenerateKey func(ctx context.Context, resourceGroupName string, configStoreName string, regenerateKeyParameters armappconfiguration.RegenerateKeyParameters, options *armappconfiguration.ConfigurationStoresClientRegenerateKeyOptions) (resp azfake.Responder[armappconfiguration.ConfigurationStoresClientRegenerateKeyResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ConfigurationStoresClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, configStoreName string, configStoreUpdateParameters armappconfiguration.ConfigurationStoreUpdateParameters, options *armappconfiguration.ConfigurationStoresClientBeginUpdateOptions) (resp azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewConfigurationStoresServerTransport creates a new instance of ConfigurationStoresServerTransport with the provided implementation.
// The returned ConfigurationStoresServerTransport instance is connected to an instance of armappconfiguration.ConfigurationStoresClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConfigurationStoresServerTransport(srv *ConfigurationStoresServer) *ConfigurationStoresServerTransport {
	return &ConfigurationStoresServerTransport{
		srv:                         srv,
		beginCreate:                 newTracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientCreateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientDeleteResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListByResourceGroupResponse]](),
		newListDeletedPager:         newTracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListDeletedResponse]](),
		newListKeysPager:            newTracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListKeysResponse]](),
		beginPurgeDeleted:           newTracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientPurgeDeletedResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientUpdateResponse]](),
	}
}

// ConfigurationStoresServerTransport connects instances of armappconfiguration.ConfigurationStoresClient to instances of ConfigurationStoresServer.
// Don't use this type directly, use NewConfigurationStoresServerTransport instead.
type ConfigurationStoresServerTransport struct {
	srv                         *ConfigurationStoresServer
	beginCreate                 *tracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientCreateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientDeleteResponse]]
	newListPager                *tracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListByResourceGroupResponse]]
	newListDeletedPager         *tracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListDeletedResponse]]
	newListKeysPager            *tracker[azfake.PagerResponder[armappconfiguration.ConfigurationStoresClientListKeysResponse]]
	beginPurgeDeleted           *tracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientPurgeDeletedResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armappconfiguration.ConfigurationStoresClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ConfigurationStoresServerTransport.
func (c *ConfigurationStoresServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConfigurationStoresClient.BeginCreate":
		resp, err = c.dispatchBeginCreate(req)
	case "ConfigurationStoresClient.BeginDelete":
		resp, err = c.dispatchBeginDelete(req)
	case "ConfigurationStoresClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConfigurationStoresClient.GetDeleted":
		resp, err = c.dispatchGetDeleted(req)
	case "ConfigurationStoresClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	case "ConfigurationStoresClient.NewListByResourceGroupPager":
		resp, err = c.dispatchNewListByResourceGroupPager(req)
	case "ConfigurationStoresClient.NewListDeletedPager":
		resp, err = c.dispatchNewListDeletedPager(req)
	case "ConfigurationStoresClient.NewListKeysPager":
		resp, err = c.dispatchNewListKeysPager(req)
	case "ConfigurationStoresClient.BeginPurgeDeleted":
		resp, err = c.dispatchBeginPurgeDeleted(req)
	case "ConfigurationStoresClient.RegenerateKey":
		resp, err = c.dispatchRegenerateKey(req)
	case "ConfigurationStoresClient.BeginUpdate":
		resp, err = c.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := c.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappconfiguration.ConfigurationStore](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginCreate(req.Context(), resourceGroupNameParam, configStoreNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		c.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		c.beginCreate.remove(req)
	}

	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if c.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := c.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginDelete(req.Context(), resourceGroupNameParam, configStoreNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		c.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		c.beginDelete.remove(req)
	}

	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, configStoreNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConfigurationStore, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchGetDeleted(req *http.Request) (*http.Response, error) {
	if c.srv.GetDeleted == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeleted not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deletedConfigurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetDeleted(req.Context(), locationParam, configStoreNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeletedConfigurationStore, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armappconfiguration.ConfigurationStoresClientListOptions
		if skipTokenParam != nil {
			options = &armappconfiguration.ConfigurationStoresClientListOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListPager(options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappconfiguration.ConfigurationStoresClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := c.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armappconfiguration.ConfigurationStoresClientListByResourceGroupOptions
		if skipTokenParam != nil {
			options = &armappconfiguration.ConfigurationStoresClientListByResourceGroupOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListByResourceGroupPager(resourceGroupNameParam, options)
		newListByResourceGroupPager = &resp
		c.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armappconfiguration.ConfigurationStoresClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		c.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchNewListDeletedPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListDeletedPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListDeletedPager not implemented")}
	}
	newListDeletedPager := c.newListDeletedPager.get(req)
	if newListDeletedPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/deletedConfigurationStores`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := c.srv.NewListDeletedPager(nil)
		newListDeletedPager = &resp
		c.newListDeletedPager.add(req, newListDeletedPager)
		server.PagerResponderInjectNextLinks(newListDeletedPager, req, func(page *armappconfiguration.ConfigurationStoresClientListDeletedResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListDeletedPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListDeletedPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListDeletedPager) {
		c.newListDeletedPager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchNewListKeysPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListKeysPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListKeysPager not implemented")}
	}
	newListKeysPager := c.newListKeysPager.get(req)
	if newListKeysPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listKeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armappconfiguration.ConfigurationStoresClientListKeysOptions
		if skipTokenParam != nil {
			options = &armappconfiguration.ConfigurationStoresClientListKeysOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListKeysPager(resourceGroupNameParam, configStoreNameParam, options)
		newListKeysPager = &resp
		c.newListKeysPager.add(req, newListKeysPager)
		server.PagerResponderInjectNextLinks(newListKeysPager, req, func(page *armappconfiguration.ConfigurationStoresClientListKeysResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListKeysPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListKeysPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListKeysPager) {
		c.newListKeysPager.remove(req)
	}
	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchBeginPurgeDeleted(req *http.Request) (*http.Response, error) {
	if c.srv.BeginPurgeDeleted == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPurgeDeleted not implemented")}
	}
	beginPurgeDeleted := c.beginPurgeDeleted.get(req)
	if beginPurgeDeleted == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deletedConfigurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/purge`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
		if err != nil {
			return nil, err
		}
		configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginPurgeDeleted(req.Context(), locationParam, configStoreNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPurgeDeleted = &respr
		c.beginPurgeDeleted.add(req, beginPurgeDeleted)
	}

	resp, err := server.PollerResponderNext(beginPurgeDeleted, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		c.beginPurgeDeleted.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPurgeDeleted) {
		c.beginPurgeDeleted.remove(req)
	}

	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchRegenerateKey(req *http.Request) (*http.Response, error) {
	if c.srv.RegenerateKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegenerateKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armappconfiguration.RegenerateKeyParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.RegenerateKey(req.Context(), resourceGroupNameParam, configStoreNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).APIKey, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConfigurationStoresServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := c.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppConfiguration/configurationStores/(?P<configStoreName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappconfiguration.ConfigurationStoreUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		configStoreNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("configStoreName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := c.srv.BeginUpdate(req.Context(), resourceGroupNameParam, configStoreNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		c.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		c.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		c.beginUpdate.remove(req)
	}

	return resp, nil
}
