//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevtestlabs

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The subscription ID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewArmTemplatesClient creates a new instance of ArmTemplatesClient.
func (c *ClientFactory) NewArmTemplatesClient() *ArmTemplatesClient {
	subClient, _ := NewArmTemplatesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewArtifactSourcesClient creates a new instance of ArtifactSourcesClient.
func (c *ClientFactory) NewArtifactSourcesClient() *ArtifactSourcesClient {
	subClient, _ := NewArtifactSourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewArtifactsClient creates a new instance of ArtifactsClient.
func (c *ClientFactory) NewArtifactsClient() *ArtifactsClient {
	subClient, _ := NewArtifactsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCostsClient creates a new instance of CostsClient.
func (c *ClientFactory) NewCostsClient() *CostsClient {
	subClient, _ := NewCostsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewCustomImagesClient creates a new instance of CustomImagesClient.
func (c *ClientFactory) NewCustomImagesClient() *CustomImagesClient {
	subClient, _ := NewCustomImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDisksClient creates a new instance of DisksClient.
func (c *ClientFactory) NewDisksClient() *DisksClient {
	subClient, _ := NewDisksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEnvironmentsClient creates a new instance of EnvironmentsClient.
func (c *ClientFactory) NewEnvironmentsClient() *EnvironmentsClient {
	subClient, _ := NewEnvironmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewFormulasClient creates a new instance of FormulasClient.
func (c *ClientFactory) NewFormulasClient() *FormulasClient {
	subClient, _ := NewFormulasClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGalleryImagesClient creates a new instance of GalleryImagesClient.
func (c *ClientFactory) NewGalleryImagesClient() *GalleryImagesClient {
	subClient, _ := NewGalleryImagesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGlobalSchedulesClient creates a new instance of GlobalSchedulesClient.
func (c *ClientFactory) NewGlobalSchedulesClient() *GlobalSchedulesClient {
	subClient, _ := NewGlobalSchedulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewLabsClient creates a new instance of LabsClient.
func (c *ClientFactory) NewLabsClient() *LabsClient {
	subClient, _ := NewLabsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNotificationChannelsClient creates a new instance of NotificationChannelsClient.
func (c *ClientFactory) NewNotificationChannelsClient() *NotificationChannelsClient {
	subClient, _ := NewNotificationChannelsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPoliciesClient creates a new instance of PoliciesClient.
func (c *ClientFactory) NewPoliciesClient() *PoliciesClient {
	subClient, _ := NewPoliciesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPolicySetsClient creates a new instance of PolicySetsClient.
func (c *ClientFactory) NewPolicySetsClient() *PolicySetsClient {
	subClient, _ := NewPolicySetsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewProviderOperationsClient creates a new instance of ProviderOperationsClient.
func (c *ClientFactory) NewProviderOperationsClient() *ProviderOperationsClient {
	subClient, _ := NewProviderOperationsClient(c.credential, c.options)
	return subClient
}

// NewSchedulesClient creates a new instance of SchedulesClient.
func (c *ClientFactory) NewSchedulesClient() *SchedulesClient {
	subClient, _ := NewSchedulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSecretsClient creates a new instance of SecretsClient.
func (c *ClientFactory) NewSecretsClient() *SecretsClient {
	subClient, _ := NewSecretsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServiceFabricSchedulesClient creates a new instance of ServiceFabricSchedulesClient.
func (c *ClientFactory) NewServiceFabricSchedulesClient() *ServiceFabricSchedulesClient {
	subClient, _ := NewServiceFabricSchedulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServiceFabricsClient creates a new instance of ServiceFabricsClient.
func (c *ClientFactory) NewServiceFabricsClient() *ServiceFabricsClient {
	subClient, _ := NewServiceFabricsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServiceRunnersClient creates a new instance of ServiceRunnersClient.
func (c *ClientFactory) NewServiceRunnersClient() *ServiceRunnersClient {
	subClient, _ := NewServiceRunnersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewUsersClient creates a new instance of UsersClient.
func (c *ClientFactory) NewUsersClient() *UsersClient {
	subClient, _ := NewUsersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachineSchedulesClient creates a new instance of VirtualMachineSchedulesClient.
func (c *ClientFactory) NewVirtualMachineSchedulesClient() *VirtualMachineSchedulesClient {
	subClient, _ := NewVirtualMachineSchedulesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualMachinesClient creates a new instance of VirtualMachinesClient.
func (c *ClientFactory) NewVirtualMachinesClient() *VirtualMachinesClient {
	subClient, _ := NewVirtualMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVirtualNetworksClient creates a new instance of VirtualNetworksClient.
func (c *ClientFactory) NewVirtualNetworksClient() *VirtualNetworksClient {
	subClient, _ := NewVirtualNetworksClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
