//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/providerhub/armproviderhub"
	"net/http"
	"net/url"
	"regexp"
)

// ResourceTypeRegistrationsServer is a fake server for instances of the armproviderhub.ResourceTypeRegistrationsClient type.
type ResourceTypeRegistrationsServer struct {
	// BeginCreateOrUpdate is the fake for method ResourceTypeRegistrationsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, providerNamespace string, resourceType string, properties armproviderhub.ResourceTypeRegistration, options *armproviderhub.ResourceTypeRegistrationsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armproviderhub.ResourceTypeRegistrationsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ResourceTypeRegistrationsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, providerNamespace string, resourceType string, options *armproviderhub.ResourceTypeRegistrationsClientDeleteOptions) (resp azfake.Responder[armproviderhub.ResourceTypeRegistrationsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ResourceTypeRegistrationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, providerNamespace string, resourceType string, options *armproviderhub.ResourceTypeRegistrationsClientGetOptions) (resp azfake.Responder[armproviderhub.ResourceTypeRegistrationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByProviderRegistrationPager is the fake for method ResourceTypeRegistrationsClient.NewListByProviderRegistrationPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProviderRegistrationPager func(providerNamespace string, options *armproviderhub.ResourceTypeRegistrationsClientListByProviderRegistrationOptions) (resp azfake.PagerResponder[armproviderhub.ResourceTypeRegistrationsClientListByProviderRegistrationResponse])
}

// NewResourceTypeRegistrationsServerTransport creates a new instance of ResourceTypeRegistrationsServerTransport with the provided implementation.
// The returned ResourceTypeRegistrationsServerTransport instance is connected to an instance of armproviderhub.ResourceTypeRegistrationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceTypeRegistrationsServerTransport(srv *ResourceTypeRegistrationsServer) *ResourceTypeRegistrationsServerTransport {
	return &ResourceTypeRegistrationsServerTransport{
		srv:                                srv,
		beginCreateOrUpdate:                newTracker[azfake.PollerResponder[armproviderhub.ResourceTypeRegistrationsClientCreateOrUpdateResponse]](),
		newListByProviderRegistrationPager: newTracker[azfake.PagerResponder[armproviderhub.ResourceTypeRegistrationsClientListByProviderRegistrationResponse]](),
	}
}

// ResourceTypeRegistrationsServerTransport connects instances of armproviderhub.ResourceTypeRegistrationsClient to instances of ResourceTypeRegistrationsServer.
// Don't use this type directly, use NewResourceTypeRegistrationsServerTransport instead.
type ResourceTypeRegistrationsServerTransport struct {
	srv                                *ResourceTypeRegistrationsServer
	beginCreateOrUpdate                *tracker[azfake.PollerResponder[armproviderhub.ResourceTypeRegistrationsClientCreateOrUpdateResponse]]
	newListByProviderRegistrationPager *tracker[azfake.PagerResponder[armproviderhub.ResourceTypeRegistrationsClientListByProviderRegistrationResponse]]
}

// Do implements the policy.Transporter interface for ResourceTypeRegistrationsServerTransport.
func (r *ResourceTypeRegistrationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceTypeRegistrationsClient.BeginCreateOrUpdate":
		resp, err = r.dispatchBeginCreateOrUpdate(req)
	case "ResourceTypeRegistrationsClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "ResourceTypeRegistrationsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ResourceTypeRegistrationsClient.NewListByProviderRegistrationPager":
		resp, err = r.dispatchNewListByProviderRegistrationPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceTypeRegistrationsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := r.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armproviderhub.ResourceTypeRegistration](req)
		if err != nil {
			return nil, err
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreateOrUpdate(req.Context(), providerNamespaceParam, resourceTypeParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		r.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		r.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		r.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (r *ResourceTypeRegistrationsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Delete(req.Context(), providerNamespaceParam, resourceTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceTypeRegistrationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), providerNamespaceParam, resourceTypeParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceTypeRegistration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceTypeRegistrationsServerTransport) dispatchNewListByProviderRegistrationPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByProviderRegistrationPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProviderRegistrationPager not implemented")}
	}
	newListByProviderRegistrationPager := r.newListByProviderRegistrationPager.get(req)
	if newListByProviderRegistrationPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ProviderHub/providerRegistrations/(?P<providerNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcetypeRegistrations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		providerNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("providerNamespace")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByProviderRegistrationPager(providerNamespaceParam, nil)
		newListByProviderRegistrationPager = &resp
		r.newListByProviderRegistrationPager.add(req, newListByProviderRegistrationPager)
		server.PagerResponderInjectNextLinks(newListByProviderRegistrationPager, req, func(page *armproviderhub.ResourceTypeRegistrationsClientListByProviderRegistrationResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByProviderRegistrationPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByProviderRegistrationPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProviderRegistrationPager) {
		r.newListByProviderRegistrationPager.remove(req)
	}
	return resp, nil
}
