// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/identitytoolkit/v2/account_management_service.proto

package identitytoolkitpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Finishes enrolling a second factor for the user.
type FinalizeMfaEnrollmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID token.
	IdToken string `protobuf:"bytes,1,opt,name=id_token,json=idToken,proto3" json:"id_token,omitempty"`
	// Display name which is entered  by users to distinguish between different
	// second factors with same type or different type.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// MFA enrollment information to be verified.
	//
	// Types that are assignable to VerificationInfo:
	//
	//	*FinalizeMfaEnrollmentRequest_PhoneVerificationInfo
	VerificationInfo isFinalizeMfaEnrollmentRequest_VerificationInfo `protobuf_oneof:"verification_info"`
	// The ID of the Identity Platform tenant that the user enrolling MFA belongs
	// to. If not set, the user belongs to the default Identity Platform project.
	TenantId string `protobuf:"bytes,5,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
}

func (x *FinalizeMfaEnrollmentRequest) Reset() {
	*x = FinalizeMfaEnrollmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeMfaEnrollmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeMfaEnrollmentRequest) ProtoMessage() {}

func (x *FinalizeMfaEnrollmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeMfaEnrollmentRequest.ProtoReflect.Descriptor instead.
func (*FinalizeMfaEnrollmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescGZIP(), []int{0}
}

func (x *FinalizeMfaEnrollmentRequest) GetIdToken() string {
	if x != nil {
		return x.IdToken
	}
	return ""
}

func (x *FinalizeMfaEnrollmentRequest) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *FinalizeMfaEnrollmentRequest) GetVerificationInfo() isFinalizeMfaEnrollmentRequest_VerificationInfo {
	if m != nil {
		return m.VerificationInfo
	}
	return nil
}

func (x *FinalizeMfaEnrollmentRequest) GetPhoneVerificationInfo() *FinalizeMfaPhoneRequestInfo {
	if x, ok := x.GetVerificationInfo().(*FinalizeMfaEnrollmentRequest_PhoneVerificationInfo); ok {
		return x.PhoneVerificationInfo
	}
	return nil
}

func (x *FinalizeMfaEnrollmentRequest) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

type isFinalizeMfaEnrollmentRequest_VerificationInfo interface {
	isFinalizeMfaEnrollmentRequest_VerificationInfo()
}

type FinalizeMfaEnrollmentRequest_PhoneVerificationInfo struct {
	// Verification info to authorize sending an SMS for phone verification.
	PhoneVerificationInfo *FinalizeMfaPhoneRequestInfo `protobuf:"bytes,4,opt,name=phone_verification_info,json=phoneVerificationInfo,proto3,oneof"`
}

func (*FinalizeMfaEnrollmentRequest_PhoneVerificationInfo) isFinalizeMfaEnrollmentRequest_VerificationInfo() {
}

// FinalizeMfaEnrollment response.
type FinalizeMfaEnrollmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID token updated to reflect MFA enrollment.
	IdToken string `protobuf:"bytes,1,opt,name=id_token,json=idToken,proto3" json:"id_token,omitempty"`
	// Refresh token updated to reflect MFA enrollment.
	RefreshToken string `protobuf:"bytes,2,opt,name=refresh_token,json=refreshToken,proto3" json:"refresh_token,omitempty"`
	// MFA verified enrollment information.
	//
	// Types that are assignable to AuxiliaryAuthInfo:
	//
	//	*FinalizeMfaEnrollmentResponse_PhoneAuthInfo
	AuxiliaryAuthInfo isFinalizeMfaEnrollmentResponse_AuxiliaryAuthInfo `protobuf_oneof:"auxiliary_auth_info"`
}

func (x *FinalizeMfaEnrollmentResponse) Reset() {
	*x = FinalizeMfaEnrollmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FinalizeMfaEnrollmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeMfaEnrollmentResponse) ProtoMessage() {}

func (x *FinalizeMfaEnrollmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeMfaEnrollmentResponse.ProtoReflect.Descriptor instead.
func (*FinalizeMfaEnrollmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescGZIP(), []int{1}
}

func (x *FinalizeMfaEnrollmentResponse) GetIdToken() string {
	if x != nil {
		return x.IdToken
	}
	return ""
}

func (x *FinalizeMfaEnrollmentResponse) GetRefreshToken() string {
	if x != nil {
		return x.RefreshToken
	}
	return ""
}

func (m *FinalizeMfaEnrollmentResponse) GetAuxiliaryAuthInfo() isFinalizeMfaEnrollmentResponse_AuxiliaryAuthInfo {
	if m != nil {
		return m.AuxiliaryAuthInfo
	}
	return nil
}

func (x *FinalizeMfaEnrollmentResponse) GetPhoneAuthInfo() *FinalizeMfaPhoneResponseInfo {
	if x, ok := x.GetAuxiliaryAuthInfo().(*FinalizeMfaEnrollmentResponse_PhoneAuthInfo); ok {
		return x.PhoneAuthInfo
	}
	return nil
}

type isFinalizeMfaEnrollmentResponse_AuxiliaryAuthInfo interface {
	isFinalizeMfaEnrollmentResponse_AuxiliaryAuthInfo()
}

type FinalizeMfaEnrollmentResponse_PhoneAuthInfo struct {
	// Auxiliary auth info specific to phone auth.
	PhoneAuthInfo *FinalizeMfaPhoneResponseInfo `protobuf:"bytes,3,opt,name=phone_auth_info,json=phoneAuthInfo,proto3,oneof"`
}

func (*FinalizeMfaEnrollmentResponse_PhoneAuthInfo) isFinalizeMfaEnrollmentResponse_AuxiliaryAuthInfo() {
}

// Sends MFA enrollment verification SMS for a user.
type StartMfaEnrollmentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User's ID token.
	IdToken string `protobuf:"bytes,1,opt,name=id_token,json=idToken,proto3" json:"id_token,omitempty"`
	// MFA information by type of 2nd factor.
	//
	// Types that are assignable to EnrollmentInfo:
	//
	//	*StartMfaEnrollmentRequest_PhoneEnrollmentInfo
	EnrollmentInfo isStartMfaEnrollmentRequest_EnrollmentInfo `protobuf_oneof:"enrollment_info"`
	// The ID of the Identity Platform tenant that the user enrolling MFA belongs
	// to. If not set, the user belongs to the default Identity Platform project.
	TenantId string `protobuf:"bytes,4,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
}

func (x *StartMfaEnrollmentRequest) Reset() {
	*x = StartMfaEnrollmentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartMfaEnrollmentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMfaEnrollmentRequest) ProtoMessage() {}

func (x *StartMfaEnrollmentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMfaEnrollmentRequest.ProtoReflect.Descriptor instead.
func (*StartMfaEnrollmentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescGZIP(), []int{2}
}

func (x *StartMfaEnrollmentRequest) GetIdToken() string {
	if x != nil {
		return x.IdToken
	}
	return ""
}

func (m *StartMfaEnrollmentRequest) GetEnrollmentInfo() isStartMfaEnrollmentRequest_EnrollmentInfo {
	if m != nil {
		return m.EnrollmentInfo
	}
	return nil
}

func (x *StartMfaEnrollmentRequest) GetPhoneEnrollmentInfo() *StartMfaPhoneRequestInfo {
	if x, ok := x.GetEnrollmentInfo().(*StartMfaEnrollmentRequest_PhoneEnrollmentInfo); ok {
		return x.PhoneEnrollmentInfo
	}
	return nil
}

func (x *StartMfaEnrollmentRequest) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

type isStartMfaEnrollmentRequest_EnrollmentInfo interface {
	isStartMfaEnrollmentRequest_EnrollmentInfo()
}

type StartMfaEnrollmentRequest_PhoneEnrollmentInfo struct {
	// Verification info to authorize sending an SMS for phone verification.
	PhoneEnrollmentInfo *StartMfaPhoneRequestInfo `protobuf:"bytes,3,opt,name=phone_enrollment_info,json=phoneEnrollmentInfo,proto3,oneof"`
}

func (*StartMfaEnrollmentRequest_PhoneEnrollmentInfo) isStartMfaEnrollmentRequest_EnrollmentInfo() {}

// StartMfaEnrollment response.
type StartMfaEnrollmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// MFA start enrollment response by 2nd factor type.
	//
	// Types that are assignable to EnrollmentResponse:
	//
	//	*StartMfaEnrollmentResponse_PhoneSessionInfo
	EnrollmentResponse isStartMfaEnrollmentResponse_EnrollmentResponse `protobuf_oneof:"enrollment_response"`
}

func (x *StartMfaEnrollmentResponse) Reset() {
	*x = StartMfaEnrollmentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartMfaEnrollmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMfaEnrollmentResponse) ProtoMessage() {}

func (x *StartMfaEnrollmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMfaEnrollmentResponse.ProtoReflect.Descriptor instead.
func (*StartMfaEnrollmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescGZIP(), []int{3}
}

func (m *StartMfaEnrollmentResponse) GetEnrollmentResponse() isStartMfaEnrollmentResponse_EnrollmentResponse {
	if m != nil {
		return m.EnrollmentResponse
	}
	return nil
}

func (x *StartMfaEnrollmentResponse) GetPhoneSessionInfo() *StartMfaPhoneResponseInfo {
	if x, ok := x.GetEnrollmentResponse().(*StartMfaEnrollmentResponse_PhoneSessionInfo); ok {
		return x.PhoneSessionInfo
	}
	return nil
}

type isStartMfaEnrollmentResponse_EnrollmentResponse interface {
	isStartMfaEnrollmentResponse_EnrollmentResponse()
}

type StartMfaEnrollmentResponse_PhoneSessionInfo struct {
	// Verification info to authorize sending an SMS for phone verification.
	PhoneSessionInfo *StartMfaPhoneResponseInfo `protobuf:"bytes,1,opt,name=phone_session_info,json=phoneSessionInfo,proto3,oneof"`
}

func (*StartMfaEnrollmentResponse_PhoneSessionInfo) isStartMfaEnrollmentResponse_EnrollmentResponse() {
}

// Withdraws MFA.
type WithdrawMfaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. User's ID token.
	IdToken string `protobuf:"bytes,1,opt,name=id_token,json=idToken,proto3" json:"id_token,omitempty"`
	// Required. MFA enrollment id from a current MFA enrollment.
	MfaEnrollmentId string `protobuf:"bytes,2,opt,name=mfa_enrollment_id,json=mfaEnrollmentId,proto3" json:"mfa_enrollment_id,omitempty"`
	// The ID of the Identity Platform tenant that the user unenrolling MFA
	// belongs to. If not set, the user belongs to the default Identity Platform
	// project.
	TenantId string `protobuf:"bytes,3,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
}

func (x *WithdrawMfaRequest) Reset() {
	*x = WithdrawMfaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WithdrawMfaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WithdrawMfaRequest) ProtoMessage() {}

func (x *WithdrawMfaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WithdrawMfaRequest.ProtoReflect.Descriptor instead.
func (*WithdrawMfaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescGZIP(), []int{4}
}

func (x *WithdrawMfaRequest) GetIdToken() string {
	if x != nil {
		return x.IdToken
	}
	return ""
}

func (x *WithdrawMfaRequest) GetMfaEnrollmentId() string {
	if x != nil {
		return x.MfaEnrollmentId
	}
	return ""
}

func (x *WithdrawMfaRequest) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

// Withdraws MultiFactorAuth response.
type WithdrawMfaResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID token updated to reflect removal of the second factor.
	IdToken string `protobuf:"bytes,1,opt,name=id_token,json=idToken,proto3" json:"id_token,omitempty"`
	// Refresh token updated to reflect removal of the second factor.
	RefreshToken string `protobuf:"bytes,2,opt,name=refresh_token,json=refreshToken,proto3" json:"refresh_token,omitempty"`
}

func (x *WithdrawMfaResponse) Reset() {
	*x = WithdrawMfaResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WithdrawMfaResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WithdrawMfaResponse) ProtoMessage() {}

func (x *WithdrawMfaResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WithdrawMfaResponse.ProtoReflect.Descriptor instead.
func (*WithdrawMfaResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescGZIP(), []int{5}
}

func (x *WithdrawMfaResponse) GetIdToken() string {
	if x != nil {
		return x.IdToken
	}
	return ""
}

func (x *WithdrawMfaResponse) GetRefreshToken() string {
	if x != nil {
		return x.RefreshToken
	}
	return ""
}

var File_google_cloud_identitytoolkit_v2_account_management_service_proto protoreflect.FileDescriptor

var file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2f, 0x76,
	0x32, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74,
	0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2f, 0x76, 0x32, 0x2f, 0x6d, 0x66, 0x61,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8b, 0x02, 0x0a, 0x1c,
	0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08,
	0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x76, 0x0a, 0x17, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e,
	0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x66, 0x61, 0x50, 0x68,
	0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00,
	0x52, 0x15, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x65, 0x6e, 0x61,
	0x6e, 0x74, 0x49, 0x64, 0x42, 0x13, 0x0a, 0x11, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0xdf, 0x01, 0x0a, 0x1d, 0x46, 0x69,
	0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x69,
	0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69,
	0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72,
	0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x67, 0x0a, 0x0f, 0x70,
	0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c,
	0x6b, 0x69, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d,
	0x66, 0x61, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x15, 0x0a, 0x13, 0x61, 0x75, 0x78, 0x69, 0x6c, 0x69, 0x61, 0x72,
	0x79, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0xdc, 0x01, 0x0a, 0x19,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x69, 0x64, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x6f, 0x0a, 0x15, 0x70, 0x68, 0x6f,
	0x6e, 0x65, 0x5f, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74,
	0x4d, 0x66, 0x61, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x13, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x45, 0x6e, 0x72, 0x6f,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x65,
	0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x9f, 0x01, 0x0a, 0x1a, 0x53,
	0x74, 0x61, 0x72, 0x74, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a, 0x0a, 0x12, 0x70, 0x68, 0x6f,
	0x6e, 0x65, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f,
	0x6c, 0x6b, 0x69, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x66, 0x61,
	0x50, 0x68, 0x6f, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x6e, 0x66,
	0x6f, 0x48, 0x00, 0x52, 0x10, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x15, 0x0a, 0x13, 0x65, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d,
	0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x82, 0x01, 0x0a,
	0x12, 0x57, 0x69, 0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x4d, 0x66, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x69, 0x64, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x66, 0x61, 0x5f, 0x65, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x6d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49,
	0x64, 0x22, 0x55, 0x0a, 0x13, 0x57, 0x69, 0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x4d, 0x66, 0x61,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x69, 0x64, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x9f, 0x05, 0x0a, 0x18, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc6, 0x01, 0x0a, 0x15, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72,
	0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e, 0x76, 0x32,
	0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x3a, 0x01, 0x2a, 0x22, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x6d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x12, 0xba,
	0x01, 0x0a, 0x12, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f,
	0x6c, 0x6b, 0x69, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x66, 0x61,
	0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74,
	0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x3a, 0x01, 0x2a, 0x22, 0x20, 0x2f, 0x76, 0x32, 0x2f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x6d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0xa8, 0x01, 0x0a, 0x0b,
	0x57, 0x69, 0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x4d, 0x66, 0x61, 0x12, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e, 0x76, 0x32, 0x2e, 0x57, 0x69,
	0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x4d, 0x66, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e,
	0x76, 0x32, 0x2e, 0x57, 0x69, 0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x4d, 0x66, 0x61, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x28, 0x3a, 0x01,
	0x2a, 0x22, 0x23, 0x2f, 0x76, 0x32, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x6d, 0x66, 0x61, 0x45, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x3a, 0x77, 0x69,
	0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xdf, 0x01, 0x0a, 0x23, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2e,
	0x76, 0x32, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x70,
	0x62, 0x3b, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x74, 0x6f, 0x6f, 0x6c, 0x6b, 0x69,
	0x74, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6f, 0x6c, 0x6b,
	0x69, 0x74, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6f,
	0x6c, 0x6b, 0x69, 0x74, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x6f, 0x6f, 0x6c, 0x6b, 0x69, 0x74, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescOnce sync.Once
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescData = file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDesc
)

func file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescGZIP() []byte {
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescData)
	})
	return file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDescData
}

var file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_identitytoolkit_v2_account_management_service_proto_goTypes = []interface{}{
	(*FinalizeMfaEnrollmentRequest)(nil),  // 0: google.cloud.identitytoolkit.v2.FinalizeMfaEnrollmentRequest
	(*FinalizeMfaEnrollmentResponse)(nil), // 1: google.cloud.identitytoolkit.v2.FinalizeMfaEnrollmentResponse
	(*StartMfaEnrollmentRequest)(nil),     // 2: google.cloud.identitytoolkit.v2.StartMfaEnrollmentRequest
	(*StartMfaEnrollmentResponse)(nil),    // 3: google.cloud.identitytoolkit.v2.StartMfaEnrollmentResponse
	(*WithdrawMfaRequest)(nil),            // 4: google.cloud.identitytoolkit.v2.WithdrawMfaRequest
	(*WithdrawMfaResponse)(nil),           // 5: google.cloud.identitytoolkit.v2.WithdrawMfaResponse
	(*FinalizeMfaPhoneRequestInfo)(nil),   // 6: google.cloud.identitytoolkit.v2.FinalizeMfaPhoneRequestInfo
	(*FinalizeMfaPhoneResponseInfo)(nil),  // 7: google.cloud.identitytoolkit.v2.FinalizeMfaPhoneResponseInfo
	(*StartMfaPhoneRequestInfo)(nil),      // 8: google.cloud.identitytoolkit.v2.StartMfaPhoneRequestInfo
	(*StartMfaPhoneResponseInfo)(nil),     // 9: google.cloud.identitytoolkit.v2.StartMfaPhoneResponseInfo
}
var file_google_cloud_identitytoolkit_v2_account_management_service_proto_depIdxs = []int32{
	6, // 0: google.cloud.identitytoolkit.v2.FinalizeMfaEnrollmentRequest.phone_verification_info:type_name -> google.cloud.identitytoolkit.v2.FinalizeMfaPhoneRequestInfo
	7, // 1: google.cloud.identitytoolkit.v2.FinalizeMfaEnrollmentResponse.phone_auth_info:type_name -> google.cloud.identitytoolkit.v2.FinalizeMfaPhoneResponseInfo
	8, // 2: google.cloud.identitytoolkit.v2.StartMfaEnrollmentRequest.phone_enrollment_info:type_name -> google.cloud.identitytoolkit.v2.StartMfaPhoneRequestInfo
	9, // 3: google.cloud.identitytoolkit.v2.StartMfaEnrollmentResponse.phone_session_info:type_name -> google.cloud.identitytoolkit.v2.StartMfaPhoneResponseInfo
	0, // 4: google.cloud.identitytoolkit.v2.AccountManagementService.FinalizeMfaEnrollment:input_type -> google.cloud.identitytoolkit.v2.FinalizeMfaEnrollmentRequest
	2, // 5: google.cloud.identitytoolkit.v2.AccountManagementService.StartMfaEnrollment:input_type -> google.cloud.identitytoolkit.v2.StartMfaEnrollmentRequest
	4, // 6: google.cloud.identitytoolkit.v2.AccountManagementService.WithdrawMfa:input_type -> google.cloud.identitytoolkit.v2.WithdrawMfaRequest
	1, // 7: google.cloud.identitytoolkit.v2.AccountManagementService.FinalizeMfaEnrollment:output_type -> google.cloud.identitytoolkit.v2.FinalizeMfaEnrollmentResponse
	3, // 8: google.cloud.identitytoolkit.v2.AccountManagementService.StartMfaEnrollment:output_type -> google.cloud.identitytoolkit.v2.StartMfaEnrollmentResponse
	5, // 9: google.cloud.identitytoolkit.v2.AccountManagementService.WithdrawMfa:output_type -> google.cloud.identitytoolkit.v2.WithdrawMfaResponse
	7, // [7:10] is the sub-list for method output_type
	4, // [4:7] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_identitytoolkit_v2_account_management_service_proto_init() }
func file_google_cloud_identitytoolkit_v2_account_management_service_proto_init() {
	if File_google_cloud_identitytoolkit_v2_account_management_service_proto != nil {
		return
	}
	file_google_cloud_identitytoolkit_v2_mfa_info_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeMfaEnrollmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FinalizeMfaEnrollmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartMfaEnrollmentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartMfaEnrollmentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WithdrawMfaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WithdrawMfaResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*FinalizeMfaEnrollmentRequest_PhoneVerificationInfo)(nil),
	}
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*FinalizeMfaEnrollmentResponse_PhoneAuthInfo)(nil),
	}
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*StartMfaEnrollmentRequest_PhoneEnrollmentInfo)(nil),
	}
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*StartMfaEnrollmentResponse_PhoneSessionInfo)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_identitytoolkit_v2_account_management_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_identitytoolkit_v2_account_management_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_identitytoolkit_v2_account_management_service_proto_msgTypes,
	}.Build()
	File_google_cloud_identitytoolkit_v2_account_management_service_proto = out.File
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_rawDesc = nil
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_goTypes = nil
	file_google_cloud_identitytoolkit_v2_account_management_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccountManagementServiceClient is the client API for AccountManagementService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccountManagementServiceClient interface {
	// Finishes enrolling a second factor for the user.
	FinalizeMfaEnrollment(ctx context.Context, in *FinalizeMfaEnrollmentRequest, opts ...grpc.CallOption) (*FinalizeMfaEnrollmentResponse, error)
	// Step one of the MFA enrollment process. In SMS case, this sends an
	// SMS verification code to the user.
	StartMfaEnrollment(ctx context.Context, in *StartMfaEnrollmentRequest, opts ...grpc.CallOption) (*StartMfaEnrollmentResponse, error)
	// Revokes one second factor from the enrolled second factors for an account.
	WithdrawMfa(ctx context.Context, in *WithdrawMfaRequest, opts ...grpc.CallOption) (*WithdrawMfaResponse, error)
}

type accountManagementServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAccountManagementServiceClient(cc grpc.ClientConnInterface) AccountManagementServiceClient {
	return &accountManagementServiceClient{cc}
}

func (c *accountManagementServiceClient) FinalizeMfaEnrollment(ctx context.Context, in *FinalizeMfaEnrollmentRequest, opts ...grpc.CallOption) (*FinalizeMfaEnrollmentResponse, error) {
	out := new(FinalizeMfaEnrollmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.identitytoolkit.v2.AccountManagementService/FinalizeMfaEnrollment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountManagementServiceClient) StartMfaEnrollment(ctx context.Context, in *StartMfaEnrollmentRequest, opts ...grpc.CallOption) (*StartMfaEnrollmentResponse, error) {
	out := new(StartMfaEnrollmentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.identitytoolkit.v2.AccountManagementService/StartMfaEnrollment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountManagementServiceClient) WithdrawMfa(ctx context.Context, in *WithdrawMfaRequest, opts ...grpc.CallOption) (*WithdrawMfaResponse, error) {
	out := new(WithdrawMfaResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.identitytoolkit.v2.AccountManagementService/WithdrawMfa", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccountManagementServiceServer is the server API for AccountManagementService service.
type AccountManagementServiceServer interface {
	// Finishes enrolling a second factor for the user.
	FinalizeMfaEnrollment(context.Context, *FinalizeMfaEnrollmentRequest) (*FinalizeMfaEnrollmentResponse, error)
	// Step one of the MFA enrollment process. In SMS case, this sends an
	// SMS verification code to the user.
	StartMfaEnrollment(context.Context, *StartMfaEnrollmentRequest) (*StartMfaEnrollmentResponse, error)
	// Revokes one second factor from the enrolled second factors for an account.
	WithdrawMfa(context.Context, *WithdrawMfaRequest) (*WithdrawMfaResponse, error)
}

// UnimplementedAccountManagementServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAccountManagementServiceServer struct {
}

func (*UnimplementedAccountManagementServiceServer) FinalizeMfaEnrollment(context.Context, *FinalizeMfaEnrollmentRequest) (*FinalizeMfaEnrollmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeMfaEnrollment not implemented")
}
func (*UnimplementedAccountManagementServiceServer) StartMfaEnrollment(context.Context, *StartMfaEnrollmentRequest) (*StartMfaEnrollmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartMfaEnrollment not implemented")
}
func (*UnimplementedAccountManagementServiceServer) WithdrawMfa(context.Context, *WithdrawMfaRequest) (*WithdrawMfaResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WithdrawMfa not implemented")
}

func RegisterAccountManagementServiceServer(s *grpc.Server, srv AccountManagementServiceServer) {
	s.RegisterService(&_AccountManagementService_serviceDesc, srv)
}

func _AccountManagementService_FinalizeMfaEnrollment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeMfaEnrollmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountManagementServiceServer).FinalizeMfaEnrollment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.identitytoolkit.v2.AccountManagementService/FinalizeMfaEnrollment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountManagementServiceServer).FinalizeMfaEnrollment(ctx, req.(*FinalizeMfaEnrollmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountManagementService_StartMfaEnrollment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartMfaEnrollmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountManagementServiceServer).StartMfaEnrollment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.identitytoolkit.v2.AccountManagementService/StartMfaEnrollment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountManagementServiceServer).StartMfaEnrollment(ctx, req.(*StartMfaEnrollmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountManagementService_WithdrawMfa_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WithdrawMfaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountManagementServiceServer).WithdrawMfa(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.identitytoolkit.v2.AccountManagementService/WithdrawMfa",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountManagementServiceServer).WithdrawMfa(ctx, req.(*WithdrawMfaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccountManagementService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.identitytoolkit.v2.AccountManagementService",
	HandlerType: (*AccountManagementServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FinalizeMfaEnrollment",
			Handler:    _AccountManagementService_FinalizeMfaEnrollment_Handler,
		},
		{
			MethodName: "StartMfaEnrollment",
			Handler:    _AccountManagementService_StartMfaEnrollment_Handler,
		},
		{
			MethodName: "WithdrawMfa",
			Handler:    _AccountManagementService_WithdrawMfa_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/identitytoolkit/v2/account_management_service.proto",
}
