/*
 *
 *
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Zhen Sun <sunzhen1@kylinos.cn>
 *
 */

#include "widget.h"

#include <KWindowEffects>
#include <QApplication>
// #include <kwidgetutils.h>
#include "ukuiwindowhelper/ukuiwindowhelper.h"

int main(int argc, char *argv[])
{
    //    kdk::KWidgetUtils::highDpiScaling();
    QApplication a(argc, argv);
    Widget w;
    w.show();
    // KWindowEffects::enableBlurBehind(w.winId(), true);
    UkuiWindowHelper *m_ukuiWindowHelper = new UkuiWindowHelper(&w);
#ifdef USE_UKUI_SHELL_PLUGIN
    m_ukuiWindowHelper->setBlurEffect(QRegion(), 0, true);
#else
    KWindowEffects::enableBlurBehind(this->winId(),true);
#endif
    return a.exec();
}
