/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 12077 $ of $
 *
 * $Id:$
 *
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "etherStatsTable.h"


/** @defgroup data_set data_set: Routines to set data
 *
 * These routines are used to set the value for individual objects. The
 * row context is passed, along with the new value.
 * 
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table etherStatsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * RMON-MIB::etherStatsTable is subid 1 of statistics.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.16.1.1, length: 9
 */
    /*
     * NOTE: if you update this chart, please update the versions in
     *       local/mib2c-conf.d/parent-set.m2i
     *       agent/mibgroup/helpers/baby_steps.c
     * while you're at it.
     */
    /*
     ***********************************************************************
     * Baby Steps Flow Chart (2004.06.05)                                  *
     *                                                                     *
     * +--------------+    +================+    U = unconditional path    *
     * |optional state|    ||required state||    S = path for success      *
     * +--------------+    +================+    E = path for error        *
     ***********************************************************************
     *
     *                        +--------------+
     *                        |     pre      |
     *                        |   request    |
     *                        +--------------+
     *                               | U
     * +-------------+        +==============+
     * |    row    |f|<-------||  object    ||
     * |  create   |1|      E ||  lookup    ||
     * +-------------+        +==============+
     *     E |   | S                 | S
     *       |   +------------------>|
     *       |                +==============+
     *       |              E ||   check    ||
     *       |<---------------||   values   ||
     *       |                +==============+
     *       |                       | S
     *       |                +==============+
     *       |       +<-------||   undo     ||
     *       |       |      E ||   setup    ||
     *       |       |        +==============+
     *       |       |               | S
     *       |       |        +==============+
     *       |       |        ||    set     ||-------------------------->+
     *       |       |        ||   value    || E                         |
     *       |       |        +==============+                           |
     *       |       |               | S                                 |
     *       |       |        +--------------+                           |
     *       |       |        |    check     |-------------------------->|
     *       |       |        |  consistency | E                         |
     *       |       |        +--------------+                           |
     *       |       |               | S                                 |
     *       |       |        +==============+         +==============+  |
     *       |       |        ||   commit   ||-------->||     undo   ||  |
     *       |       |        ||            || E       ||    commit  ||  |
     *       |       |        +==============+         +==============+  |
     *       |       |               | S                     U |<--------+
     *       |       |        +--------------+         +==============+
     *       |       |        | irreversible |         ||    undo    ||
     *       |       |        |    commit    |         ||     set    ||
     *       |       |        +--------------+         +==============+
     *       |       |               | U                     U |
     *       |       +-------------->|<------------------------+
     *       |                +==============+
     *       |                ||   undo     ||
     *       |                ||  cleanup   ||
     *       |                +==============+
     *       +---------------------->| U
     *                               |
     *                          (err && f1)------------------->+
     *                               |                         |
     *                        +--------------+         +--------------+
     *                        |    post      |<--------|      row     |
     *                        |   request    |       U |    release   |
     *                        +--------------+         +--------------+
     *
     */

/**
 * Setup up context with information needed to undo a set request.
 *
 * This function will be called before the individual node undo setup
 * functions are called. If you need to do any undo setup that is not
 * related to a specific column, you can do it here.
 *
 * Note that the undo context has been allocated with
 * etherStatsTable_allocate_data(), but may need extra
 * initialization similar to what you may have done in
 * etherStatsTable_rowreq_ctx_init().
 * Note that an individual node's undo_setup function will only be called
 * if that node is being set to a new value.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in the node's undo_setup
 * function, so it won't be done unless it is necessary.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (etherStatsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 */
int
etherStatsTable_undo_setup(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_undo_setup",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:451:M: |-> Setup etherStatsTable undo.
     * set up etherStatsTable undo information, in preparation for a set.
     * Undo storage is in (* etherStatsStatus_val_ptr )*
     */

    return rc;
}                               /* etherStatsTable_undo_setup */

/**
 * Undo a set request.
 *
 * This function will be called before the individual node undo
 * functions are called. If you need to do any undo that is not
 * related to a specific column, you can do it here.
 *
 * Note that an individual node's undo function will only be called
 * if that node is being set to a new value.
 *
 * If there is anything  specific to a particular column (e.g. releasing
 * memory for a string), you should do that setup in the node's undo
 * function, so it won't be done unless it is necessary.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (etherStatsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 */
int
etherStatsTable_undo(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_undo",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:451:M: |-> etherStatsTable undo.
     * etherStatsTable undo information, in response to a failed set.
     * Undo storage is in (* etherStatsStatus_val_ptr )*
     */

    return rc;
}                               /* etherStatsTable_undo_setup */

/**
 * Cleanup up context undo information.
 *
 * This function will be called after set/commit processing. If you
 * allocated any resources in undo_setup, this is the place to release
 * those resources.
 *
 * This function is called regardless of the success or failure of the set
 * request. If you need to perform different steps for cleanup depending
 * on success or failure, you can add a flag to the rowreq_ctx.
 *
 * @param rowreq_ctx
 *        Pointer to the table context (etherStatsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
etherStatsTable_undo_cleanup(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_undo_cleanup",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:452:M: |-> Cleanup etherStatsTable undo.
     * Undo storage is in (* etherStatsStatus_val_ptr )*
     */

    return rc;
}                               /* etherStatsTable_undo_cleanup */

/**
 * commit new values.
 *
 * At this point, you should have done everything you can to ensure that
 * this commit will not fail.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writable columns were
 * set. The definitions for the COLUMN_*_FLAG bits can be found in
 * etherStatsTable_oids.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param etherStatsTable_rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
etherStatsTable_commit(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;
    int             save_flags;

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_commit",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * save flags, then clear until we actually do something
     */
    save_flags = rowreq_ctx->column_set_flags;
    rowreq_ctx->column_set_flags = 0;

    /*
     * commit etherStatsTable data
     * 1) check the column's flag in save_flags to see if it was set.
     * 2) clear the flag when you handle that column
     * 3) set the column's flag in column_set_flags if it needs undo
     *    processing in case of a failure.
     */
    if (save_flags & COLUMN_ETHERSTATSDATASOURCE_FLAG) {
        save_flags &= ~COLUMN_ETHERSTATSDATASOURCE_FLAG;        /* clear etherStatsDataSource */
        /*
         * TODO:482:o: |-> commit column etherStatsDataSource.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "etherStatsTable column etherStatsDataSource commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo etherStatsDataSource
             */
            rowreq_ctx->column_set_flags |=
                COLUMN_ETHERSTATSDATASOURCE_FLAG;
        }
    }

    if (save_flags & COLUMN_ETHERSTATSOWNER_FLAG) {
        save_flags &= ~COLUMN_ETHERSTATSOWNER_FLAG;     /* clear etherStatsOwner */
        /*
         * TODO:482:o: |-> commit column etherStatsOwner.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "etherStatsTable column etherStatsOwner commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo etherStatsOwner
             */
            rowreq_ctx->column_set_flags |= COLUMN_ETHERSTATSOWNER_FLAG;
        }
    }

    if (save_flags & COLUMN_ETHERSTATSSTATUS_FLAG) {
        save_flags &= ~COLUMN_ETHERSTATSSTATUS_FLAG;    /* clear etherStatsStatus */
        /*
         * TODO:482:o: |-> commit column etherStatsStatus.
         */
        rc = -1;
        if (-1 == rc) {
            snmp_log(LOG_ERR,
                     "etherStatsTable column etherStatsStatus commit failed\n");
        } else {
            /*
             * set flag, in case we need to undo etherStatsStatus
             */
            rowreq_ctx->column_set_flags |= COLUMN_ETHERSTATSSTATUS_FLAG;
        }
    }

    /*
     * if we successfully committed this row, set the dirty flag.
     */
    if (MFD_SUCCESS == rc) {
        rowreq_ctx->rowreq_flags |= MFD_ROW_DIRTY;
    }

    if (save_flags) {
        snmp_log(LOG_ERR, "unhandled columns (0x%x) in commit\n",
                 save_flags);
        return MFD_ERROR;
    }

    return rc;
}                               /* etherStatsTable_commit */

/**
 * undo commit new values.
 *
 * Should you need different behavior depending on which columns were
 * set, rowreq_ctx->column_set_flags will indicate which writable columns were
 * set. The definitions for the COLUMN_*_FLAG bits can be found in
 * etherStatsTable_oids.h.
 * A new row will have the MFD_ROW_CREATED bit set in rowreq_flags.
 *
 * @param etherStatsTable_rowreq_ctx
 *        Pointer to the users context.
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error
 */
int
etherStatsTable_undo_commit(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_undo_commit",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:485:M: |-> Undo etherStatsTable commit.
     * check the column's flag in rowreq_ctx->column_set_flags to see
     * if it was set during commit, then undo it.
     *
     * eg: if (rowreq_ctx->column_set_flags & COLUMN__FLAG) {}
     */


    /*
     * if we successfully un-committed this row, clear the dirty flag.
     */
    if (MFD_SUCCESS == rc) {
        rowreq_ctx->rowreq_flags &= ~MFD_ROW_DIRTY;
    }

    return rc;
}                               /* etherStatsTable_undo_commit */

/*
 * TODO:440:M: Implement etherStatsTable node value checks.
 * TODO:450:M: Implement etherStatsTable undo functions.
 * TODO:460:M: Implement etherStatsTable set functions.
 * TODO:480:M: Implement etherStatsTable commit functions.
 */
/*---------------------------------------------------------------------
 * RMON-MIB::etherStatsEntry.etherStatsDataSource
 * etherStatsDataSource is subid 2 of etherStatsEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.16.1.1.1.2
 * Description:
This object identifies the source of the data that
        this etherStats entry is configured to analyze.  This
        source can be any Ethernet interface on this device.
        In order to identify a particular interface, this object
        shall identify the instance of the ifIndex object,
        defined in RFC 2233 [17], for the desired interface.
        For example, if an entry were to receive data from
        interface #1, this object would be set to ifIndex.1.

        The statistics in this group reflect all packets
        on the local network segment attached to the identified
        interface.

        An agent may or may not be able to tell if fundamental
        changes to the media of the interface have occurred and
        necessitate an invalidation of this entry.  For example, a
        hot-pluggable Ethernet card could be pulled out and replaced
        by a token-ring card.  In such a case, if the agent has such
        knowledge of the change, it is recommended that it
        invalidate this entry.

        This object may not be modified if the associated
        etherStatsStatus object is equal to valid(1).
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 *
 * Its syntax is OBJECTID (based on perltype OBJECTID)
 * The net-snmp type is ASN_OBJECT_ID. The C type decl is oid (oid)
 * This data type requires a length.
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param etherStatsDataSource_val_ptr
 *        A oid containing the new value.
 * @param etherStatsDataSource_val_ptr_len
 *        The size (in bytes) of the data pointed to by etherStatsDataSource_val_ptr
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transition from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * etherStatsTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_OBJECT_ID
 *    The length is < sizeof(rowreq_ctx->data.etherStatsDataSource).
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
etherStatsDataSource_check_value(etherStatsTable_rowreq_ctx * rowreq_ctx,
                                 oid * etherStatsDataSource_val_ptr,
                                 size_t etherStatsDataSource_val_ptr_len)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsDataSource_check_value",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);
    netsnmp_assert(NULL != etherStatsDataSource_val_ptr);

    /*
     * TODO:441:o: |-> Check for valid etherStatsDataSource value.
     */

    return MFD_SUCCESS;         /* etherStatsDataSource value not illegal */
}                               /* etherStatsDataSource_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (etherStatsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * etherStatsTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
etherStatsDataSource_undo_setup(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsDataSource_undo_setup",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup etherStatsDataSource undo.
     */
    /*
     * copy etherStatsDataSource and etherStatsDataSource_len data
     * set rowreq_ctx->undo->etherStatsDataSource from rowreq_ctx->data.etherStatsDataSource
     */
    memcpy(rowreq_ctx->undo->etherStatsDataSource,
           rowreq_ctx->data.etherStatsDataSource,
           (rowreq_ctx->data.etherStatsDataSource_len *
            sizeof(rowreq_ctx->undo->etherStatsDataSource[0])));
    rowreq_ctx->undo->etherStatsDataSource_len =
        rowreq_ctx->data.etherStatsDataSource_len;


    return MFD_SUCCESS;
}                               /* etherStatsDataSource_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param etherStatsDataSource_val_ptr
 *        A oid containing the new value.
 * @param etherStatsDataSource_val_ptr_len
 *        The size (in bytes) of the data pointed to by etherStatsDataSource_val_ptr
 */
int
etherStatsDataSource_set(etherStatsTable_rowreq_ctx * rowreq_ctx,
                         oid * etherStatsDataSource_val_ptr,
                         size_t etherStatsDataSource_val_ptr_len)
{

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsDataSource_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);
    netsnmp_assert(NULL != etherStatsDataSource_val_ptr);

    /*
     * TODO:461:M: |-> Set etherStatsDataSource value.
     * set etherStatsDataSource value in rowreq_ctx->data
     */
    memcpy(rowreq_ctx->data.etherStatsDataSource,
           etherStatsDataSource_val_ptr, etherStatsDataSource_val_ptr_len);
    /** convert bytes to number of oid */
    rowreq_ctx->data.etherStatsDataSource_len =
        etherStatsDataSource_val_ptr_len /
        sizeof(etherStatsDataSource_val_ptr[0]);

    return MFD_SUCCESS;
}                               /* etherStatsDataSource_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
etherStatsDataSource_undo(etherStatsTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsDataSource_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up etherStatsDataSource undo.
     */
    /*
     * copy etherStatsDataSource and etherStatsDataSource_len data
     * set rowreq_ctx->data.etherStatsDataSource from rowreq_ctx->undo->etherStatsDataSource
     */
    memcpy(rowreq_ctx->data.etherStatsDataSource,
           rowreq_ctx->undo->etherStatsDataSource,
           (rowreq_ctx->undo->etherStatsDataSource_len *
            sizeof(rowreq_ctx->data.etherStatsDataSource[0])));
    rowreq_ctx->data.etherStatsDataSource_len =
        rowreq_ctx->undo->etherStatsDataSource_len;


    return MFD_SUCCESS;
}                               /* etherStatsDataSource_undo */

/*---------------------------------------------------------------------
 * RMON-MIB::etherStatsEntry.etherStatsOwner
 * etherStatsOwner is subid 20 of etherStatsEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.16.1.1.1.20
 * Description:
The entity that configured this entry and is therefore
        using the resources assigned to it.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   0
 *   settable   1
 *
 * Ranges:  0 - 127;
 *
 * Its syntax is OwnerString (based on perltype OCTETSTR)
 * The net-snmp type is ASN_OCTET_STR. The C type decl is char (char)
 * This data type requires a length.  (Max 127)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param etherStatsOwner_val_ptr
 *        A char containing the new value.
 * @param etherStatsOwner_val_ptr_len
 *        The size (in bytes) of the data pointed to by etherStatsOwner_val_ptr
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transition from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * etherStatsTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_OCTET_STR
 *    The length is < sizeof(rowreq_ctx->data.etherStatsOwner).
 *    The length is in (one of) the range set(s):  0 - 127
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
etherStatsOwner_check_value(etherStatsTable_rowreq_ctx * rowreq_ctx,
                            char *etherStatsOwner_val_ptr,
                            size_t etherStatsOwner_val_ptr_len)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsOwner_check_value",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);
    netsnmp_assert(NULL != etherStatsOwner_val_ptr);

    /*
     * TODO:441:o: |-> Check for valid etherStatsOwner value.
     */

    return MFD_SUCCESS;         /* etherStatsOwner value not illegal */
}                               /* etherStatsOwner_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (etherStatsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * etherStatsTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
etherStatsOwner_undo_setup(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsOwner_undo_setup",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup etherStatsOwner undo.
     */
    /*
     * copy etherStatsOwner and etherStatsOwner_len data
     * set rowreq_ctx->undo->etherStatsOwner from rowreq_ctx->data.etherStatsOwner
     */
    memcpy(rowreq_ctx->undo->etherStatsOwner,
           rowreq_ctx->data.etherStatsOwner,
           (rowreq_ctx->data.etherStatsOwner_len *
            sizeof(rowreq_ctx->undo->etherStatsOwner[0])));
    rowreq_ctx->undo->etherStatsOwner_len =
        rowreq_ctx->data.etherStatsOwner_len;


    return MFD_SUCCESS;
}                               /* etherStatsOwner_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param etherStatsOwner_val_ptr
 *        A char containing the new value.
 * @param etherStatsOwner_val_ptr_len
 *        The size (in bytes) of the data pointed to by etherStatsOwner_val_ptr
 */
int
etherStatsOwner_set(etherStatsTable_rowreq_ctx * rowreq_ctx,
                    char *etherStatsOwner_val_ptr,
                    size_t etherStatsOwner_val_ptr_len)
{

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsOwner_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);
    netsnmp_assert(NULL != etherStatsOwner_val_ptr);

    /*
     * TODO:461:M: |-> Set etherStatsOwner value.
     * set etherStatsOwner value in rowreq_ctx->data
     */
    memcpy(rowreq_ctx->data.etherStatsOwner, etherStatsOwner_val_ptr,
           etherStatsOwner_val_ptr_len);
    /** convert bytes to number of char */
    rowreq_ctx->data.etherStatsOwner_len =
        etherStatsOwner_val_ptr_len / sizeof(etherStatsOwner_val_ptr[0]);

    return MFD_SUCCESS;
}                               /* etherStatsOwner_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
etherStatsOwner_undo(etherStatsTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsOwner_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up etherStatsOwner undo.
     */
    /*
     * copy etherStatsOwner and etherStatsOwner_len data
     * set rowreq_ctx->data.etherStatsOwner from rowreq_ctx->undo->etherStatsOwner
     */
    memcpy(rowreq_ctx->data.etherStatsOwner,
           rowreq_ctx->undo->etherStatsOwner,
           (rowreq_ctx->undo->etherStatsOwner_len *
            sizeof(rowreq_ctx->data.etherStatsOwner[0])));
    rowreq_ctx->data.etherStatsOwner_len =
        rowreq_ctx->undo->etherStatsOwner_len;


    return MFD_SUCCESS;
}                               /* etherStatsOwner_undo */

/*---------------------------------------------------------------------
 * RMON-MIB::etherStatsEntry.etherStatsStatus
 * etherStatsStatus is subid 21 of etherStatsEntry.
 * Its status is Current, and its access level is Create.
 * OID: .1.3.6.1.2.1.16.1.1.1.21
 * Description:
The status of this etherStats entry.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  1      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   1
 *
 * Enum range: 2/8. Values:  valid(1), createRequest(2), underCreation(3), invalid(4)
 *
 * Its syntax is EntryStatus (based on perltype INTEGER)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (u_long)
 */
/**
 * Check that the proposed new value is potentially valid.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param etherStatsStatus_val
 *        A long containing the new value.
 *
 * @retval MFD_SUCCESS        : incoming value is legal
 * @retval MFD_NOT_VALID_NOW  : incoming value is not valid now
 * @retval MFD_NOT_VALID_EVER : incoming value is never valid
 *
 * This is the place to check for requirements that are not
 * expressed in the mib syntax (for example, a requirement that
 * is detailed in the description for an object).
 *
 * You should check that the requested change between the undo value and the
 * new value is legal (ie, the transition from one value to another
 * is legal).
 *      
 *@note
 * This check is only to determine if the new value
 * is \b potentially valid. This is the first check of many, and
 * is one of the simplest ones.
 * 
 *@note
 * this is not the place to do any checks for values
 * which depend on some other value in the mib. Those
 * types of checks should be done in the
 * etherStatsTable_check_dependencies() function.
 *
 * The following checks have already been done for you:
 *    The syntax is ASN_INTEGER
 *    The value is one of  valid(1), createRequest(2), underCreation(3), invalid(4)
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 *
 */
int
etherStatsStatus_check_value(etherStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long etherStatsStatus_val)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsStatus_check_value",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:441:o: |-> Check for valid etherStatsStatus value.
     */

    return MFD_SUCCESS;         /* etherStatsStatus value not illegal */
}                               /* etherStatsStatus_check_value */

/**
 * Save old value information
 *
 * @param rowreq_ctx
 *        Pointer to the table context (etherStatsTable_rowreq_ctx)
 *
 * @retval MFD_SUCCESS : success
 * @retval MFD_ERROR   : error. set will fail.
 *
 * This function will be called after the table level undo setup function
 * etherStatsTable_undo_setup has been called.
 *
 *@note
 * this function will only be called if a new value is set for this column.
 *
 * If there is any setup specific to a particular column (e.g. allocating
 * memory for a string), you should do that setup in this function, so it
 * won't be done unless it is necessary.
 */
int
etherStatsStatus_undo_setup(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsStatus_undo_setup",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:455:o: |-> Setup etherStatsStatus undo.
     */
    /*
     * copy etherStatsStatus data
     * set rowreq_ctx->undo->etherStatsStatus from rowreq_ctx->data.etherStatsStatus
     */
    rowreq_ctx->undo->etherStatsStatus = rowreq_ctx->data.etherStatsStatus;


    return MFD_SUCCESS;
}                               /* etherStatsStatus_undo_setup */

/**
 * Set the new value.
 *
 * @param rowreq_ctx
 *        Pointer to the users context. You should know how to
 *        manipulate the value from this object.
 * @param etherStatsStatus_val
 *        A long containing the new value.
 */
int
etherStatsStatus_set(etherStatsTable_rowreq_ctx * rowreq_ctx,
                     u_long etherStatsStatus_val)
{

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsStatus_set",
                "called\n"));

    /** should never get a NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:461:M: |-> Set etherStatsStatus value.
     * set etherStatsStatus value in rowreq_ctx->data
     */
    rowreq_ctx->data.etherStatsStatus = etherStatsStatus_val;

    return MFD_SUCCESS;
}                               /* etherStatsStatus_set */

/**
 * undo the previous set.
 *
 * @param rowreq_ctx
 *        Pointer to the users context.
 */
int
etherStatsStatus_undo(etherStatsTable_rowreq_ctx * rowreq_ctx)
{

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsStatus_undo",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:456:o: |-> Clean up etherStatsStatus undo.
     */
    /*
     * copy etherStatsStatus data
     * set rowreq_ctx->data.etherStatsStatus from rowreq_ctx->undo->etherStatsStatus
     */
    rowreq_ctx->data.etherStatsStatus = rowreq_ctx->undo->etherStatsStatus;


    return MFD_SUCCESS;
}                               /* etherStatsStatus_undo */

/** @} */
