% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{save_as_rtf}
\alias{save_as_rtf}
\title{Save flextable objects in an 'RTF' file}
\usage{
save_as_rtf(..., values = NULL, path, pr_section = NULL)
}
\arguments{
\item{...}{flextable objects, objects, possibly named. If named objects, names are
used as titles.}

\item{values}{a list (possibly named), each element is a flextable object. If named objects, names are
used as titles. If provided, argument \code{...} will be ignored.}

\item{path}{Word file to be created}

\item{pr_section}{a \link[officer:prop_section]{officer::prop_section} object that can be used to define page
layout such as orientation, width and height.}
}
\value{
a string containing the full name of the generated file
}
\description{
sugar function to save flextable objects in an 'RTF' file.
}
\examples{

tf <- tempfile(fileext = ".rtf")

library(officer)
ft1 <- flextable(head(iris))
save_as_rtf(ft1, path = tf)


ft2 <- flextable(head(mtcars))
sect_properties <- prop_section(
  page_size = page_size(
    orient = "landscape",
    width = 8.3, height = 11.7
  ),
  type = "continuous",
  page_margins = page_mar(),
  header_default = block_list(
    fpar(ftext("text for default page header")),
    qflextable(data.frame(a = 1L))
  )
)
tf <- tempfile(fileext = ".rtf")
save_as_rtf(
  `iris table` = ft1, `mtcars table` = ft2,
  path = tf, pr_section = sect_properties
)
}
\seealso{
\code{\link[=paginate]{paginate()}}

Other flextable print function: 
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{to_html.flextable}()},
\code{\link{wrap_flextable}()}
}
\concept{flextable print function}
