## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# #This step can be skipped if `LitFetchR` is already installed
# 
# #Install using devtools package
# install.packages("devtools")
# devtools::install_github("thomasdumond/LitFetchR")
# 
# #or
# 
# #Install using remotes package
# install.packages("remotes")
# remotes::install_github("thomasdumond/LitFetchR")

## ----eval = FALSE-------------------------------------------------------------
# #Load `LitFetchR`
# library(LitFetchR)

## ----eval = FALSE-------------------------------------------------------------
# #This step can be skipped if your API keys have already been saved. Repeat this step if your API keys changed.
# 
# #Load `LitFetchR`
# library(LitFetchR)
# 
# #Save API keys in your R environment
# 
# #Example of what you should see:
# #> save_api_keys(wos_api_key = "abcd01234", scp_api_key = "efgh5678")
# #Saved key(s) wos_api_key, scp_api_key to -path-to-your-renvironment/.Renviron.
# #Restart R for the new environment variable(s) to be available.

## ----eval=FALSE---------------------------------------------------------------
# #Load LitFetchR
# library(LitFetchR)
# 
# #The following function can help to create your search string(s)
# #It has to be used to save your search string(s), we recommend choosing the R project directory as the directory in the function.
# 
# # Example of what you should see building the search: fish AND "vibrio harveyi" AND diagnostic
# #
# # > create_save_search(wos = TRUE,
# #                      scp = TRUE,
# #                      pmd = TRUE,
# #                      directory = "C:/path-to-project-directory")
# #
# # History had been created.
# # Enter your search string (or 'summary' or 'exit'): fish
# # [1] "fish"
# # [1] "Web of Science: 1793296 results"
# # [1] "Scopus: 718644 results"
# # [1] "PubMed: 384742 results"
# # Enter your search string (or 'summary' or 'exit'): fish AND "vibrio harveyi"
# # [1] "fish AND \"vibrio harveyi\""
# # [1] "Web of Science: 2084 results"
# # [1] "Scopus: 1080 results"
# # [1] "PubMed: 727 results"
# # Enter your search string (or 'summary' or 'exit'): fish AND "vibrio harveyi" AND diagnostic
# # [1] "fish AND \"vibrio harveyi\" AND diagnostic"
# # [1] "Web of Science: 126 results"
# # [1] "Scopus: 22 results"
# # [1] "PubMed: 106 results"
# # Enter your search string (or 'summary' or 'exit'): summary
# #                                Search_Term Results_WOS Results_SCP Results_PMD
# # 1                                     fish     1793296      718644      384742
# # 2                fish AND "vibrio harveyi"        2084        1080         727
# # 3 fish AND "vibrio harveyi" AND diagnostic         126          22         106
# # Select the index number for the search string to use in automated retrieval: 3
# #
# # Selected search string: fish AND "vibrio harveyi" AND diagnostic
# # Do you want to save the search string for future use? (yes/no): yes
# # Enter a name for the search identification: fish_vibrio
# # Search string saved successfully.
# # Enter your search string (or 'summary' or 'exit'): exit
# # Exiting search tool.

## ----eval=FALSE---------------------------------------------------------------
# #Load LitFetchR
# library(LitFetchR)
# #We recommend choosing the R project directory as the directory in the function. It has to be the directory where "search_list.txt" and "history_search.xlsx" have been saved.
# #We recommend using a single word for the *task_id* or to use underscores "_" to separate words.
# #The retrieval frequency is currently available "DAILY", "WEEKLY" or "MONTHLY".
# #You need to use a 24H format for the time of reference retrieval.
# #If you do not have an API key for WOS and/or SCP or want to exclude any database,
# #change "TRUE" to "FALSE" in front of the corresponding database (e.g.`wos = FALSE`).
# 
# #Example of what you should see
# #> auto_LitFetchR_setup(task_id = "fish_vibrio",
#                      # when = "WEEKLY",
#                      # time = "14:00",
#                      # wos = TRUE,
#                      # scp = TRUE,
#                      # pmd = TRUE,
#                      # directory = "C:/path-to-project-directory",
#                      # dedup = FALSE,
#                      # open_file = TRUE)
# #Task scheduled!

