## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ervissexplore)

## ----positivity, eval=FALSE---------------------------------------------------
# data <- get_sentineltests_positivity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   pathogen = "SARS-CoV-2",
#   countries = c("France", "Germany", "Italy"),
#   indicator = "positivity"
# )
# 
# head(data)

## ----positivity-multi, eval=FALSE---------------------------------------------
# data <- get_sentineltests_positivity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-06-30"),
#   pathogen = c("SARS-CoV-2", "Influenza", "RSV"),
#   indicator = "detections"
# )

## ----variants, eval=FALSE-----------------------------------------------------
# data <- get_erviss_variants(
#   date_min = as.Date("2025-06-01"),
#   date_max = as.Date("2025-12-31"),
#   variant = c("XFG", "LP.8.1"),
#   countries = c("France", "Belgium"),
#   indicator = "detections"
# )
# 
# # Filter variants with a minimum proportion
# data <- get_erviss_variants(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   min_value = 5,
#   indicator = "proportion"
# )

## ----ili-ari, eval=FALSE------------------------------------------------------
# # Get ILI consultation rates
# data <- get_ili_ari_rates(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   indicator = "ILIconsultationrate",
#   countries = "France"
# )
# 
# # Get both ILI and ARI rates for specific age groups
# data <- get_ili_ari_rates(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   age = c("0-4", "65+")
# )

## ----sari-rates, eval=FALSE---------------------------------------------------
# data <- get_sari_rates(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   age = c("0-4", "15-64", "65+"),
#   countries = c("France", "Belgium")
# )

## ----sari-positivity, eval=FALSE----------------------------------------------
# # Get positivity for Influenza
# data <- get_sari_positivity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   pathogen = "Influenza",
#   indicator = "positivity",
#   countries = "Belgium"
# )
# 
# # Get detections for all pathogens
# data <- get_sari_positivity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   indicator = "detections"
# )

## ----nonsentinel-severity, eval=FALSE-----------------------------------------
# # Get hospital admissions for SARS-CoV-2
# data <- get_nonsentinel_severity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   pathogen = "SARS-CoV-2",
#   indicator = "hospitaladmissions",
#   countries = "France"
# )
# 
# # Get multiple severity indicators
# data <- get_nonsentinel_severity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   pathogen = "SARS-CoV-2",
#   indicator = c("hospitaladmissions", "ICUadmissions", "deaths")
# )

## ----nonsentinel-tests, eval=FALSE--------------------------------------------
# data <- get_nonsentinel_tests(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   pathogen = "Influenza",
#   indicator = "detections",
#   countries = c("France", "Germany")
# )

## ----generic, eval=FALSE------------------------------------------------------
# # These two calls are equivalent:
# data <- get_sentineltests_positivity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   pathogen = "SARS-CoV-2"
# )
# 
# data <- get_erviss_data(
#   type = "positivity",
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31"),
#   pathogen = "SARS-CoV-2"
# )

## ----generic-switch, eval=FALSE-----------------------------------------------
# types <- c("positivity", "sari_positivity", "nonsentinel_tests")
# 
# results <- lapply(types, function(t) {
#   get_erviss_data(
#     type = t,
#     date_min = as.Date("2024-01-01"),
#     date_max = as.Date("2024-12-31"),
#     pathogen = "Influenza",
#     countries = "Belgium"
#   )
# })
# 
# names(results) <- types

## ----snapshot, eval=FALSE-----------------------------------------------------
# # Fetch a specific snapshot
# data <- get_sentineltests_positivity(
#   date_min = as.Date("2023-01-01"),
#   date_max = as.Date("2023-12-31"),
#   use_snapshot = TRUE,
#   snapshot_date = as.Date("2024-02-23")
# )

## ----snapshot-generic, eval=FALSE---------------------------------------------
# data <- get_erviss_data(
#   type = "nonsentinel_severity",
#   date_min = as.Date("2023-01-01"),
#   date_max = as.Date("2023-12-31"),
#   pathogen = "SARS-CoV-2",
#   indicator = "hospitaladmissions",
#   use_snapshot = TRUE,
#   snapshot_date = as.Date("2024-02-23")
# )

## ----urls---------------------------------------------------------------------
# Latest data URLs
get_erviss_url("positivity")
get_erviss_url("ili_ari_rates")
get_erviss_url("nonsentinel_severity")

# Snapshot URL
get_erviss_url(
  "variants",
  use_snapshot = TRUE,
  snapshot_date = as.Date("2023-11-24")
)

## ----local-csv, eval=FALSE----------------------------------------------------
# data <- get_sentineltests_positivity(
#   csv_file = "path/to/sentinelTestsDetectionsPositivity.csv",
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-12-31")
# )

## ----analysis, eval=FALSE-----------------------------------------------------
# data <- get_sentineltests_positivity(
#   date_min = as.Date("2024-01-01"),
#   date_max = as.Date("2024-06-30"),
#   pathogen = c("SARS-CoV-2", "Influenza")
# )
# 
# # data.table syntax
# data[,
#   .(
#     mean_positivity = mean(value, na.rm = TRUE),
#     max_positivity = max(value, na.rm = TRUE),
#     n_weeks = .N
#   ),
#   by = .(countryname, pathogen)
# ]
# 
# # Or convert to tibble for dplyr
# # tibble::as_tibble(data)

