/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

@Explained(partial=true, comment="AC disabled due to lack of explanation")
public class PropXplusYeqZ
extends Propagator<IntVar> {
    private static final int THRESHOLD = 300;
    private final int x = 0;
    private final int y = 1;
    private final int z = 2;
    private final boolean allbounded;
    private final IntIterableRangeSet set;

    public PropXplusYeqZ(IntVar X, IntVar Y, IntVar Z) {
        super((Variable[])new IntVar[]{X, Y, Z}, (Priority)PropagatorPriority.TERNARY, false);
        this.allbounded = !X.hasEnumeratedDomain() & !Y.hasEnumeratedDomain() & !Z.hasEnumeratedDomain();
        this.set = new IntIterableRangeSet();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        do {
            boolean loop = this.filterPlus(2, 0, 1);
            loop |= this.filterMinus(0, 2, 1);
            loop |= this.filterMinus(1, 2, 0);
        } while (loop &= this.allbounded || this.lcg());
    }

    private boolean filterPlus(int vr, int v1, int v2) throws ContradictionException {
        int lb = ((IntVar[])this.vars)[v1].getLB() + ((IntVar[])this.vars)[v2].getLB();
        int ub = ((IntVar[])this.vars)[v1].getUB() + ((IntVar[])this.vars)[v2].getUB();
        boolean change = ((IntVar[])this.vars)[vr].updateLowerBound(lb, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[v1].getMinLit(), ((IntVar[])this.vars)[v2].getMinLit()) : Reason.undef());
        change |= ((IntVar[])this.vars)[vr].updateUpperBound(ub, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[v1].getMaxLit(), ((IntVar[])this.vars)[v2].getMaxLit()) : Reason.undef());
        if (!this.allbounded) {
            if ((long)((IntVar[])this.vars)[v1].getDomainSize() * (long)((IntVar[])this.vars)[v2].getDomainSize() > 300L || this.lcg()) {
                return change;
            }
            this.set.clear();
            int ub1 = ((IntVar[])this.vars)[v1].getUB();
            int ub2 = ((IntVar[])this.vars)[v2].getUB();
            int l1 = ((IntVar[])this.vars)[v1].getLB();
            int u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            while (u1 <= ub1) {
                int l2 = ((IntVar[])this.vars)[v2].getLB();
                int u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                while (u2 <= ub2) {
                    this.set.addBetween(l1 + l2, u1 + u2);
                    l2 = ((IntVar[])this.vars)[v2].nextValue(u2);
                    u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                }
                l1 = ((IntVar[])this.vars)[v1].nextValue(u1);
                u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            }
            ((IntVar[])this.vars)[vr].removeAllValuesBut(this.set, this);
        }
        return change;
    }

    private boolean filterMinus(int vr, int v1, int v2) throws ContradictionException {
        int lb = ((IntVar[])this.vars)[v1].getLB() - ((IntVar[])this.vars)[v2].getUB();
        int ub = ((IntVar[])this.vars)[v1].getUB() - ((IntVar[])this.vars)[v2].getLB();
        boolean change = ((IntVar[])this.vars)[vr].updateLowerBound(lb, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[v1].getMinLit(), ((IntVar[])this.vars)[v2].getMaxLit()) : Reason.undef());
        change |= ((IntVar[])this.vars)[vr].updateUpperBound(ub, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[v1].getMaxLit(), ((IntVar[])this.vars)[v2].getMinLit()) : Reason.undef());
        if (!this.allbounded) {
            if ((long)((IntVar[])this.vars)[v1].getDomainSize() * (long)((IntVar[])this.vars)[v2].getDomainSize() > 300L || this.lcg()) {
                return change;
            }
            this.set.clear();
            int ub1 = ((IntVar[])this.vars)[v1].getUB();
            int ub2 = ((IntVar[])this.vars)[v2].getUB();
            int l1 = ((IntVar[])this.vars)[v1].getLB();
            int u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            while (u1 <= ub1) {
                int l2 = ((IntVar[])this.vars)[v2].getLB();
                int u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                while (u2 <= ub2) {
                    this.set.addBetween(l1 - u2, u1 - l2);
                    l2 = ((IntVar[])this.vars)[v2].nextValue(u2);
                    u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                }
                l1 = ((IntVar[])this.vars)[v1].nextValue(u1);
                u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            }
            ((IntVar[])this.vars)[vr].removeAllValuesBut(this.set, this);
        }
        return change;
    }

    @Override
    public ESat isEntailed() {
        int i;
        int sumUB = 0;
        int sumLB = 0;
        for (i = 0; i < 2; ++i) {
            sumLB += ((IntVar[])this.vars)[i].getLB();
            sumUB += ((IntVar[])this.vars)[i].getUB();
        }
        while (i < 3) {
            sumLB -= ((IntVar[])this.vars)[i].getUB();
            sumUB -= ((IntVar[])this.vars)[i].getLB();
            ++i;
        }
        if (sumLB == 0 && sumUB == 0) {
            return ESat.TRUE;
        }
        if (sumUB < 0 || sumLB > 0) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

