/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.SymmetricMatrix;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class CorrelationToCholesky
extends Transform.MultivariateTransform {
    private int dimVector;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String DIMENSION = "dimension";
        private static final String CORRELATION_TO_CHOLESKY = "correlationToCholeskyTransform";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = xMLObject.getIntegerAttribute(DIMENSION);
            return new CorrelationToCholesky(n);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{AttributeRule.newIntegerRule(DIMENSION)};
        }

        @Override
        public String getParserDescription() {
            return "transforms the off-diagonal elements of a correlation to the off-diagonal elements of its Cholesky decomposition";
        }

        @Override
        public Class getReturnType() {
            return CorrelationToCholesky.class;
        }

        @Override
        public String getParserName() {
            return CORRELATION_TO_CHOLESKY;
        }
    };

    public CorrelationToCholesky(int n) {
        super(n * (n - 1) / 2);
        this.dimVector = n;
    }

    @Override
    protected double[] inverse(double[] dArray) {
        WrappedMatrix.WrappedUpperTriangularMatrix wrappedUpperTriangularMatrix = WrappedMatrix.WrappedUpperTriangularMatrix.fillDiagonal(dArray, this.dimVector);
        SymmetricMatrix symmetricMatrix = wrappedUpperTriangularMatrix.transposedProduct();
        return SymmetricMatrix.extractUpperTriangular(symmetricMatrix);
    }

    @Override
    protected double[] transform(double[] dArray) {
        double[] dArray2;
        SymmetricMatrix symmetricMatrix = SymmetricMatrix.compoundCorrelationSymmetricMatrix(dArray, this.dimVector);
        try {
            dArray2 = new CholeskyDecomposition(symmetricMatrix).getStrictlyUpperTriangular();
        }
        catch (IllegalDimension illegalDimension) {
            throw new RuntimeException("Unable to decompose matrix in LKJ inverse transform.");
        }
        return dArray2;
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("Not relevant for the correlation to Cholesky transform.");
    }

    @Override
    public boolean isInInteriorDomain(double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getTransformName() {
        return "CorrelationToCholeskyTransform";
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        WrappedMatrix.WrappedUpperTriangularMatrix wrappedUpperTriangularMatrix = WrappedMatrix.WrappedUpperTriangularMatrix.fillDiagonal(this.transform(dArray), this.dimVector);
        double d = 0.0;
        for (int i = 0; i < this.dimVector - 1; ++i) {
            d += (double)(this.dimVector - i - 1) * Math.log(wrappedUpperTriangularMatrix.get(i, i));
        }
        return -d;
    }

    @Override
    protected double[] getGradientLogJacobianInverse(double[] dArray) {
        WrappedMatrix.WrappedUpperTriangularMatrix wrappedUpperTriangularMatrix = WrappedMatrix.WrappedUpperTriangularMatrix.fillDiagonal(dArray, this.dimVector);
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        for (int i = 0; i < this.dimVector - 1; ++i) {
            for (int j = i + 1; j < this.dimVector; ++j) {
                dArray2[n] = (double)(-(this.dimVector - j - 1)) * wrappedUpperTriangularMatrix.get(i, j) / Math.pow(wrappedUpperTriangularMatrix.get(j, j), 2.0);
                ++n;
            }
        }
        return dArray2;
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        double[][] dArray2 = new double[this.dim][this.dim];
        WrappedMatrix.WrappedUpperTriangularMatrix wrappedUpperTriangularMatrix = WrappedMatrix.WrappedUpperTriangularMatrix.fillDiagonal(dArray, this.dimVector);
        for (int i = 0; i < this.dimVector - 1; ++i) {
            for (int j = i + 1; j < this.dimVector; ++j) {
                double d = wrappedUpperTriangularMatrix.get(i, j) / wrappedUpperTriangularMatrix.get(i, i);
                for (int k = 0; k < i; ++k) {
                    dArray2[this.posStrict((int)k, (int)i)][this.posStrict((int)i, (int)j)] = wrappedUpperTriangularMatrix.get(k, j) - wrappedUpperTriangularMatrix.get(k, i) * d;
                    dArray2[this.posStrict((int)k, (int)j)][this.posStrict((int)i, (int)j)] = wrappedUpperTriangularMatrix.get(k, i);
                }
                dArray2[this.posStrict((int)i, (int)j)][this.posStrict((int)i, (int)j)] = wrappedUpperTriangularMatrix.get(i, i);
            }
        }
        return dArray2;
    }

    private int posStrict(int n, int n2) {
        return n * (2 * this.dimVector - n - 1) / 2 + (n2 - n - 1);
    }
}

