/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import java.util.Random;
import org.netlib.blas.Dgemm;
import org.netlib.blas.Dtrmm;
import org.netlib.lapack.Dlacpy;
import org.netlib.lapack.Dlange;

public class TestDenseDoubleCholeskyDecomposition {
    public static void main(String[] stringArray) {
        for (int i = 0; i < 20; ++i) {
            int n;
            int n2;
            int n3 = 600;
            int n4 = 5;
            Random random = new Random(0L);
            DoubleMatrix2D doubleMatrix2D = new DenseColumnDoubleMatrix2D(n3, n3);
            DoubleMatrix2D doubleMatrix2D2 = new DenseColumnDoubleMatrix2D(n3, n3);
            DoubleMatrix2D doubleMatrix2D3 = new DenseColumnDoubleMatrix2D(n3, n4);
            DoubleMatrix2D doubleMatrix2D4 = new DenseColumnDoubleMatrix2D(n3, n4);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    doubleMatrix2D.setQuick(n2, n, 0.5 - random.nextDouble());
                    doubleMatrix2D2.setQuick(n2, n, doubleMatrix2D.getQuick(n2, n));
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                doubleMatrix2D.setQuick(n2, n2, doubleMatrix2D.getQuick(n2, n2) + (double)n3);
                doubleMatrix2D2.setQuick(n2, n2, doubleMatrix2D.getQuick(n2, n2));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    doubleMatrix2D.setQuick(n2, n, doubleMatrix2D.getQuick(n, n2));
                    doubleMatrix2D2.setQuick(n2, n, doubleMatrix2D.getQuick(n, n2));
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    doubleMatrix2D3.setQuick(n2, n, 0.5 - random.nextDouble());
                    doubleMatrix2D4.setQuick(n2, n, doubleMatrix2D3.getQuick(n2, n));
                }
            }
            TestDenseDoubleCholeskyDecomposition.testCholesky(doubleMatrix2D, doubleMatrix2D2, doubleMatrix2D3, doubleMatrix2D4);
            doubleMatrix2D = new DenseDoubleMatrix2D(n3, n3);
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n3, n3);
            doubleMatrix2D3 = new DenseDoubleMatrix2D(n3, n4);
            doubleMatrix2D4 = new DenseDoubleMatrix2D(n3, n4);
            random = new Random(0L);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    doubleMatrix2D.setQuick(n2, n, 0.5 - random.nextDouble());
                    doubleMatrix2D2.setQuick(n2, n, doubleMatrix2D.getQuick(n2, n));
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                doubleMatrix2D.setQuick(n2, n2, doubleMatrix2D.getQuick(n2, n2) + (double)n3);
                doubleMatrix2D2.setQuick(n2, n2, doubleMatrix2D.getQuick(n2, n2));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n3; ++n) {
                    doubleMatrix2D.setQuick(n2, n, doubleMatrix2D.getQuick(n, n2));
                    doubleMatrix2D2.setQuick(n2, n, doubleMatrix2D.getQuick(n, n2));
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < n4; ++n) {
                    doubleMatrix2D3.setQuick(n2, n, 0.5 - random.nextDouble());
                    doubleMatrix2D4.setQuick(n2, n, doubleMatrix2D3.getQuick(n2, n));
                }
            }
            TestDenseDoubleCholeskyDecomposition.testCholesky(doubleMatrix2D, doubleMatrix2D2, doubleMatrix2D3, doubleMatrix2D4);
        }
        System.out.println("All finished");
        System.exit(0);
    }

    private static void testCholesky(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3, DoubleMatrix2D doubleMatrix2D4) {
        int n = doubleMatrix2D.rows();
        double d = 1.0E-10;
        DenseDoubleCholeskyDecomposition denseDoubleCholeskyDecomposition = new DenseDoubleCholeskyDecomposition(doubleMatrix2D2);
        DoubleMatrix2D doubleMatrix2D5 = denseDoubleCholeskyDecomposition.getLtranspose();
        DoubleMatrix2D doubleMatrix2D6 = doubleMatrix2D4.copy();
        denseDoubleCholeskyDecomposition.solve(doubleMatrix2D6);
        System.out.print("\n");
        System.out.print("------ DoubleCholeskyFactorization tests-------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n, n));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n2 = TestDenseDoubleCholeskyDecomposition.checkFactorization(doubleMatrix2D, doubleMatrix2D5, d);
        int n3 = TestDenseDoubleCholeskyDecomposition.checkSolution(doubleMatrix2D, doubleMatrix2D3, doubleMatrix2D6, d);
        if (n3 == 0 & n2 == 0) {
            System.out.print("***************************************************\n");
            System.out.print(" ---- DoubleCholeskyFactorization tests... PASSED !\n");
            System.out.print("***************************************************\n");
        } else {
            System.err.print("***************************************************\n");
            System.err.print(" ---- DoubleCholeskyFactorization tests... FAILED !\n");
            System.err.print("***************************************************\n");
        }
    }

    private static int checkFactorization(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d) {
        int n;
        int n2;
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D2);
        int n3 = n2 = doubleMatrix2D.rows();
        int n4 = 121;
        String string = "I";
        double[] dArray = doubleMatrix2D instanceof DenseDoubleMatrix2D ? (double[])doubleMatrix2D.viewDice().copy().elements() : (double[])doubleMatrix2D.copy().elements();
        double[] dArray2 = doubleMatrix2D2 instanceof DenseDoubleMatrix2D ? (double[])doubleMatrix2D2.viewDice().copy().elements() : (double[])doubleMatrix2D2.copy().elements();
        double[] dArray3 = new double[n2 * n2];
        double[] dArray4 = new double[n2 * n2];
        double[] dArray5 = new double[n2 * n2];
        double[] dArray6 = new double[n2];
        double d2 = 1.0;
        Dlacpy.dlacpy((String)"ALL", (int)n2, (int)n2, (double[])dArray, (int)0, (int)n3, (double[])dArray3, (int)0, (int)n2);
        Dlacpy.dlacpy((String)Dplasma.lapack_const((int)121), (int)n2, (int)n2, (double[])dArray2, (int)0, (int)n3, (double[])dArray4, (int)0, (int)n2);
        Dlacpy.dlacpy((String)Dplasma.lapack_const((int)121), (int)n2, (int)n2, (double[])dArray2, (int)0, (int)n3, (double[])dArray5, (int)0, (int)n2);
        Dtrmm.dtrmm((String)"L", (String)"U", (String)"T", (String)"N", (int)n2, (int)n2, (double)d2, (double[])dArray4, (int)0, (int)n2, (double[])dArray5, (int)0, (int)n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[j * n2 + i] = dArray5[j * n2 + i] - dArray3[j * n2 + i];
            }
        }
        double d3 = Dlange.dlange((String)string, (int)n2, (int)n2, (double[])dArray3, (int)0, (int)n2, (double[])dArray6, (int)0);
        double d4 = Dlange.dlange((String)string, (int)n2, (int)n2, (double[])dArray, (int)0, (int)n3, (double[])dArray6, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the Cholesky Factorization \n");
        System.out.print(String.format("-- ||L'L-A||_oo/(||A||_oo.N.eps) = %e \n", d3 / (d4 * (double)n2 * d)));
        if (d3 / (d4 * (double)n2 * d) > 10.0) {
            System.out.print("-- Factorization is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- Factorization is CORRECT ! \n");
            n = 0;
        }
        return n;
    }

    private static int checkSolution(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, DoubleMatrix2D doubleMatrix2D3, double d) {
        int n;
        int n2;
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D2);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D3);
        int n3 = n2 = doubleMatrix2D.rows();
        int n4 = n2;
        int n5 = doubleMatrix2D2.columns();
        String string = "I";
        double[] dArray = new double[n2];
        double[] dArray2 = doubleMatrix2D instanceof DenseDoubleMatrix2D ? (double[])doubleMatrix2D.viewDice().copy().elements() : (double[])doubleMatrix2D.copy().elements();
        double[] dArray3 = doubleMatrix2D2 instanceof DenseDoubleMatrix2D ? (double[])doubleMatrix2D2.viewDice().copy().elements() : (double[])doubleMatrix2D2.copy().elements();
        double[] dArray4 = doubleMatrix2D3 instanceof DenseDoubleMatrix2D ? (double[])doubleMatrix2D3.viewDice().copy().elements() : (double[])doubleMatrix2D3.copy().elements();
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = Dlange.dlange((String)string, (int)n2, (int)n5, (double[])dArray4, (int)0, (int)n4, (double[])dArray, (int)0);
        double d5 = Dlange.dlange((String)string, (int)n2, (int)n2, (double[])dArray2, (int)0, (int)n3, (double[])dArray, (int)0);
        double d6 = Dlange.dlange((String)string, (int)n2, (int)n5, (double[])dArray3, (int)0, (int)n4, (double[])dArray, (int)0);
        Dgemm.dgemm((String)"N", (String)"N", (int)n2, (int)n5, (int)n2, (double)d2, (double[])dArray2, (int)0, (int)n3, (double[])dArray4, (int)0, (int)n4, (double)d3, (double[])dArray3, (int)0, (int)n4);
        double d7 = Dlange.dlange((String)string, (int)n2, (int)n5, (double[])dArray3, (int)0, (int)n4, (double[])dArray, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", d7 / ((d5 * d4 + d6) * (double)n2 * d)));
        if (d7 / ((d5 * d4 + d6) * (double)n2 * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n = 0;
        }
        return n;
    }
}

