/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.syntaxtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractRecombinator;
import net.sourceforge.jclec.syntaxtree.IRecombineSyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeIndividual;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSchema;
import net.sourceforge.jclec.syntaxtree.SyntaxTreeSpecies;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class SyntaxTreeRecombinator
extends AbstractRecombinator
implements IConfigure {
    private static final long serialVersionUID = 5597963000114578170L;
    protected IRecombineSyntaxTree baseOp;
    protected transient SyntaxTreeSpecies species;
    protected transient SyntaxTreeSchema schema;

    public IRecombineSyntaxTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IRecombineSyntaxTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IRecombineSyntaxTree baseOp = (IRecombineSyntaxTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void setPpl() {
        this.ppl = 2;
    }

    @Override
    protected void setSpl() {
        this.spl = 2;
    }

    @Override
    protected void prepareRecombination() {
        ISpecies species = this.context.getSpecies();
        if (!(species instanceof SyntaxTreeSpecies)) {
            throw new IllegalStateException("Invalid species in context");
        }
        this.species = (SyntaxTreeSpecies)species;
        this.schema = ((SyntaxTreeSpecies)species).getGenotypeSchema();
    }

    @Override
    protected void recombineNext() {
        SyntaxTree p0_genotype = (SyntaxTree)((SyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter++)).getGenotype();
        SyntaxTree p1_genotype = (SyntaxTree)((SyntaxTreeIndividual)this.parentsBuffer.get(this.parentsCounter++)).getGenotype();
        SyntaxTree s0_genotype = new SyntaxTree();
        SyntaxTree s1_genotype = new SyntaxTree();
        this.baseOp.recombine(p0_genotype, p1_genotype, s0_genotype, s1_genotype, this.schema, this.randgen);
        this.sonsBuffer.add(this.species.createIndividual(s0_genotype));
        this.sonsBuffer.add(this.species.createIndividual(s1_genotype));
    }
}

