## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, message=FALSE, warning=FALSE--------------------------------------
library(ROCnGO)
library(dplyr)

## ----warning=FALSE------------------------------------------------------------
# Create a small subset of iris with 5 random flowers of each species
iris_subset <- as_tibble(iris) %>%
  group_by(Species) %>%
  slice_sample(n = 5) %>%
  ungroup()
iris_subset

## ----warning=FALSE------------------------------------------------------------
# Check levels in Species
levels(iris_subset$Species)

# Summarize dataset classifiers
iris_results <- summarize_dataset(
  iris_subset,
  response = Species,
  ratio = "tpr",
  threshold = 0.9
)
iris_results$data

## ----warning=FALSE------------------------------------------------------------
# Summarize dataset classifiers with virginica species as D=1
virginica_results <- summarize_dataset(
  iris_subset,
  response = Species,
  ratio = "tpr",
  threshold = 0.9,
  .condition = "virginica"
)
virginica_results$data

## ----warning=FALSE------------------------------------------------------------
# Create new variables to evaluate "virginica" species classifiers
iris_subset <- iris_subset %>%
  mutate(
    Species_int = ifelse(Species == "virginica", 2L, 1L),
    Species_fct = factor(
      ifelse(Species == "virginica", 1, 0),
      levels = c(0, 1)
    )
  )
# Check new variables
iris_subset[, c("Species", "Species_int", "Species_fct")]

## ----warning=FALSE------------------------------------------------------------
# Select predictors
predictors <- c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")

# Check performance of virginica classifiers with .condition = 2
int_results <- summarize_dataset(
  iris_subset,
  predictors = predictors,
  response = Species_int,
  ratio = "tpr",
  threshold = 0.9,
  .condition = 2
)
int_results$data

# Check performance of virginica classifiers with factor
fct_results <- summarize_dataset(
  iris_subset,
  predictors = predictors,
  response = Species_fct,
  ratio = "tpr",
  threshold = 0.9
)
fct_results$data

