/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.cumulative;

import choco.cp.solver.constraints.global.scheduling.cumulative.AbstractCumulativeSConstraint;
import choco.cp.solver.constraints.global.scheduling.cumulative.CumulRules;
import choco.cp.solver.constraints.global.scheduling.cumulative.CumulSweep;
import choco.cp.solver.constraints.global.scheduling.cumulative.ICumulRules;
import choco.cp.solver.constraints.global.scheduling.cumulative.ICumulSweep;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.Arrays;

public class Cumulative
extends AbstractCumulativeSConstraint {
    protected ICumulSweep cumulSweep;
    protected ICumulRules cumulRules;
    protected boolean noFixPoint;

    protected Cumulative(Solver solver, String name, TaskVar[] taskvars, int nbOptionalTasks, IntDomainVar consumption, IntDomainVar capacity, IntDomainVar uppBound, IntDomainVar ... otherVars) {
        super(solver, name, taskvars, nbOptionalTasks, consumption, capacity, uppBound, otherVars);
    }

    public Cumulative(Solver solver, String name, TaskVar[] taskvars, IntDomainVar[] heights, IntDomainVar consumption, IntDomainVar capacity, IntDomainVar uppBound) {
        super(solver, name, taskvars, 0, consumption, capacity, uppBound, heights);
        this.cumulSweep = new CumulSweep(this, Arrays.asList(this.rtasks));
        this.cumulRules = new CumulRules(this);
    }

    public final ICumulSweep getSweep() {
        return this.cumulSweep;
    }

    public final ICumulRules getRules() {
        return this.cumulRules;
    }

    protected void checkRulesRequirement() {
        if (!this.hasOnlyPosisiveHeights()) {
            throw new SolverException("Task interval and Edge Finding for producer/consumer cumulative resource is not supported.");
        }
    }

    public final void filter() throws ContradictionException {
        this.noFixPoint = true;
        boolean hasTaskInterval = this.flags.or(TASK_INTERVAL, VHM_CEF_ALGO_N2K, VILIM_CEF_ALGO, TASK_INTERVAL_SLOW);
        boolean hasEdgeFinding = this.flags.or(VHM_CEF_ALGO_N2K, VILIM_CEF_ALGO);
        if (hasTaskInterval) {
            this.checkRulesRequirement();
        }
        while (this.noFixPoint) {
            this.noFixPoint = false;
            this.noFixPoint |= this.cumulSweep.sweep();
            if (!hasTaskInterval) continue;
            this.cumulRules.initializeEdgeFindingStart();
            if (this.flags.contains(TASK_INTERVAL_SLOW)) {
                this.cumulRules.slowTaskIntervals();
            } else {
                this.cumulRules.taskIntervals();
            }
            if (!hasEdgeFinding) continue;
            if (this.isInstantiatedHeights()) {
                this.cumulRules.reinitConsumption();
            } else {
                this.cumulRules.initializeEdgeFindingData();
            }
            if (this.flags.contains(VILIM_CEF_ALGO)) {
                this.noFixPoint |= this.cumulRules.vilimStartEF();
            } else if (this.flags.contains(VHM_CEF_ALGO_N2K)) {
                this.noFixPoint |= this.cumulRules.calcEF_start();
            }
            this.cumulRules.reinitConsumption();
            this.cumulRules.initializeEdgeFindingEnd();
            if (this.flags.contains(VILIM_CEF_ALGO)) {
                this.noFixPoint |= this.cumulRules.vilimEndEF();
                continue;
            }
            if (!this.flags.contains(VHM_CEF_ALGO_N2K)) continue;
            this.noFixPoint |= this.cumulRules.calcEF_end();
        }
    }

    @Override
    public void awake() throws ContradictionException {
        if (this.flags.or(VHM_CEF_ALGO_N2K, VILIM_CEF_ALGO) && this.isInstantiatedHeights() && this.hasOnlyPosisiveHeights()) {
            this.checkRulesRequirement();
            this.cumulRules.initializeEdgeFindingData();
        }
        super.awake();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter();
    }
}

