# This file was generated by the {rix} R package v0.17.1 on 2025-09-04
# with following call:
# >rix(date = "2025-04-29",
#  > git_pkgs = list(list(package_name = "rix",
#  > repo_url = "https://github.com/ropensci/rix/",
#  > commit = "eb30c8afcf57141e48c76b7be41b4c3fab47d203"),
#  > list(package_name = "rixpress",
#  > repo_url = "https://github.com/b-rodrigues/rixpress/",
#  > commit = "93cda39228e5539530e4dea61f3092e32b426f54")),
#  > ide = "none",
#  > project_path = "inst/extdata",
#  > overwrite = TRUE,
#  > r_ver = "4.5.0")
# It uses the `rstats-on-nix` fork of `nixpkgs` which provides improved
# compatibility with older R versions and R packages for Linux/WSL and
# Apple Silicon computers.
# Report any issues to https://github.com/ropensci/rix
let
 pkgs = import (fetchTarball "https://github.com/rstats-on-nix/nixpkgs/archive/2025-04-29.tar.gz") {};
  
    rix = (pkgs.rPackages.buildRPackage {
      name = "rix";
      src = pkgs.fetchgit {
        url = "https://github.com/ropensci/rix/";
        rev = "eb30c8afcf57141e48c76b7be41b4c3fab47d203";
        sha256 = "sha256-tu7/anA4Iac2mwn3Y0T1uEXCSWHTumXDNjFDlM+9Amg=";
      };
      propagatedBuildInputs = builtins.attrValues {
        inherit (pkgs.rPackages) 
          codetools
          curl
          jsonlite
          sys;
      };
    });

    rixpress = (pkgs.rPackages.buildRPackage {
      name = "rixpress";
      src = pkgs.fetchgit {
        url = "https://github.com/b-rodrigues/rixpress/";
        rev = "93cda39228e5539530e4dea61f3092e32b426f54";
        sha256 = "sha256-ZegyVnsgwBgSgdW73xupD5Il5Ejjo4G6fh3A7WhAlhc=";
      };
      propagatedBuildInputs = builtins.attrValues {
        inherit (pkgs.rPackages) 
          igraph
          jsonlite
          processx;
      };
    });
      
  system_packages = builtins.attrValues {
    inherit (pkgs) 
      glibcLocales
      nix
      R;
  };
  
  shell = pkgs.mkShell {
    LOCALE_ARCHIVE = if pkgs.system == "x86_64-linux" then "${pkgs.glibcLocales}/lib/locale/locale-archive" else "";
    LANG = "en_US.UTF-8";
    LC_ALL = "en_US.UTF-8";
    LC_TIME = "en_US.UTF-8";
    LC_MONETARY = "en_US.UTF-8";
    LC_PAPER = "en_US.UTF-8";
    LC_MEASUREMENT = "en_US.UTF-8";
    
    buildInputs = [ rix rixpress system_packages ];
    
  }; 
in
  {
    inherit pkgs shell;
  }
