/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.DiscretizationMethod;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SoftMetaDiscretizer
implements DiscretizationMethod {
    private static final String ALPHA = "alpha";
    private static final String TOLERANCE = "tolerance";
    private static final String INSTANCE = "instance";
    private static final String DISTANCE = "distance";
    private static final double ALPHA_DEF = 0.5;
    private static final double ALPHA_TOLERANCE = 1.0;
    private static final int TOLERANCE_DEF = 10;
    private static final MathContext DOUBLE_PREC = new MathContext(15);
    public static final int DISTANCE_TOLERANCE = 0;
    public static final int DISTANCE_INSTANCE_COUNT = 1;
    DiscretizationMethod innerMethod;
    private double alpha;
    private int tolerance;
    private int distanceFunction;

    private static int complexityOffset(double min, double max) {
        BigDecimal bd = new BigDecimal(Math.max(Math.abs(min), Math.abs(max)), DOUBLE_PREC);
        if (bd.scale() > 0) {
            return bd.precision() - bd.scale();
        }
        return bd.precision();
    }

    private static double score(double complexity, double distance, double alpha) {
        double distanceFactor = distance == 0.0 ? (double)Math.nextUp(1.0f) : 1.0 / distance;
        return 1.0 / complexity * Math.pow(distanceFactor, alpha);
    }

    private static double mean(double d1, double d2) {
        return (d1 + d2) / 2.0;
    }

    private static List<Double> softenCutpoints(List<Double> cutpoints, DistanceFunction distFunc, double alpha) {
        ArrayList<Double> result = new ArrayList<Double>();
        int complexityOffset = SoftMetaDiscretizer.complexityOffset(cutpoints.get(0), cutpoints.get(cutpoints.size() - 1));
        int size = cutpoints.size();
        int j = 1;
        while (j <= size) {
            double min;
            double max;
            double d = cutpoints.get(j - 1);
            distFunc.setCutpoint(d);
            if (j == size) {
                max = Double.POSITIVE_INFINITY;
                distFunc.setNextCutpoint(Double.NaN);
            } else {
                double nextCutpoint = cutpoints.get(j);
                max = SoftMetaDiscretizer.mean(nextCutpoint, d);
                distFunc.setNextCutpoint(nextCutpoint);
            }
            if (j == 1) {
                min = Double.NEGATIVE_INFINITY;
                distFunc.setPrevCutpoint(Double.NaN);
            } else {
                Double prevCutpoint = cutpoints.get(j - 2);
                min = SoftMetaDiscretizer.mean(prevCutpoint, d);
                distFunc.setPrevCutpoint(prevCutpoint);
            }
            BigDecimal cutpoint = new BigDecimal(d, DOUBLE_PREC).stripTrailingZeros();
            double maxScore = 0.0;
            double bestSoftenedCutpoint = d;
            int i = cutpoint.precision() - 1;
            while (i > 0) {
                int distance;
                double score;
                BigDecimal candidate = cutpoint.round(new MathContext(i, RoundingMode.CEILING));
                int complexity = (complexityOffset + candidate.scale()) * 2;
                double val = candidate.doubleValue();
                if (val < max && (score = SoftMetaDiscretizer.score(complexity, distance = distFunc.distanceUpper(candidate.doubleValue()), alpha)) > maxScore) {
                    maxScore = score;
                    bestSoftenedCutpoint = candidate.doubleValue();
                }
                if ((val = (candidate = cutpoint.round(new MathContext(i, RoundingMode.FLOOR))).doubleValue()) >= min && (score = SoftMetaDiscretizer.score(complexity, distance = distFunc.distanceLower(candidate.doubleValue()), alpha)) >= maxScore) {
                    maxScore = score;
                    bestSoftenedCutpoint = candidate.doubleValue();
                }
                if ((val = (candidate = candidate.add(new BigDecimal(5).movePointLeft(candidate.scale() + 1))).doubleValue()) < max && val >= min && (score = SoftMetaDiscretizer.score(complexity + 1, distance = val < d ? distFunc.distanceLower(val) : distFunc.distanceUpper(val), alpha)) >= maxScore) {
                    maxScore = score;
                    bestSoftenedCutpoint = candidate.doubleValue();
                }
                --i;
            }
            result.add(bestSoftenedCutpoint);
            ++j;
        }
        return result;
    }

    public DiscretizationMethod getInnerMethod() {
        return this.innerMethod;
    }

    public void setInnerMethod(DiscretizationMethod innerMethod) {
        this.innerMethod = innerMethod;
    }

    public SoftMetaDiscretizer(DiscretizationMethod innerMethod) {
        this.innerMethod = innerMethod;
        this.alpha = 0.5;
        this.tolerance = 10;
    }

    public SoftMetaDiscretizer(DiscretizationMethod innerMethod, int distanceFunction) {
        this(innerMethod);
        this.distanceFunction = distanceFunction;
    }

    public SoftMetaDiscretizer(String[] args, DiscretizationMethod innerMethod) {
        this(innerMethod);
        int i = 1;
        while (i < args.length) {
            String[] arg = args[i].split("=");
            if (arg[0].contains(ALPHA)) {
                this.alpha = Double.parseDouble(arg[1].trim());
            } else if (arg[0].contains(DISTANCE)) {
                String dis = arg[1].trim();
                if (dis.equalsIgnoreCase(TOLERANCE)) {
                    this.distanceFunction = 0;
                } else if (dis.equalsIgnoreCase(INSTANCE)) {
                    this.distanceFunction = 1;
                }
            } else if (arg[0].contains(TOLERANCE)) {
                this.tolerance = Integer.parseInt(arg[1].trim());
            }
            ++i;
        }
    }

    private DistanceFunction getDistanceFunction() {
        switch (this.distanceFunction) {
            case 0: {
                this.alpha = 1.0;
                return new ToleranceDistance(this.tolerance);
            }
        }
        return new InstanceCountDistance(this.innerMethod.getSortedSample());
    }

    @Override
    public NumericAttribute getAttribute() {
        return this.innerMethod.getAttribute();
    }

    @Override
    public List<Double> getCutpoints() {
        return SoftMetaDiscretizer.softenCutpoints(this.innerMethod.getCutpoints(), this.getDistanceFunction(), this.alpha);
    }

    @Override
    public String getName() {
        return "MetaSoft(" + this.innerMethod.getName() + ")";
    }

    @Override
    public DataView getPopulation() {
        return this.innerMethod.getPopulation();
    }

    @Override
    public void setAttribute(NumericAttribute attribute) {
        this.innerMethod.setAttribute(attribute);
    }

    @Override
    public void setPopulation(DataView population) {
        this.innerMethod.setPopulation(population);
    }

    @Override
    public void setSegmentsCount(int segmentsCount) {
        this.innerMethod.setSegmentsCount(segmentsCount);
    }

    @Override
    public void setTarget(SGTarget target) {
        this.innerMethod.setTarget(target);
    }

    @Override
    public List<Double> getSortedSample() {
        return this.innerMethod.getSortedSample();
    }

    private static abstract class DistanceFunction {
        private DistanceFunction() {
        }

        abstract void setCutpoint(double var1);

        abstract void setPrevCutpoint(double var1);

        abstract void setNextCutpoint(double var1);

        abstract int distanceUpper(double var1);

        abstract int distanceLower(double var1);
    }

    private static final class InstanceCountDistance
    extends DistanceFunction {
        List<Double> sortedSample;
        int index;

        private InstanceCountDistance(List<Double> sortedSample) {
            this.sortedSample = sortedSample;
            this.index = 0;
        }

        @Override
        void setCutpoint(double cutpoint) {
            while (this.sortedSample.get(this.index) < cutpoint) {
                ++this.index;
            }
        }

        @Override
        int distanceUpper(double candidate) {
            int i = this.index;
            while (i < this.sortedSample.size() && this.sortedSample.get(i) < candidate) {
                ++i;
            }
            return i - this.index;
        }

        @Override
        int distanceLower(double candidate) {
            int i = this.index;
            while (i >= 0 && this.sortedSample.get(i) >= candidate) {
                --i;
            }
            return this.index - i + 1;
        }

        @Override
        void setNextCutpoint(double cutpoint) {
        }

        @Override
        void setPrevCutpoint(double cutpoint) {
        }
    }

    private static final class ToleranceDistance
    extends DistanceFunction {
        private double cutpoint;
        private double prevCutpoint;
        private double nextCutpoint;
        private final int tolerance;

        private ToleranceDistance(int tolerance) {
            this.tolerance = tolerance;
        }

        @Override
        void setCutpoint(double cutpoint) {
            this.cutpoint = cutpoint;
        }

        @Override
        int distanceLower(double candidate) {
            double tol = (this.cutpoint - this.prevCutpoint) * (double)this.tolerance / 100.0;
            return candidate >= this.cutpoint - tol ? 0 : Integer.MAX_VALUE;
        }

        @Override
        int distanceUpper(double candidate) {
            double tol = (this.nextCutpoint - this.cutpoint) * (double)this.tolerance / 100.0;
            return candidate <= this.cutpoint + tol ? 0 : Integer.MAX_VALUE;
        }

        @Override
        void setNextCutpoint(double cutpoint) {
            this.nextCutpoint = cutpoint;
        }

        @Override
        void setPrevCutpoint(double cutpoint) {
            this.prevCutpoint = cutpoint;
        }
    }
}

