/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TipHeightLikelihood
extends Likelihood.Abstract {
    ParametricDistributionModel distribution;
    private final Parameter tipHeights;
    private final double[] offsets;

    public TipHeightLikelihood(ParametricDistributionModel parametricDistributionModel, Parameter parameter) {
        super(parametricDistributionModel);
        this.distribution = parametricDistributionModel;
        this.tipHeights = parameter;
        this.offsets = new double[parameter.getDimension()];
        for (int i = 0; i < parameter.getDimension(); ++i) {
            this.offsets[i] = parameter.getParameterValue(i);
        }
    }

    @Override
    public double calculateLogLikelihood() {
        double d = 0.0;
        for (int i = 0; i < this.tipHeights.getDimension(); ++i) {
            d += this.distribution.logPdf(this.tipHeights.getParameterValue(i) - this.offsets[i]);
        }
        return d;
    }

    @Override
    protected boolean getLikelihoodKnown() {
        return false;
    }

    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet!");
    }
}

