/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.io;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.AlignmentExporter;
import jebl.evolution.io.NexusImporter;
import jebl.evolution.io.SequenceExporter;
import jebl.evolution.io.TreeExporter;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;
import jebl.util.Attributable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusExporter
implements AlignmentExporter,
SequenceExporter,
TreeExporter {
    private final String nameRegex = "^(\\w|-)+$";
    public static final String treeNameAttributeKey = "name";
    public static final String[] exportExcludeKeys = new String[]{"name", "R", "U"};
    private Set<Taxon> taxa = null;
    protected final PrintWriter writer;
    private boolean writeMetaComments;
    private boolean interleave;
    public static final int MAX_ROW_LENGTH = 60;

    public NexusExporter(Writer writer) {
        this(writer, true);
    }

    public NexusExporter(Writer writer, boolean writeMetaComments) {
        this(writer, writeMetaComments, false);
    }

    public NexusExporter(Writer writer, boolean writeMetaComments, boolean interleave) {
        this.writeMetaComments = writeMetaComments;
        this.interleave = interleave;
        this.writer = new PrintWriter(writer);
        this.writer.println("#NEXUS");
    }

    @Override
    public void exportAlignment(Alignment alignment) throws IOException {
        this.exportSequences(alignment.getSequences());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exportSequences(Collection<? extends Sequence> sequences) throws IOException, IllegalArgumentException {
        this.establishSequenceTaxa(sequences);
        SequenceType seqType = null;
        int maxLength = 0;
        for (Sequence sequence : sequences) {
            if (sequence.getLength() > maxLength) {
                maxLength = sequence.getLength();
            }
            if (seqType == null) {
                seqType = sequence.getSequenceType();
                continue;
            }
            if (seqType == sequence.getSequenceType()) continue;
            throw new IllegalArgumentException("All seqeuences must have the same type");
        }
        this.writer.println("begin characters;");
        this.writer.println("\tdimensions nchar=" + maxLength + ";");
        if (seqType != null) {
            void var5_8;
            this.writer.println("\tformat datatype=" + seqType.getNexusDataType() + " missing=" + seqType.getUnknownState().getName() + " gap=" + seqType.getGapState().getCode() + (this.interleave ? " interleave=yes" : "") + ";");
            this.writer.println("\tmatrix");
            int maxRowLength = this.interleave ? 60 : maxLength;
            boolean bl = false;
            while ((double)var5_8 < Math.ceil((double)maxLength / (double)maxRowLength)) {
                for (Sequence sequence : sequences) {
                    if (sequence.getSequenceType() != seqType) {
                        throw new IllegalArgumentException("SequenceTypes of sequences in collection do not match");
                    }
                    StringBuilder builder = new StringBuilder("\t");
                    this.appendTaxonName(sequence.getTaxon(), builder);
                    String sequenceString = sequence.getString();
                    builder.append("\t").append(sequenceString.subSequence((int)(var5_8 * maxRowLength), Math.min((int)((var5_8 + true) * maxRowLength), sequenceString.length())));
                    int shortBy = Math.min(Math.min((int)(var5_8 * maxRowLength), maxLength) - sequence.getLength(), maxRowLength);
                    if (shortBy > 0) {
                        for (int i = 0; i < shortBy; ++i) {
                            builder.append(seqType.getGapState().getCode());
                        }
                    }
                    this.writer.println(builder);
                }
                this.writer.println();
                ++var5_8;
            }
            this.writer.println(";\nend;");
        }
    }

    @Override
    public void exportTree(Tree tree) throws IOException {
        ArrayList<Tree> trees = new ArrayList<Tree>();
        trees.add(tree);
        this.exportTrees(trees);
    }

    private void writeTrees(Collection<? extends Tree> trees, boolean checkTaxa) throws IOException {
        int nt = 0;
        for (Tree tree : trees) {
            if (checkTaxa && !this.establishTreeTaxa(tree)) {
                throw new IllegalArgumentException();
            }
            boolean isRooted = tree instanceof RootedTree;
            RootedTree rtree = isRooted ? (RootedTree)tree : Utils.rootTheTree(tree);
            Object name = tree.getAttribute(treeNameAttributeKey);
            String treeName = name != null ? NexusImporter.makeIntoAllowableIdentifier(name.toString()) : "tree_" + ++nt;
            StringBuilder builder = new StringBuilder("\ttree ");
            builder.append(treeName);
            builder.append(" = ");
            builder.append(isRooted && !rtree.conceptuallyUnrooted() ? "[&R] " : "[&U] ");
            this.appendAttributes(rtree, exportExcludeKeys, builder);
            this.appendTree(rtree, rtree.getRootNode(), builder);
            builder.append(";");
            this.writer.println(builder);
        }
    }

    @Override
    public void exportTrees(Collection<? extends Tree> trees) throws IOException {
        this.exportTrees(trees, false);
    }

    public void exportTrees(Collection<? extends Tree> trees, boolean writeTaxa) throws IOException {
        if (writeTaxa) {
            TreeSet<Taxon> taxa = new TreeSet<Taxon>();
            for (Tree tree : trees) {
                taxa.addAll(tree.getTaxa());
            }
            this.establishTaxa(taxa);
        }
        this.writer.println("begin trees;");
        this.writeTrees(trees, false);
        this.writer.println("end;");
    }

    public void exportTreesWithTranslation(Collection<? extends Tree> trees, Map<String, String> t) throws IOException {
        this.writer.println("begin trees;");
        this.writer.println("\ttranslate");
        boolean first = true;
        for (Map.Entry<String, String> e : t.entrySet()) {
            this.writer.print((first ? "" : ",\n") + "\t\t" + this.safeName(e.getKey()) + " " + this.safeName(e.getValue()));
            first = false;
        }
        this.writer.println("\n\t;");
        this.writeTrees(trees, false);
        this.writer.println("end;");
    }

    public void exportMatrix(DistanceMatrix distanceMatrix) {
        List<Taxon> taxa = distanceMatrix.getTaxa();
        this.establishTaxa(taxa);
        this.writer.println("begin distances;");
        double[][] distances = distanceMatrix.getDistances();
        this.writer.println(" format triangle = upper nodiagonal;");
        this.writer.println(" matrix ");
        for (int i = 0; i < taxa.size(); ++i) {
            StringBuilder builder = new StringBuilder("\t");
            this.appendTaxonName(taxa.get(i), builder);
            for (int j = i + 1; j < taxa.size(); ++j) {
                builder.append(" ");
                builder.append(distances[i][j]);
            }
            this.writer.println(builder);
        }
        this.writer.println(";");
        this.writer.println("end;");
    }

    private void setTaxa(Taxon[] taxonArray) {
        this.taxa = new HashSet<Taxon>();
        this.writer.println("begin taxa;");
        this.writer.println("\tdimensions ntax=" + taxonArray.length + ";");
        this.writer.println("\ttaxlabels");
        for (Taxon taxon : taxonArray) {
            this.taxa.add(taxon);
            StringBuilder builder = new StringBuilder("\t");
            this.appendTaxonName(taxon, builder);
            this.appendAttributes(taxon, null, builder);
            this.writer.println(builder);
        }
        this.writer.println(";\nend;\n");
    }

    private String safeName(String name) {
        if (!name.matches("^(\\w|-)+$")) {
            name = name.replace("'", "''");
            return "'" + name + "'";
        }
        return name;
    }

    private StringBuilder appendTaxonName(Taxon taxon, StringBuilder builder) {
        String name = taxon.getName();
        if (!name.matches("^(\\w|-)+$")) {
            name = name.replace("'", "''");
            builder.append("'").append(name).append("'");
            return builder;
        }
        return builder.append(name);
    }

    private void establishSequenceTaxa(Collection<? extends Sequence> sequences) {
        if (this.taxa != null && this.taxa.size() == sequences.size()) {
            boolean hasAll = true;
            for (Sequence sequence : sequences) {
                if (!this.taxa.contains(sequence.getTaxon())) continue;
                hasAll = false;
                break;
            }
            if (hasAll) {
                return;
            }
        }
        ArrayList<Taxon> t = new ArrayList<Taxon>(sequences.size());
        for (Sequence sequence : sequences) {
            t.add(sequence.getTaxon());
        }
        this.setTaxa(t.toArray(new Taxon[0]));
    }

    private boolean establishTreeTaxa(Tree tree) {
        return this.establishTaxa(tree.getTaxa());
    }

    private boolean establishTaxa(Collection<? extends Taxon> ntaxa) {
        if (this.taxa != null && this.taxa.size() == ntaxa.size() && this.taxa.containsAll(ntaxa)) {
            return false;
        }
        this.setTaxa(ntaxa.toArray(new Taxon[0]));
        return true;
    }

    private void appendTree(RootedTree tree, Node node, StringBuilder builder) {
        if (tree.isExternal(node)) {
            this.appendTaxonName(tree.getTaxon(node), builder);
            this.appendAttributes(node, null, builder);
            if (tree.hasLengths()) {
                builder.append(':');
                builder.append(NexusExporter.roundDouble(tree.getLength(node), 6));
            }
        } else {
            builder.append('(');
            List<Node> children = tree.getChildren(node);
            int last = children.size() - 1;
            for (int i = 0; i < children.size(); ++i) {
                this.appendTree(tree, children.get(i), builder);
                builder.append(i == last ? (char)')' : ',');
            }
            this.appendAttributes(node, null, builder);
            Node parent = tree.getParent(node);
            if (parent != null && tree.hasLengths()) {
                builder.append(":").append(NexusExporter.roundDouble(tree.getLength(node), 6));
            }
        }
    }

    public static double roundDouble(double value, int decimalPlace) {
        double power_of_ten = 1.0;
        while (decimalPlace-- > 0) {
            power_of_ten *= 10.0;
        }
        return (double)Math.round(value * power_of_ten) / power_of_ten;
    }

    private StringBuilder appendAttributes(Attributable item, String[] excludeKeys, StringBuilder builder) {
        if (!this.writeMetaComments) {
            return builder;
        }
        boolean first = true;
        for (String key : item.getAttributeNames()) {
            boolean exclude = false;
            if (excludeKeys != null) {
                for (String eKey : excludeKeys) {
                    if (!eKey.equals(key)) continue;
                    exclude = true;
                }
            }
            Object value = item.getAttribute(key);
            if (exclude || key.startsWith("&") || value == null) continue;
            if (first) {
                builder.append("[&");
                first = false;
            } else {
                builder.append(",");
            }
            if (key.indexOf(32) < 0) {
                builder.append(key);
            } else {
                builder.append("\"").append(key).append("\"");
            }
            builder.append('=');
            this.appendAttributeValue(value, builder);
        }
        if (!first) {
            builder.append("]");
        }
        return builder;
    }

    private StringBuilder appendAttributeValue(Object value, StringBuilder builder) {
        if (value instanceof Object[]) {
            builder.append("{");
            Object[] elements = (Object[])value;
            if (elements.length > 0) {
                this.appendAttributeValue(elements[0], builder);
                for (int i = 1; i < elements.length; ++i) {
                    builder.append(",");
                    this.appendAttributeValue(elements[i], builder);
                }
            }
            return builder.append("}");
        }
        if (value instanceof Color) {
            return builder.append("#").append(Integer.toHexString(((Color)value).getRGB()).substring(2));
        }
        if (value instanceof String) {
            return builder.append("\"").append(value).append("\"");
        }
        return builder.append(value);
    }

    public static boolean isGeneratedTreeName(String name) {
        return name != null && name.matches("tree_[0-9]+");
    }
}

