/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.gui.visualize.PlotData2D;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseSimpleDataVisualizer;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="CostBenefitAnalysis", category="Visualization", toolTipText="View threshold data in an interactive cost-benefit visualization", iconPath="weka/gui/knowledgeflow/icons/ModelPerformanceChart.gif")
public class CostBenefitAnalysis
extends BaseSimpleDataVisualizer {
    private static final long serialVersionUID = 7756281775575854085L;

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("thresholdData");
    }

    @Override
    public void processIncoming(Data data) {
        this.getStepManager().processing();
        PlotData2D pd = (PlotData2D)data.getPrimaryPayload();
        this.getStepManager().logDetailed("Processing " + pd.getPlotName());
        this.m_data.add(data);
        this.getStepManager().finished();
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_data.size() > 0) {
            views.put("Show plots", "weka.gui.knowledgeflow.steps.CostBenefitAnalysisInteractiveView");
        }
        return views;
    }
}

