/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.util;

import java.io.Serializable;

public class PairwiseMatrix
implements Serializable {
    private static final long serialVersionUID = 1L;
    double[][] vals;

    public PairwiseMatrix(int size) {
        this.vals = new double[size - 1][];
        for (int i = 0; i < size - 1; ++i) {
            this.vals[i] = new double[size - i - 1];
            for (int j = 0; j < this.vals[i].length; ++j) {
                this.vals[i][j] = 0.0;
            }
        }
    }

    public void set(int i, int j, double v) {
        int[] indices = this.sort(i, j);
        this.vals[indices[0]][indices[1] - indices[0] - 1] = v;
    }

    public double get(int i, int j) {
        int[] indices = this.sort(i, j);
        return this.vals[indices[0]][indices[1] - indices[0] - 1];
    }

    public int length(int i) {
        return this.vals[i].length;
    }

    private int[] sort(int i, int j) {
        int[] ret = new int[2];
        if (i < j) {
            ret[0] = i;
            ret[1] = j;
        } else {
            ret[0] = j;
            ret[1] = i;
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.vals.length; ++i) {
            for (int j = 0; j < this.vals[i].length; ++j) {
                buf.append(this.vals[i][j] + "    ");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        int size = Integer.parseInt(args[0]);
        PairwiseMatrix m = new PairwiseMatrix(size);
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                m.set(i, j, Double.parseDouble(i + "" + j));
            }
        }
        System.err.println(m);
    }
}

