/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponse$;
import kafka.api.OffsetCommitRequest;
import kafka.api.OffsetCommitResponse;
import kafka.api.OffsetCommitResponse$;
import kafka.api.OffsetFetchRequest;
import kafka.api.OffsetFetchResponse;
import kafka.api.OffsetFetchResponse$;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.OffsetResponse$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.FetchRequestAndResponseStats;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.consumer.SimpleConsumer$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.Receive;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0004\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe*\u00111\u0001B\u0001\tG>t7/^7fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001A\u0001C\u0006\t\u0003\u00139i\u0011A\u0003\u0006\u0003\u00171\tA\u0001\\1oO*\tQ\"\u0001\u0003kCZ\f\u0017BA\b\u000b\u0005\u0019y%M[3diB\u0011\u0011\u0003F\u0007\u0002%)\u00111\u0003B\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\u0001T8hO&tw\r\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\t!|7\u000f^\u000b\u0002?A\u0011\u0001e\t\b\u0003/\u0005J!A\t\r\u0002\rA\u0013X\rZ3g\u0013\t!SE\u0001\u0004TiJLgn\u001a\u0006\u0003EaA\u0001b\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0006Q>\u001cH\u000f\t\u0005\tS\u0001\u0011)\u0019!C\u0001U\u0005!\u0001o\u001c:u+\u0005Y\u0003CA\f-\u0013\ti\u0003DA\u0002J]RD\u0001b\f\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0006a>\u0014H\u000f\t\u0005\tc\u0001\u0011)\u0019!C\u0001U\u0005I1o\u001c+j[\u0016|W\u000f\u001e\u0005\tg\u0001\u0011\t\u0011)A\u0005W\u0005Q1o\u001c+j[\u0016|W\u000f\u001e\u0011\t\u0011U\u0002!Q1A\u0005\u0002)\n!BY;gM\u0016\u00148+\u001b>f\u0011!9\u0004A!A!\u0002\u0013Y\u0013a\u00032vM\u001a,'oU5{K\u0002B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tAH\u0001\tG2LWM\u001c;JI\"A1\b\u0001B\u0001B\u0003%q$A\u0005dY&,g\u000e^%eA!)Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"baP!C\u0007\u0012+\u0005C\u0001!\u0001\u001b\u0005\u0011\u0001\"B\u000f=\u0001\u0004y\u0002\"B\u0015=\u0001\u0004Y\u0003\"B\u0019=\u0001\u0004Y\u0003\"B\u001b=\u0001\u0004Y\u0003\"B\u001d=\u0001\u0004y\u0002bB$\u0001\u0005\u0004%I\u0001S\u0001\u0005Y>\u001c7.F\u0001\t\u0011\u0019Q\u0005\u0001)A\u0005\u0011\u0005)An\\2lA!9A\n\u0001b\u0001\n\u0013i\u0015a\u00042m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!\u0015\u0003\u0002\u000f9,Go^8sW&\u00111\u000b\u0015\u0002\u0010\u00052|7m[5oO\u000eC\u0017M\u001c8fY\"1Q\u000b\u0001Q\u0001\n9\u000b\u0001C\u00197pG.LgnZ\"iC:tW\r\u001c\u0011\t\u000f]\u0003!\u0019!C\u0001=\u0005Q!M]8lKJLeNZ8\t\re\u0003\u0001\u0015!\u0003 \u0003-\u0011'o\\6fe&sgm\u001c\u0011\t\u000fm\u0003!\u0019!C\u00059\u0006ab-\u001a;dQJ+\u0017/^3ti\u0006sGMU3ta>t7/Z*uCR\u001cX#A/\u0011\u0005\u0001s\u0016BA0\u0003\u0005q1U\r^2i%\u0016\fX/Z:u\u0003:$'+Z:q_:\u001cXm\u0015;biNDa!\u0019\u0001!\u0002\u0013i\u0016!\b4fi\u000eD'+Z9vKN$\u0018I\u001c3SKN\u0004xN\\:f'R\fGo\u001d\u0011\t\u000f\r\u0004\u0001\u0019!C\u0005I\u0006A\u0011n]\"m_N,G-F\u0001f!\t9b-\u0003\u0002h1\t9!i\\8mK\u0006t\u0007bB5\u0001\u0001\u0004%IA[\u0001\rSN\u001cEn\\:fI~#S-\u001d\u000b\u0003W:\u0004\"a\u00067\n\u00055D\"\u0001B+oSRDqa\u001c5\u0002\u0002\u0003\u0007Q-A\u0002yIEBa!\u001d\u0001!B\u0013)\u0017!C5t\u00072|7/\u001a3!\u0011\u0015\u0019\b\u0001\"\u0003u\u0003\u001d\u0019wN\u001c8fGR$\u0012A\u0014\u0005\u0006m\u0002!Ia^\u0001\u000bI&\u001c8m\u001c8oK\u000e$H#A6\t\u000be\u0004A\u0011B<\u0002\u0013I,7m\u001c8oK\u000e$\b\"B>\u0001\t\u00039\u0018!B2m_N,\u0007\"B?\u0001\t\u0013q\u0018aC:f]\u0012\u0014V-];fgR$2a`A\u0003!\ry\u0015\u0011A\u0005\u0004\u0003\u0007\u0001&a\u0002*fG\u0016Lg/\u001a\u0005\b\u0003\u000fa\b\u0019AA\u0005\u0003\u001d\u0011X-];fgR\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f!\u0011aA1qS&!\u00111CA\u0007\u0005E\u0011V-];fgR|%OU3ta>t7/\u001a\u0005\b\u0003/\u0001A\u0011AA\r\u0003\u0011\u0019XM\u001c3\u0015\t\u0005m\u0011\u0011\u0005\t\u0005\u0003\u0017\ti\"\u0003\u0003\u0002 \u00055!!\u0006+pa&\u001cW*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a\u0005\t\u0003\u000f\t)\u00021\u0001\u0002$A!\u00111BA\u0013\u0013\u0011\t9#!\u0004\u0003)Q{\u0007/[2NKR\fG-\u0019;b%\u0016\fX/Z:u\u0011\u001d\tY\u0003\u0001C\u0001\u0003[\tQAZ3uG\"$B!a\f\u00026A!\u00111BA\u0019\u0013\u0011\t\u0019$!\u0004\u0003\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0011!\t9!!\u000bA\u0002\u0005]\u0002\u0003BA\u0006\u0003sIA!a\u000f\u0002\u000e\taa)\u001a;dQJ+\u0017/^3ti\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013\u0001E4fi>3gm]3ug\n+gm\u001c:f)\u0011\t\u0019%!\u0013\u0011\t\u0005-\u0011QI\u0005\u0005\u0003\u000f\niA\u0001\bPM\u001a\u001cX\r\u001e*fgB|gn]3\t\u0011\u0005\u001d\u0011Q\ba\u0001\u0003\u0017\u0002B!a\u0003\u0002N%!\u0011qJA\u0007\u00055yeMZ:fiJ+\u0017/^3ti\"9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013!D2p[6LGo\u00144gg\u0016$8\u000f\u0006\u0003\u0002X\u0005u\u0003\u0003BA\u0006\u00033JA!a\u0017\u0002\u000e\t!rJ\u001a4tKR\u001cu.\\7jiJ+7\u000f]8og\u0016D\u0001\"a\u0002\u0002R\u0001\u0007\u0011q\f\t\u0005\u0003\u0017\t\t'\u0003\u0003\u0002d\u00055!aE(gMN,GoQ8n[&$(+Z9vKN$\bbBA4\u0001\u0011\u0005\u0011\u0011N\u0001\rM\u0016$8\r[(gMN,Go\u001d\u000b\u0005\u0003W\n\t\b\u0005\u0003\u0002\f\u00055\u0014\u0002BA8\u0003\u001b\u00111c\u00144gg\u0016$h)\u001a;dQJ+7\u000f]8og\u0016D\u0001\"a\u0002\u0002f\u0001\u0007\u00111\u000f\t\u0005\u0003\u0017\t)(\u0003\u0003\u0002x\u00055!AE(gMN,GOR3uG\"\u0014V-];fgRDa!a\u001f\u0001\t\u00139\u0018aE4fi>\u0013X*Y6f\u0007>tg.Z2uS>t\u0007bBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u0017K\u0006\u0014H.[3ti>\u0013H*\u0019;fgR|eMZ:fiRA\u00111QAE\u00033\u000bi\nE\u0002\u0018\u0003\u000bK1!a\"\u0019\u0005\u0011auN\\4\t\u0011\u0005-\u0015Q\u0010a\u0001\u0003\u001b\u000b\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ\t\u000511m\\7n_:LA!a&\u0002\u0012\n\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005m\u0015Q\u0010a\u0001\u0003\u0007\u000b\u0001#Z1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;\t\u000f\u0005}\u0015Q\u0010a\u0001W\u0005Q1m\u001c8tk6,'/\u00133)\u0007\u0001\t\u0019\u000bE\u0002\u0012\u0003KK1!a*\u0013\u0005)!\bN]3bIN\fg-\u001a")
public class SimpleConsumer
implements Logging,
ScalaObject {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private final String clientId;
    private final Object lock;
    private final BlockingChannel blockingChannel;
    private final String brokerInfo;
    private final FetchRequestAndResponseStats fetchRequestAndResponseStats;
    private boolean isClosed;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumer simpleConsumer = this;
        synchronized (simpleConsumer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String clientId() {
        return this.clientId;
    }

    private Object lock() {
        return this.lock;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public String brokerInfo() {
        return this.brokerInfo;
    }

    private FetchRequestAndResponseStats fetchRequestAndResponseStats() {
        return this.fetchRequestAndResponseStats;
    }

    private boolean isClosed() {
        return this.isClosed;
    }

    private void isClosed_$eq(boolean bl) {
        this.isClosed = bl;
    }

    private BlockingChannel connect() {
        this.close();
        this.blockingChannel().connect();
        return this.blockingChannel();
    }

    private void disconnect() {
        if (this.blockingChannel().isConnected()) {
            this.debug((Function0<String>)new $anonfun$disconnect$1(this));
            this.blockingChannel().disconnect();
        }
    }

    private void reconnect() {
        this.disconnect();
        this.connect();
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.isClosed_$eq(true);
            return;
        }
    }

    public final Receive kafka$consumer$SimpleConsumer$$sendRequest(RequestOrResponse request$1) {
        Object object = this.lock();
        synchronized (object) {
            this.getOrMakeConnection();
            ObjectRef response$1 = new ObjectRef(null);
            this.liftedTree1$1(request$1, response$1);
            Receive receive2 = (Receive)response$1.elem;
            return receive2;
        }
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        Receive response = this.kafka$consumer$SimpleConsumer$$sendRequest(request);
        return TopicMetadataResponse$.MODULE$.readFrom(response.buffer());
    }

    public FetchResponse fetch(FetchRequest request$2) {
        ObjectRef response$2 = new ObjectRef(null);
        KafkaTimer specificTimer$1 = this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.brokerInfo()).requestTimer();
        KafkaTimer aggregateTimer = this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestTimer();
        aggregateTimer.time(new $anonfun$fetch$1(this, request$2, response$2, specificTimer$1));
        FetchResponse fetchResponse = FetchResponse$.MODULE$.readFrom(((Receive)response$2.elem).buffer());
        int fetchedSize = fetchResponse.sizeInBytes();
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.brokerInfo()).requestSizeHist().update(fetchedSize);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestSizeHist().update(fetchedSize);
        return fetchResponse;
    }

    public OffsetResponse getOffsetsBefore(OffsetRequest request) {
        return OffsetResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(request).buffer());
    }

    public OffsetCommitResponse commitOffsets(OffsetCommitRequest request) {
        return OffsetCommitResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(request).buffer());
    }

    public OffsetFetchResponse fetchOffsets(OffsetFetchRequest request) {
        return OffsetFetchResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(request).buffer());
    }

    private void getOrMakeConnection() {
        if (!this.isClosed() && !this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    public long earliestOrLatestOffset(TopicAndPartition topicAndPartition, long earliestOrLatest, int consumerId) {
        int x$5;
        Map x$1 = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topicAndPartition).$minus$greater(new PartitionOffsetRequestInfo(earliestOrLatest, 1))}));
        String x$2 = this.clientId();
        int x$3 = consumerId;
        short x$4 = OffsetRequest$.MODULE$.apply$default$2();
        OffsetRequest request = new OffsetRequest(x$1, x$4, x$5 = OffsetRequest$.MODULE$.apply$default$3(), x$2, x$3);
        PartitionOffsetsResponse partitionErrorAndOffset = (PartitionOffsetsResponse)this.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition);
        short s = partitionErrorAndOffset.error();
        if (s == ErrorMapping$.MODULE$.NoError()) {
            long offset = BoxesRunTime.unboxToLong(partitionErrorAndOffset.offsets().head());
            return offset;
        }
        throw ErrorMapping$.MODULE$.exceptionFor(partitionErrorAndOffset.error());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree1$1(RequestOrResponse requestOrResponse, ObjectRef objectRef) {
        try {
            this.blockingChannel().send(requestOrResponse);
            objectRef.elem = this.blockingChannel().receive();
            return;
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new $anonfun$liftedTree1$1$1(this, throwable));
            try {
                this.reconnect();
                this.blockingChannel().send(requestOrResponse);
                objectRef.elem = this.blockingChannel().receive();
                return;
            }
            catch (Throwable throwable2) {
                this.disconnect();
                throw throwable2;
            }
        }
    }

    public SimpleConsumer(String host, int port, int soTimeout, int bufferSize, String clientId) {
        this.host = host;
        this.port = port;
        this.soTimeout = soTimeout;
        this.bufferSize = bufferSize;
        this.clientId = clientId;
        Logging$class.$init$(this);
        ConsumerConfig$.MODULE$.validateClientId(clientId);
        this.lock = new Object();
        this.blockingChannel = new BlockingChannel(host, port, bufferSize, BlockingChannel$.MODULE$.UseDefaultBufferSize(), soTimeout);
        this.brokerInfo = Predef$.MODULE$.augmentString("host_%s-port_%s").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{host, BoxesRunTime.boxToInteger(port)}));
        this.fetchRequestAndResponseStats = FetchRequestAndResponseStatsRegistry$.MODULE$.getFetchRequestAndResponseStats(clientId);
        this.isClosed = false;
    }
}

