/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jute;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.CsvOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.jute.XmlOutputArchive;

public class RecordWriter {
    private OutputArchive archive;
    private static HashMap archiveFactory = RecordWriter.constructFactory();

    private static OutputArchive getBinaryArchive(OutputStream out) {
        return new BinaryOutputArchive(new DataOutputStream(out));
    }

    private static OutputArchive getCsvArchive(OutputStream out) throws IOException {
        try {
            return new CsvOutputArchive(out);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("Unsupported encoding UTF-8");
        }
    }

    private static OutputArchive getXmlArchive(OutputStream out) throws IOException {
        return new XmlOutputArchive(out);
    }

    static HashMap constructFactory() {
        HashMap<String, Method> factory = new HashMap<String, Method>();
        Class[] params = new Class[]{OutputStream.class};
        try {
            factory.put("binary", BinaryOutputArchive.class.getDeclaredMethod("getArchive", params));
            factory.put("csv", CsvOutputArchive.class.getDeclaredMethod("getArchive", params));
            factory.put("xml", XmlOutputArchive.class.getDeclaredMethod("getArchive", params));
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return factory;
    }

    private static OutputArchive createArchive(OutputStream out, String format2) throws IOException {
        Method factory = (Method)archiveFactory.get(format2);
        if (factory != null) {
            Object[] params = new Object[]{out};
            try {
                return (OutputArchive)factory.invoke(null, params);
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public RecordWriter(OutputStream out, String format2) throws IOException {
        this.archive = RecordWriter.createArchive(out, format2);
    }

    public void write(Record r) throws IOException {
        r.serialize(this.archive, "");
    }
}

