/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.impl.AbstractGraphVar;
import org.chocosolver.util.objects.graphs.UndirectedGraph;

public class UndirectedGraphVarImpl
extends AbstractGraphVar<UndirectedGraph>
implements UndirectedGraphVar {
    public UndirectedGraphVarImpl(String name, Model solver, UndirectedGraph LB, UndirectedGraph UB) {
        super(name, solver, LB, UB);
    }

    @Override
    public boolean removeNode(int x, ICause cause) throws ContradictionException {
        assert (cause != null);
        assert (x >= 0 && x < this.n);
        if (((UndirectedGraph)this.LB).getNodes().contains(x)) {
            this.contradiction(cause, "remove mandatory node");
            return true;
        }
        if (!((UndirectedGraph)this.UB).getNodes().contains(x)) {
            return false;
        }
        int[] nei = ((UndirectedGraph)this.UB).getNeighborsOf(x).toArray();
        if (((UndirectedGraph)this.UB).removeNode(x)) {
            if (this.reactOnModification) {
                for (int i : nei) {
                    this.delta.add(x, 2, cause);
                    this.delta.add(i, 3, cause);
                }
                this.delta.add(x, 0, cause);
            }
            if (nei.length > 0) {
                this.notifyPropagators(GraphEventType.REMOVE_EDGE, cause);
            }
            this.notifyPropagators(GraphEventType.REMOVE_NODE, cause);
            return true;
        }
        return false;
    }
}

