/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.objectives;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chocosolver.solver.Solution;
import org.restopt.RestoptProblem;
import org.restopt.objectives.AbstractRestoptObjective;
import org.restopt.search.OrderedRestorableAreaStrategy;

public class NbPlanningUnitsObjective
extends AbstractRestoptObjective {
    public static final String KEY_NB_PUS_BEST = "nb_planning_units_best";

    public NbPlanningUnitsObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, String search, boolean lns) {
        super(problem, timeLimit, verbose, maximize, search, lns);
    }

    public NbPlanningUnitsObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize) {
        this(problem, timeLimit, verbose, maximize, "", false);
    }

    @Override
    public void initObjective() {
        this.objective = this.problem.getRestoreSetVar().getCard();
        if (this.problem.hasRestorableAreaConstraint()) {
            int[] cardBounds = this.problem.getRestorableAreaConstraint().getCardinalityBounds();
            this.problem.getModel().arithm(this.problem.getRestoreSetVar().getCard(), ">=", cardBounds[0]).post();
            this.problem.getModel().arithm(this.problem.getRestoreSetVar().getCard(), "<=", cardBounds[1]).post();
        }
    }

    @Override
    public void setSearch() {
        if (this.problem.hasRestorableAreaConstraint()) {
            if (this.maximize) {
                new OrderedRestorableAreaStrategy(this.problem, true, true).setSearch();
            } else {
                new OrderedRestorableAreaStrategy(this.problem, false, true).setSearch();
            }
        } else {
            super.setSearch();
        }
    }

    @Override
    public String getInitialValueMessage() {
        return "";
    }

    @Override
    public String[] getAdditionalKeys() {
        return new String[]{KEY_NB_PUS_BEST};
    }

    @Override
    public Map<String, String> appendCharacteristics(Solution solution) {
        HashMap<String, String> charact = new HashMap<String, String>();
        charact.put(KEY_NB_PUS_BEST, String.valueOf(this.getOptimalValue()));
        return charact;
    }

    @Override
    public List<String[]> appendMessages() {
        ArrayList<String[]> messages = new ArrayList<String[]>();
        messages.add(new String[]{KEY_NB_PUS_BEST, "Best known nb planning units value: "});
        return messages;
    }
}

