/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.decomposition;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.impl.DenseColumnDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import java.io.Serializable;

public class DenseDoubleCholeskyDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private DoubleMatrix2D Lt;
    private double[] elementsA;
    private boolean columnMatrix = false;
    private int n;

    public DenseDoubleCholeskyDecomposition(DoubleMatrix2D doubleMatrix2D) {
        DoubleProperty.DEFAULT.checkSquare(doubleMatrix2D);
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D) {
            this.elementsA = (double[])doubleMatrix2D.viewDice().copy().elements();
        } else {
            this.columnMatrix = true;
            this.elementsA = (double[])doubleMatrix2D.copy().elements();
        }
        this.n = doubleMatrix2D.rows();
        Dplasma.plasma_Init((int)this.n, (int)this.n, (int)1);
        int n = Dplasma.plasma_DPOTRF((int)121, (int)this.n, (double[])this.elementsA, (int)0, (int)this.n);
        Dplasma.plasma_Finalize();
        if (n > 0) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Error occured while computing Cholesky decomposition: " + n);
        }
    }

    public DoubleMatrix2D getL() {
        if (this.Lt != null) {
            return this.Lt.viewDice().copy();
        }
        if (this.columnMatrix) {
            this.Lt = new DenseColumnDoubleMatrix2D(this.n, this.n);
            double[] dArray = (double[])this.Lt.elements();
            int n = this.n;
            while (--n >= 0) {
                int n2 = this.n;
                while (--n2 >= n) {
                    dArray[n2 * this.n + n] = this.elementsA[n2 * this.n + n];
                }
            }
        } else {
            this.Lt = new DenseDoubleMatrix2D(this.n, this.n);
            double[] dArray = (double[])this.Lt.elements();
            int n = this.n;
            while (--n >= 0) {
                int n3 = this.n;
                while (--n3 >= n) {
                    dArray[n * this.n + n3] = this.elementsA[n3 * this.n + n];
                }
            }
        }
        return this.Lt.viewDice().copy();
    }

    public DoubleMatrix2D getLtranspose() {
        if (this.Lt != null) {
            return this.Lt;
        }
        if (this.columnMatrix) {
            this.Lt = new DenseColumnDoubleMatrix2D(this.n, this.n);
            double[] dArray = (double[])this.Lt.elements();
            int n = this.n;
            while (--n >= 0) {
                int n2 = this.n;
                while (--n2 >= n) {
                    dArray[n2 * this.n + n] = this.elementsA[n2 * this.n + n];
                }
            }
        } else {
            this.Lt = new DenseDoubleMatrix2D(this.n, this.n);
            double[] dArray = (double[])this.Lt.elements();
            int n = this.n;
            while (--n >= 0) {
                int n3 = this.n;
                while (--n3 >= n) {
                    dArray[n * this.n + n3] = this.elementsA[n3 * this.n + n];
                }
            }
        }
        return this.Lt;
    }

    public void solve(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D.rows() != this.n) {
            throw new IllegalArgumentException("B.rows() != A.rows()");
        }
        DoubleProperty.DEFAULT.checkDense(doubleMatrix2D);
        double[] dArray = doubleMatrix2D instanceof DenseDoubleMatrix2D ? (double[])doubleMatrix2D.viewDice().copy().elements() : (doubleMatrix2D.isView() ? (double[])doubleMatrix2D.copy().elements() : (double[])doubleMatrix2D.elements());
        int n = doubleMatrix2D.columns();
        Dplasma.plasma_Init((int)this.n, (int)this.n, (int)n);
        int n2 = Dplasma.plasma_DPOTRS((int)121, (int)this.n, (int)n, (double[])this.elementsA, (int)0, (int)this.n, (double[])dArray, (int)0, (int)this.n);
        Dplasma.plasma_Finalize();
        if (n2 != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using Cholesky decomposition: " + n2);
        }
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D) {
            doubleMatrix2D.viewDice().assign(dArray);
        } else if (doubleMatrix2D.isView()) {
            doubleMatrix2D.assign(dArray);
        }
    }

    public void solve(DoubleMatrix1D doubleMatrix1D) {
        if (doubleMatrix1D.size() != (long)this.n) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        DoubleProperty.DEFAULT.checkDense(doubleMatrix1D);
        double[] dArray = doubleMatrix1D.isView() ? (double[])doubleMatrix1D.copy().elements() : (double[])doubleMatrix1D.elements();
        Dplasma.plasma_Init((int)this.n, (int)this.n, (int)1);
        int n = Dplasma.plasma_DPOTRS((int)121, (int)this.n, (int)1, (double[])this.elementsA, (int)0, (int)this.n, (double[])dArray, (int)0, (int)this.n);
        Dplasma.plasma_Finalize();
        if (n != 0) {
            throw new IllegalArgumentException("Error occured while solving the system of equation using Cholesky decomposition: " + n);
        }
        if (doubleMatrix1D.isView()) {
            doubleMatrix1D.assign(dArray);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Illegal operation or error: ";
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("CholeskyDecomposition(A) --> L, inverse(A)\n");
        stringBuffer.append("--------------------------------------------------------------------------\n");
        stringBuffer.append("\nL = ");
        try {
            stringBuffer.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        stringBuffer.append("\n\ninverse(A) = ");
        try {
            DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.identity(this.n);
            this.solve(doubleMatrix2D);
            stringBuffer.append(String.valueOf(doubleMatrix2D));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append(string + illegalArgumentException.getMessage());
        }
        return stringBuffer.toString();
    }
}

