/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.function.tfloat.FloatProcedure;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import junit.framework.TestCase;
import org.junit.Test;

public abstract class FloatMatrix1DTest
extends TestCase {
    protected FloatMatrix1D A;
    protected FloatMatrix1D B;
    protected int SIZE = 170;
    protected float TOL = 0.001f;

    public FloatMatrix1DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        ConcurrencyUtils.setThreadsBeginN_1D(1);
        for (n = 0; n < (int)this.A.size(); ++n) {
            this.A.setQuick(n, (float)Math.random());
        }
        for (n = 0; n < (int)this.B.size(); ++n) {
            this.B.setQuick(n, (float)Math.random());
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateFloatFloatFunctionFloatFunction() {
        float f = 0.0f;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float f2 = this.A.getQuick(i);
            f += f2 * f2;
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square);
        FloatMatrix1DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatFloatFunctionFloatFunctionIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            intArrayList.add(i);
        }
        float f = 0.0f;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float f2 = this.A.getQuick(i);
            f += f2 * f2;
        }
        float f3 = this.A.aggregate(FloatFunctions.plus, FloatFunctions.square, intArrayList);
        FloatMatrix1DTest.assertEquals((float)f, (float)f3, (float)this.TOL);
    }

    public void testAggregateFloatMatrix2DFloatFloatFunctionFloatFloatFunction() {
        float f = 0.0f;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float f2 = this.A.getQuick(i);
            float f3 = this.B.getQuick(i);
            f += f2 * f3;
        }
        float f4 = this.A.aggregate(this.B, FloatFunctions.plus, FloatFunctions.mult);
        FloatMatrix1DTest.assertEquals((float)f, (float)f4, (float)this.TOL);
    }

    public void testAssignFloat() {
        float f = (float)Math.random();
        this.A.assign(f);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FloatMatrix1DTest.assertEquals((float)f, (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[(int)this.A.size()];
        for (n = 0; n < (int)this.A.size(); ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        for (n = 0; n < (int)this.A.size(); ++n) {
            FloatMatrix1DTest.assertEquals((float)fArray[n], (float)this.A.getQuick(n), (float)this.TOL);
        }
    }

    public void testAssignFloatFunction() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        this.A.assign(FloatFunctions.acos);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float f = (float)Math.acos(floatMatrix1D.getQuick(i));
            FloatMatrix1DTest.assertEquals((float)f, (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testAssignFloatMatrix1D() {
        this.A.assign(this.B);
        FloatMatrix1DTest.assertTrue((this.A.size() == this.B.size() ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FloatMatrix1DTest.assertEquals((float)this.B.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testAssignFloatMatrix1DFloatFloatFunction() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        this.A.assign(this.B, FloatFunctions.div);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FloatMatrix1DTest.assertEquals((float)(floatMatrix1D.getQuick(i) / this.B.getQuick(i)), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testAssignFloatProcedureFloat() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        FloatMatrix1D floatMatrix1D = this.A.copy();
        this.A.assign(floatProcedure, -1.0f);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if ((double)Math.abs(floatMatrix1D.getQuick(i)) > 0.1) {
                FloatMatrix1DTest.assertEquals((double)-1.0, (double)this.A.getQuick(i), (double)this.TOL);
                continue;
            }
            FloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testAssignFloatProcedureFloatFunction() {
        FloatProcedure floatProcedure = new FloatProcedure(){

            public boolean apply(float f) {
                return (double)Math.abs(f) > 0.1;
            }
        };
        FloatMatrix1D floatMatrix1D = this.A.copy();
        this.A.assign(floatProcedure, FloatFunctions.tan);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if ((double)Math.abs(floatMatrix1D.getQuick(i)) > 0.1) {
                FloatMatrix1DTest.assertEquals((double)Math.tan(floatMatrix1D.getQuick(i)), (double)this.A.getQuick(i), (double)this.TOL);
                continue;
            }
            FloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        FloatMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)n);
    }

    public void testEqualsFloat() {
        float f = 1.0f;
        this.A.assign(f);
        boolean bl = this.A.equals(f);
        FloatMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2.0f);
        FloatMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        FloatMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        FloatMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0.0f);
        this.A.setQuick((int)this.A.size() / 3, 0.7f);
        this.A.setQuick((int)this.A.size() / 2, 0.1f);
        float[] fArray = this.A.getMaxLocation();
        FloatMatrix1DTest.assertEquals((double)0.7, (double)fArray[0], (double)this.TOL);
        FloatMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)((int)fArray[1]));
    }

    public void testMinLocation() {
        this.A.assign(0.0f);
        this.A.setQuick((int)this.A.size() / 3, -0.7f);
        this.A.setQuick((int)this.A.size() / 2, -0.1f);
        float[] fArray = this.A.getMinLocation();
        FloatMatrix1DTest.assertEquals((float)-0.7f, (float)fArray[0], (float)this.TOL);
        FloatMatrix1DTest.assertEquals((int)((int)this.A.size() / 3), (int)((int)fArray[1]));
    }

    public void testGetNegativeValuesIntArrayListFloatArrayList() {
        this.A.assign(0.0f);
        this.A.setQuick((int)this.A.size() / 3, -0.7f);
        this.A.setQuick((int)this.A.size() / 2, -0.1f);
        IntArrayList intArrayList = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getNegativeValues(intArrayList, floatArrayList);
        FloatMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix1DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        FloatMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        FloatMatrix1DTest.assertTrue((boolean)floatArrayList.contains(-0.7f));
        FloatMatrix1DTest.assertTrue((boolean)floatArrayList.contains(-0.1f));
    }

    public void testGetNonZerosIntArrayListFloatArrayList() {
        this.A.assign(0.0f);
        this.A.setQuick((int)this.A.size() / 3, 0.7f);
        this.A.setQuick((int)this.A.size() / 2, 0.1f);
        IntArrayList intArrayList = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getNonZeros(intArrayList, floatArrayList);
        FloatMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix1DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        FloatMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        FloatMatrix1DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
        FloatMatrix1DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
    }

    public void testGetPositiveValuesIntArrayListFloatArrayList() {
        this.A.assign(0.0f);
        this.A.setQuick((int)this.A.size() / 3, 0.7f);
        this.A.setQuick((int)this.A.size() / 2, 0.1f);
        IntArrayList intArrayList = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.A.getPositiveValues(intArrayList, floatArrayList);
        FloatMatrix1DTest.assertEquals((int)2, (int)intArrayList.size());
        FloatMatrix1DTest.assertEquals((int)2, (int)floatArrayList.size());
        FloatMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 3));
        FloatMatrix1DTest.assertTrue((boolean)intArrayList.contains((int)this.A.size() / 2));
        FloatMatrix1DTest.assertTrue((boolean)floatArrayList.contains(0.7f));
        FloatMatrix1DTest.assertTrue((boolean)floatArrayList.contains(0.1f));
    }

    public void testToArray() {
        float[] fArray = this.A.toArray();
        FloatMatrix1DTest.assertTrue(((int)this.A.size() == fArray.length ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FloatMatrix1DTest.assertEquals((float)fArray[i], (float)this.A.getQuick(i), (float)this.TOL);
        }
    }

    public void testToArrayFloatArray() {
        float[] fArray = new float[(int)this.A.size()];
        this.A.toArray(fArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FloatMatrix1DTest.assertEquals((float)this.A.getQuick(i), (float)fArray[i], (float)this.TOL);
        }
    }

    public void testReshapeIntInt() {
        int n = 10;
        int n2 = 17;
        FloatMatrix2D floatMatrix2D = this.A.reshape(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                FloatMatrix1DTest.assertEquals((float)this.A.getQuick(n3++), (float)floatMatrix2D.getQuick(j, i), (float)this.TOL);
            }
        }
    }

    public void testReshapeIntIntInt() {
        int n = 2;
        int n2 = 5;
        int n3 = 17;
        FloatMatrix3D floatMatrix3D = this.A.reshape(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    FloatMatrix1DTest.assertEquals((float)this.A.getQuick(n4++), (float)floatMatrix3D.getQuick(i, k, j), (float)this.TOL);
                }
            }
        }
    }

    public void testSwap() {
        FloatMatrix1D floatMatrix1D = this.A.copy();
        FloatMatrix1D floatMatrix1D2 = this.B.copy();
        this.A.swap(this.B);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FloatMatrix1DTest.assertEquals((float)floatMatrix1D2.getQuick(i), (float)this.A.getQuick(i), (float)this.TOL);
            FloatMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)this.B.getQuick(i), (float)this.TOL);
        }
    }

    public void testViewFlip() {
        FloatMatrix1D floatMatrix1D = this.A.viewFlip();
        FloatMatrix1DTest.assertEquals((long)((int)this.A.size()), (long)floatMatrix1D.size());
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FloatMatrix1DTest.assertEquals((float)this.A.getQuick(i), (float)floatMatrix1D.getQuick((int)this.A.size() - 1 - i), (float)this.TOL);
        }
    }

    public void testViewPart() {
        FloatMatrix1D floatMatrix1D = this.A.viewPart(15, 11);
        for (int i = 0; i < 11; ++i) {
            FloatMatrix1DTest.assertEquals((float)this.A.getQuick(15 + i), (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testViewSelectionFloatProcedure() {
        FloatMatrix1D floatMatrix1D = this.A.viewSelection(new FloatProcedure(){

            public boolean apply(float f) {
                return f % 2.0f == 0.0f;
            }
        });
        int n = 0;
        while ((long)n < floatMatrix1D.size()) {
            float f = floatMatrix1D.getQuick(n);
            if (f % 2.0f != 0.0f) {
                FloatMatrix1DTest.fail();
            }
            ++n;
        }
    }

    public void testViewSelectionIntArray() {
        int[] nArray = new int[]{5, 11, 22, 37, 101};
        FloatMatrix1D floatMatrix1D = this.A.viewSelection(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            FloatMatrix1DTest.assertEquals((float)this.A.getQuick(nArray[i]), (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testViewSorted() {
        FloatMatrix1D floatMatrix1D = this.A.viewSorted();
        for (int i = 0; i < (int)this.A.size() - 1; ++i) {
            FloatMatrix1DTest.assertTrue((floatMatrix1D.getQuick(i + 1) >= floatMatrix1D.getQuick(i) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        FloatMatrix1D floatMatrix1D = this.A.viewStrides(n);
        int n2 = 0;
        while ((long)n2 < floatMatrix1D.size()) {
            FloatMatrix1DTest.assertEquals((float)this.A.getQuick(n2 * n), (float)floatMatrix1D.getQuick(n2), (float)this.TOL);
            ++n2;
        }
    }

    public void testZDotProductFloatMatrix1D() {
        float f = this.A.zDotProduct(this.B);
        float f2 = 0.0f;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            f2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        FloatMatrix1DTest.assertEquals((float)f2, (float)f, (float)this.TOL);
    }

    public void testZDotProductFloatMatrix1DIntInt() {
        float f = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10);
        float f2 = 0.0f;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            f2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        FloatMatrix1DTest.assertEquals((float)f2, (float)f, (float)this.TOL);
    }

    @Test
    public void testZDotProductFloatMatrix1DIntIntIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        FloatArrayList floatArrayList = new FloatArrayList();
        this.B.getNonZeros(intArrayList, floatArrayList);
        float f = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10, intArrayList);
        float f2 = 0.0f;
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            f2 += this.A.getQuick(i) * this.B.getQuick(i);
        }
        FloatMatrix1DTest.assertEquals((float)f2, (float)f, (float)this.TOL);
    }

    public void testZSum() {
        float f = this.A.zSum();
        float f2 = 0.0f;
        for (int i = 0; i < (int)this.A.size(); ++i) {
            f2 += this.A.getQuick(i);
        }
        FloatMatrix1DTest.assertEquals((float)f2, (float)f, (float)this.TOL);
    }
}

