xx_mod_ui <- function(id) {
  ns <- NS(id)

  tagList(
    sidebarPanel(
      selectInput(ns("xcol"), "X Variable", names(iris)),
      selectInput(ns("ycol"), "Y Variable", names(iris),
        selected = names(iris)[[2]]
      ),
      numericInput(ns("clusters"), "Cluster count", 3,
        min = 1, max = 9
      )
    ),
    mainPanel(
      plotOutput(ns("plot1"))
    )
  )
}

# xx_mod <- function(input, output, session){
#   output$plot1 <- renderPlot({
#     plot(iris)
#   })
# }

xx_mod_server <- function(input, output, session) {
  # Combine the selected variables into a new data frame
  selectedData <- reactive({
    iris[, c(input$xcol, input$ycol)]
  })

  clusters <- reactive({
    kmeans(selectedData(), input$clusters)
  })

  output$plot1 <- renderPlot({
    palette(c(
      "#E41A1C", "#377EB8", "#4DAF4A", "#984EA3",
      "#FF7F00", "#FFFF33", "#A65628", "#F781BF", "#999999"
    ))

    par(mar = c(5.1, 4.1, 0, 1))
    plot(selectedData(),
      col = clusters()$cluster,
      pch = 20, cex = 3
    )
    points(clusters()$centers, pch = 4, cex = 4, lwd = 4)
  })
}
