## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(Sys.getenv("NOT_CRAN"), "true")
)

## ----setup, warning=FALSE-----------------------------------------------------
# library(fwtraits)
# library(ggplot2)

## ----data---------------------------------------------------------------------
# set.seed(1135)
# 
# sites1 <- rep(c("A","B", "C", "D", "E"), c(7,10, 8, 13, 4))
# 
# mv <- c("Margaritifera margaritifera","Pseudunio auricularius","Musculium lacustre",
#         "Musculium transversum","Corbicula fluminea","Congeria leucophaeata",
#         "Dreissena polymorpha", "Dreissena rostriformis bugensis",
#         "Parastenocaris germaica", "Branchiobdella balcanica",
#         "Branchiobdella hexadonta","Branchiobdella parasita","Branchiobdella pentadonta")
# 
# sp <- c(sample(mv, 7), sample(mv, 10),sample(mv, 8),sample(mv, 13),sample(mv, 4))
# abun <- rnorm(length(sp), 1.3, 0.12)
# 
# macrodf <- data.frame(sites = sites1, species = sp, abund = abun)
# 

## ----retrievedata-------------------------------------------------------------
# traitsdf <- fw_fetchdata(data =  macrodf,
#                            organismgroup = 'mi',
#                            taxonomic_column = 'species',
#                            ecoparams = c("stream zonation preference", "feeding type"),
#                            inform = FALSE)

## ----commputefdindies---------------------------------------------------------
# 
# #fd indices calculated when abundance  is provided.
# 
# fdindices <- fw_fdcompute(fwdata = traitsdf,
#                         sitesdata = macrodf,
#                         sites = 'sites',
#                         species = 'species',
#                         abund = 'abund',
#                         FD = TRUE)
# 
# #functional richness only: when abundance is not provided.
# fdric<- fw_fdcompute(fwdata = traitsdf,
#                         sitesdata = macrodf,
#                         sites = 'sites',
#                         species = 'species',
#                         FD = TRUE)

## ----viz, fig.width = 7, fig.height= 4, fig.align='center'--------------------
# 
# df <- fdindices |> tidyr::gather('fdind', "vals", -site)
# 
# ggplot(data = df, aes(site, vals, fill = fdind))+
#   geom_bar(stat = 'identity')+
#   scale_fill_viridis_d()+
#   theme(legend.position = "none")+
#   facet_wrap(~fdind, scales ='free_y')+
#   labs(x='sites', y='FD indices')
# 
# #Functional richness
# 
# dffric <- fdric |> tidyr::gather('fdind', "vals", -site)
# 
# ggplot(data = dffric, aes(site, vals, fill = fdind))+
#   geom_bar(stat = 'identity')+
#   scale_fill_viridis_d()+
#   theme(legend.position = "none")+
#   facet_wrap(~fdind, scales ='free_y')+
#   labs(x='Sites', y='FD indices')
# 

## ----cmwmeans-----------------------------------------------------------------
# cwmdata <- fw_fdcompute(fwdata = traitsdf,
#                         sitesdata = macrodf,
#                         sites = 'sites',
#                         species = 'species',
#                         abund = 'abund',
#                         FD = FALSE)

## ----cwmeansnodummy-----------------------------------------------------------
# cwmdata <- fw_fdcompute(fwdata = traitsdf,
#                         sitesdata = macrodf,
#                         sites = 'sites',
#                         species = 'species',
#                         abund = 'abund',
#                         FD = FALSE, dummy = FALSE)

