/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff;

import com.qarks.util.Cancellable;
import com.qarks.util.files.diff.FileDiffResult;
import com.qarks.util.files.diff.FileLine;
import com.qarks.util.files.diff.MergeResult;
import com.qarks.util.files.diff.MergeResultItem;
import com.qarks.util.files.diff.ParsedFile;
import com.qarks.util.files.diff.core.MyersDiff;
import java.util.ArrayList;

public class Diff {
    public static FileDiffResult diff(String string, String string2, Cancellable cancellable, boolean bl) {
        ParsedFile parsedFile = new ParsedFile(string);
        ParsedFile parsedFile2 = new ParsedFile(string2);
        FileDiffResult fileDiffResult = MyersDiff.diff(parsedFile, parsedFile2, cancellable, bl);
        return fileDiffResult;
    }

    public static FileDiffResult quickDiff(String string, String string2, boolean bl) {
        ParsedFile parsedFile = new ParsedFile(string);
        ParsedFile parsedFile2 = new ParsedFile(string2);
        FileDiffResult fileDiffResult = new FileDiffResult(parsedFile, parsedFile2);
        Diff.lookForMatch(parsedFile, parsedFile2, bl);
        Diff.lookForMatch(parsedFile2, parsedFile, bl);
        FileLine[] fileLineArray = parsedFile.getLines();
        FileLine[] fileLineArray2 = parsedFile2.getLines();
        int n = 0;
        int n2 = 0;
        while (n < fileLineArray.length && n2 < fileLineArray2.length) {
            int n3;
            int n4;
            int n5;
            while (n < fileLineArray.length && n2 < fileLineArray2.length && fileLineArray[n].matches(fileLineArray2[n2], bl)) {
                fileLineArray[n].setStatus(1);
                fileLineArray2[n2].setStatus(1);
                ++n;
                ++n2;
            }
            int n6 = fileLineArray.length;
            int n7 = fileLineArray2.length;
            int n8 = 0;
            int n9 = 15;
            for (n5 = n; n8 < n9 && n5 < fileLineArray.length; ++n5) {
                n4 = fileLineArray[n5].indexInOtherVersion();
                if (n4 <= -1 || n4 < n2 || n8 >= (n3 = Diff.getContiguousMatchingLines(fileLineArray, fileLineArray2, n5, n4, n9, bl))) continue;
                n8 = n3;
                n6 = n5;
                n7 = n4;
            }
            n5 = n6 == n || n7 == n2 ? -1 : 3;
            n4 = Math.min(n6, fileLineArray.length);
            for (n3 = n; n3 < n4; ++n3) {
                if (n3 >= fileLineArray.length) continue;
                fileLineArray[n3].setStatus(n5);
                ++n;
            }
            n4 = Math.min(n7, fileLineArray2.length);
            for (n3 = n2; n3 < n4; ++n3) {
                fileLineArray2[n3].setStatus(n5);
                ++n2;
            }
        }
        return fileDiffResult;
    }

    public static int getContiguousMatchingLines(FileLine[] fileLineArray, FileLine[] fileLineArray2, int n, int n2, int n3, boolean bl) {
        int n4;
        for (n4 = 0; (n3 == -1 || n4 < n3) && n + n4 < fileLineArray.length && n2 + n4 < fileLineArray2.length && fileLineArray[n + n4].matches(fileLineArray2[n2 + n4], bl); ++n4) {
        }
        return n4;
    }

    public static FileDiffResult quickDiff2(String string, String string2, boolean bl) {
        ParsedFile parsedFile = new ParsedFile(string);
        ParsedFile parsedFile2 = new ParsedFile(string2);
        FileDiffResult fileDiffResult = new FileDiffResult(parsedFile, parsedFile2);
        Diff.lookForMatch(parsedFile, parsedFile2, bl);
        Diff.lookForMatch(parsedFile2, parsedFile, bl);
        FileLine[] fileLineArray = parsedFile.getLines();
        FileLine[] fileLineArray2 = parsedFile2.getLines();
        int n = 0;
        int n2 = 0;
        while (n < fileLineArray.length && n2 < fileLineArray2.length) {
            int n3;
            int n4;
            int n5;
            while (n < fileLineArray.length && n2 < fileLineArray2.length && fileLineArray[n].matches(fileLineArray2[n2], bl)) {
                fileLineArray[n].setStatus(1);
                fileLineArray2[n2].setStatus(1);
                ++n;
                ++n2;
            }
            int n6 = fileLineArray.length;
            int n7 = fileLineArray2.length;
            int n8 = Integer.MAX_VALUE;
            int n9 = Integer.MAX_VALUE;
            for (n5 = n; n5 < fileLineArray.length; ++n5) {
                n4 = fileLineArray[n5].indexInOtherVersion();
                n3 = n4 - n2 + (n5 - n);
                if (n4 <= -1 || n4 < n2 || n8 <= n3 || n4 >= n9) continue;
                n8 = n3;
                n9 = n4;
                n6 = n5;
                n7 = n4;
            }
            n5 = n6 == n || n7 == n2 ? -1 : 3;
            n4 = Math.min(n6, fileLineArray.length);
            for (n3 = n; n3 < n4; ++n3) {
                if (n3 >= fileLineArray.length) continue;
                fileLineArray[n3].setStatus(n5);
                ++n;
            }
            n4 = Math.min(n7, fileLineArray2.length);
            for (n3 = n2; n3 < n4; ++n3) {
                fileLineArray2[n3].setStatus(n5);
                ++n2;
            }
        }
        return fileDiffResult;
    }

    public static MergeResult merge(String string, String string2, String string3, Cancellable cancellable, boolean bl) {
        MergeResult mergeResult = null;
        FileDiffResult fileDiffResult = Diff.diff(string, string2, cancellable, bl);
        FileDiffResult fileDiffResult2 = Diff.diff(string, string3, cancellable, bl);
        fileDiffResult = Diff.format(fileDiffResult);
        fileDiffResult2 = Diff.format(fileDiffResult2);
        if (cancellable != null && cancellable.isCancelled()) {
            return null;
        }
        mergeResult = Diff.analyze(fileDiffResult, fileDiffResult2);
        return mergeResult;
    }

    public static MergeResult quickMerge(String string, String string2, String string3, boolean bl) {
        MergeResult mergeResult = null;
        FileDiffResult fileDiffResult = Diff.quickDiff(string, string2, bl);
        FileDiffResult fileDiffResult2 = Diff.quickDiff(string, string3, bl);
        fileDiffResult = Diff.format(fileDiffResult);
        fileDiffResult2 = Diff.format(fileDiffResult2);
        mergeResult = Diff.analyze(fileDiffResult, fileDiffResult2);
        return mergeResult;
    }

    public static MergeResult analyze(FileDiffResult fileDiffResult, FileDiffResult fileDiffResult2) {
        Object object;
        ArrayList<MergeResultItem> arrayList = new ArrayList<MergeResultItem>();
        FileDiffResult[] fileDiffResultArray = Diff.format(new FileDiffResult[]{fileDiffResult, fileDiffResult2});
        fileDiffResult = fileDiffResultArray[0];
        fileDiffResult2 = fileDiffResultArray[1];
        FileLine[] fileLineArray = fileDiffResult.getLeftFile().getLines();
        FileLine[] fileLineArray2 = fileDiffResult.getRightFile().getLines();
        FileLine[] fileLineArray3 = fileDiffResult2.getLeftFile().getLines();
        FileLine[] fileLineArray4 = fileDiffResult2.getRightFile().getLines();
        ArrayList arrayList2 = new ArrayList();
        ArrayList<FileLine> arrayList3 = new ArrayList<FileLine>();
        int n = 0;
        int n2 = fileLineArray2.length;
        int n3 = 0;
        while (n < n2) {
            object = new ArrayList();
            ArrayList<FileLine> arrayList4 = new ArrayList<FileLine>();
            int n4 = fileLineArray2[n].getStatus();
            int n5 = fileLineArray[n].getStatus();
            int n6 = fileLineArray4[n].getStatus();
            int n7 = fileLineArray3[n].getStatus();
            int n8 = 0;
            while (n < n2 && n4 == fileLineArray2[n].getStatus() && n5 == fileLineArray[n].getStatus() && n6 == fileLineArray4[n].getStatus() && n7 == fileLineArray3[n].getStatus()) {
                ((ArrayList)object).add(fileLineArray2[n]);
                arrayList4.add(fileLineArray4[n]);
                ++n;
                ++n8;
            }
            if (n5 == 1 && n7 == 1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == 1 && n7 == 3) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
            } else if (n5 == 1 && n7 == 4) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
            } else if (n5 == 3 && n7 == 1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == 4 && n7 == 1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == 4 && n7 == -1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == -1 && n7 == 4) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
            } else if (n5 == -1 && n7 == 3) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
            } else if (n5 == 3 && n7 == -1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == -1 && n7 == 1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.WARNING_DELETE, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == 1 && n7 == -1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.WARNING_DELETE, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
            } else if (n5 == 1 && n7 == 5) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.WARNING_DELETE, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == 5 && n7 == 1) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.WARNING_DELETE, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
            } else if (n5 == 4 && n7 == 4) {
                if (Diff.buildText((ArrayList<FileLine>)object).equals(Diff.buildText(arrayList4))) {
                    Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
                } else {
                    Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.WARNING_ORDER, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
                }
            } else if (n5 == 3 && n7 == 3) {
                if (Diff.buildText((ArrayList<FileLine>)object).equals(Diff.buildText(arrayList4))) {
                    Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.NO_CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
                } else {
                    Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
                }
            } else if (n5 == 4 && n7 == 3) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 == 3 && n7 == 4) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
            } else if (n5 == 3 && n7 == 5) {
                Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.LEFT, n8));
            } else if (n5 != 5 || n7 != 5) {
                if (n5 == 5 && n7 == 3) {
                    Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
                } else if (n5 != -1 || n7 != -1) {
                    System.out.println("###################### One case forgoten !!! bloc: " + n3 + ", lineCount: " + n8);
                    System.out.println("leftStatus: " + FileLine.statusToString(n4));
                    System.out.println("ancestor1Status: " + FileLine.statusToString(n5));
                    System.out.println("rightStatus: " + FileLine.statusToString(n6));
                    System.out.println("ancestor2Status: " + FileLine.statusToString(n7));
                    Diff.addMergeItem(arrayList, new MergeResultItem(MergeResultItem.Type.CONFLICT, (ArrayList<FileLine>)object, arrayList4, MergeResultItem.DefaultVersion.RIGHT, n8));
                }
            }
            ++n3;
            arrayList2.addAll(object);
            arrayList3.addAll(arrayList4);
        }
        arrayList = Diff.mergeAppropriateItems(arrayList);
        object = new MergeResult(arrayList);
        return object;
    }

    private static void dumpMergeItems(ArrayList<MergeResultItem> arrayList) {
        System.out.println("found " + arrayList.size() + " merge items");
        for (int i = 0; i < arrayList.size(); ++i) {
            MergeResultItem mergeResultItem = arrayList.get(i);
            System.out.println(mergeResultItem.toString());
        }
    }

    private static void addMergeItem(ArrayList<MergeResultItem> arrayList, MergeResultItem mergeResultItem) {
        arrayList.add(mergeResultItem);
    }

    private static ArrayList<MergeResultItem> mergeAppropriateItems(ArrayList<MergeResultItem> arrayList) {
        ArrayList<MergeResultItem> arrayList2 = new ArrayList<MergeResultItem>();
        ArrayList<MergeResultItem> arrayList3 = new ArrayList<MergeResultItem>();
        int n = 1;
        MergeResultItem mergeResultItem = arrayList.get(0);
        arrayList3.add(mergeResultItem);
        if (mergeResultItem.matches()) {
            Diff.handleMergeableItems(arrayList3, arrayList2);
            ++n;
            if (arrayList.size() > 1) {
                mergeResultItem = arrayList.get(1);
                arrayList3.add(mergeResultItem);
            }
        }
        for (int i = n; i < arrayList.size(); ++i) {
            MergeResultItem mergeResultItem2 = arrayList.get(i);
            if (mergeResultItem2.matches()) {
                Diff.handleMergeableItems(arrayList3, arrayList2);
                mergeResultItem = mergeResultItem2;
                arrayList3.add(mergeResultItem);
                continue;
            }
            if (mergeResultItem.couldMerge(mergeResultItem2)) {
                arrayList3.add(mergeResultItem2);
                mergeResultItem = mergeResultItem2;
                continue;
            }
            Diff.handleMergeableItems(arrayList3, arrayList2);
            mergeResultItem = mergeResultItem2;
            arrayList3.add(mergeResultItem);
        }
        Diff.handleMergeableItems(arrayList3, arrayList2);
        return arrayList2;
    }

    private static void handleMergeableItems(ArrayList<MergeResultItem> arrayList, ArrayList<MergeResultItem> arrayList2) {
        boolean bl = false;
        for (int i = 0; !bl && i < arrayList.size(); ++i) {
            bl = arrayList.get(i).isConflict();
        }
        if (!bl) {
            arrayList2.addAll(arrayList);
            arrayList.clear();
        } else {
            MergeResultItem mergeResultItem = MergeResultItem.merge(MergeResultItem.Type.CONFLICT, arrayList);
            arrayList2.add(mergeResultItem);
            arrayList.clear();
        }
    }

    public static String buildText(ArrayList<FileLine> arrayList) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i).getContent());
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static void lookForMatch(ParsedFile parsedFile, ParsedFile parsedFile2, boolean bl) {
        FileLine[] fileLineArray = parsedFile.getLines();
        FileLine[] fileLineArray2 = parsedFile2.getLines();
        for (int i = 0; i < fileLineArray.length; ++i) {
            boolean bl2 = false;
            for (int j = 0; !bl2 && j < fileLineArray2.length; ++j) {
                if (fileLineArray2[j].isMatchFound() || !fileLineArray[i].matches(fileLineArray2[j], bl)) continue;
                fileLineArray[i].setIndexInOtherVersion(j);
                fileLineArray2[j].setIndexInOtherVersion(i);
                bl2 = true;
            }
        }
    }

    private static FileDiffResult[] format(FileDiffResult[] fileDiffResultArray) {
        FileDiffResult[] fileDiffResultArray2 = new FileDiffResult[2];
        if (fileDiffResultArray.length == 2) {
            int n = 0;
            int n2 = 0;
            FileLine[] fileLineArray = fileDiffResultArray[0].getLeftFile().getLines();
            FileLine[] fileLineArray2 = fileDiffResultArray[0].getRightFile().getLines();
            FileLine[] fileLineArray3 = fileDiffResultArray[1].getLeftFile().getLines();
            FileLine[] fileLineArray4 = fileDiffResultArray[1].getRightFile().getLines();
            ArrayList<FileLine> arrayList = new ArrayList<FileLine>();
            ArrayList<FileLine> arrayList2 = new ArrayList<FileLine>();
            ArrayList<FileLine> arrayList3 = new ArrayList<FileLine>();
            ArrayList<FileLine> arrayList4 = new ArrayList<FileLine>();
            if (fileLineArray.length != fileLineArray2.length || fileLineArray3.length != fileLineArray4.length) {
                System.err.println("error on input arrays sizes for merge formatting");
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n2 < fileLineArray.length && n < fileLineArray3.length) {
                if (fileLineArray[n2].getIndex() == fileLineArray3[n].getIndex()) {
                    arrayList.add(fileLineArray2[n2]);
                    arrayList2.add(fileLineArray[n2]);
                    arrayList3.add(fileLineArray4[n]);
                    arrayList4.add(fileLineArray3[n]);
                    if (fileLineArray[n2].getIndex() == -1) {
                        ++n5;
                    }
                    ++n2;
                    ++n;
                    continue;
                }
                if (fileLineArray[n2].getIndex() == -1 && fileLineArray3[n].getIndex() != -1) {
                    arrayList.add(fileLineArray2[n2]);
                    arrayList2.add(fileLineArray[n2]);
                    arrayList3.add(FileLine.getFormattingLine(1));
                    arrayList4.add(FileLine.getFormattingLine(1));
                    ++n2;
                    ++n4;
                    continue;
                }
                if (fileLineArray[n2].getIndex() != -1 && fileLineArray3[n].getIndex() == -1) {
                    arrayList3.add(fileLineArray4[n]);
                    arrayList4.add(fileLineArray3[n]);
                    arrayList.add(FileLine.getFormattingLine(1));
                    arrayList2.add(FileLine.getFormattingLine(1));
                    ++n;
                    ++n3;
                    continue;
                }
                System.err.println("case not handled !!?");
            }
            if (n2 < fileLineArray.length) {
                while (n2 < fileLineArray.length) {
                    arrayList.add(fileLineArray2[n2]);
                    arrayList2.add(fileLineArray[n2]);
                    arrayList3.add(FileLine.getFormattingLine(1));
                    arrayList4.add(FileLine.getFormattingLine(1));
                    ++n2;
                }
            } else if (n < fileLineArray3.length) {
                while (n < fileLineArray3.length) {
                    arrayList3.add(fileLineArray4[n]);
                    arrayList4.add(fileLineArray3[n]);
                    arrayList.add(FileLine.getFormattingLine(1));
                    arrayList2.add(FileLine.getFormattingLine(1));
                    ++n;
                    ++n3;
                }
            }
            if (arrayList.size() != arrayList3.size()) {
                System.err.println("error on merge input formatting");
                System.err.println("left final size: " + arrayList.size());
                System.err.println("right final size: " + arrayList3.size());
                System.err.println("left added: " + n3);
                System.err.println("right added: " + n4);
                System.err.println("commonNoMatch: " + n5);
            }
            fileDiffResultArray2[0] = new FileDiffResult(new ParsedFile(arrayList2), new ParsedFile(arrayList));
            fileDiffResultArray2[1] = new FileDiffResult(new ParsedFile(arrayList4), new ParsedFile(arrayList3));
        }
        return fileDiffResultArray2;
    }

    public static FileDiffResult format(FileDiffResult fileDiffResult) {
        FileLine[] fileLineArray = fileDiffResult.getLeftFile().getLines();
        FileLine[] fileLineArray2 = fileDiffResult.getRightFile().getLines();
        int n = 0;
        int n2 = 0;
        ArrayList<FileLine> arrayList = new ArrayList<FileLine>();
        ArrayList<FileLine> arrayList2 = new ArrayList<FileLine>();
        boolean bl = true;
        while (bl) {
            bl = false;
            while (!(n >= fileLineArray.length && n2 >= fileLineArray2.length || n != fileLineArray.length && fileLineArray[n].getStatus() != 1 || n2 != fileLineArray2.length && fileLineArray2[n2].getStatus() != 1)) {
                if (n < fileLineArray.length) {
                    arrayList.add(fileLineArray[n]);
                    ++n;
                }
                if (n2 < fileLineArray2.length) {
                    arrayList2.add(fileLineArray2[n2]);
                    ++n2;
                }
                bl = true;
            }
            while (!(n >= fileLineArray.length && n2 >= fileLineArray2.length || n != fileLineArray.length && fileLineArray[n].getStatus() != 3 || n2 != fileLineArray2.length && fileLineArray2[n2].getStatus() != 3)) {
                if (n < fileLineArray.length) {
                    arrayList.add(fileLineArray[n]);
                    ++n;
                } else {
                    arrayList.add(FileLine.getFormattingLine(3));
                }
                if (n2 < fileLineArray2.length) {
                    arrayList2.add(fileLineArray2[n2]);
                    ++n2;
                } else {
                    arrayList2.add(FileLine.getFormattingLine(3));
                }
                bl = true;
            }
            while (!(n >= fileLineArray.length && n2 >= fileLineArray2.length || n != fileLineArray.length && fileLineArray[n].getStatus() != 3 || n2 != fileLineArray2.length && fileLineArray2[n2].getStatus() != 1)) {
                if (n < fileLineArray.length) {
                    arrayList.add(fileLineArray[n]);
                    ++n;
                }
                if (n2 < fileLineArray2.length) {
                    arrayList2.add(FileLine.getFormattingLine(3));
                }
                bl = true;
            }
            while (!(n >= fileLineArray.length && n2 >= fileLineArray2.length || n != fileLineArray.length && fileLineArray[n].getStatus() != 1 || n2 != fileLineArray2.length && fileLineArray2[n2].getStatus() != 3)) {
                if (n < fileLineArray.length) {
                    arrayList.add(FileLine.getFormattingLine(3));
                }
                if (n2 < fileLineArray2.length) {
                    arrayList2.add(fileLineArray2[n2]);
                    ++n2;
                }
                bl = true;
            }
            while (n < fileLineArray.length && fileLineArray[n].getStatus() == -1) {
                arrayList.add(fileLineArray[n]);
                ++n;
                arrayList2.add(FileLine.getFormattingLine(4));
                bl = true;
            }
            while (n2 < fileLineArray2.length && fileLineArray2[n2].getStatus() == -1) {
                arrayList2.add(fileLineArray2[n2]);
                ++n2;
                arrayList.add(FileLine.getFormattingLine(4));
                bl = true;
            }
        }
        if (n < fileLineArray.length || n2 < fileLineArray2.length) {
            System.err.println("not all lines consumed !!!");
        }
        FileDiffResult fileDiffResult2 = new FileDiffResult(new ParsedFile(arrayList), new ParsedFile(arrayList2));
        return fileDiffResult2;
    }
}

