/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.stream;

import com.qarks.util.Log;
import com.qarks.util.stream.CorePipedInputStream;
import com.qarks.util.stream.CorePipedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ThreadedOutputStream
extends CorePipedOutputStream
implements Runnable {
    private byte[] mArray;
    private Thread mThread = null;
    private OutputStream mOs;

    public ThreadedOutputStream(OutputStream outputStream, int n) {
        super(2 * n);
        this.mOs = outputStream;
        this.mPis = new CorePipedInputStream();
        this.mArray = new byte[n];
        try {
            this.mPis.connect(this);
            this.mThread = new Thread(this);
            this.mThread.start();
        }
        catch (IOException iOException) {
            Log.logError(this, "cannot connect pipes:", iOException);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            this.mThread.join();
        }
        catch (InterruptedException interruptedException) {
            Log.logError(this, "join interrupted", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int n;
            while ((n = this.mPis.read(this.mArray)) >= 0) {
                if (n > 0) {
                    this.mOs.write(this.mArray, 0, n);
                    continue;
                }
                Thread.sleep(50L);
            }
            this.mOs.close();
            this.mPis.close();
        }
        catch (Exception exception) {
            Log.logError(this, "cannot write.", exception);
            exception.printStackTrace();
        }
        finally {
            try {
                this.mOs.close();
                this.mPis.close();
            }
            catch (IOException iOException) {}
        }
    }
}

