/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public abstract class PropLargeCSP<R extends LargeRelation>
extends Propagator<IntVar> {
    protected final R relation;

    protected PropLargeCSP(IntVar[] vars, R relation) {
        this(vars, relation, true);
    }

    protected PropLargeCSP(IntVar[] vars, R relation, boolean reactToFineEvent) {
        super((Variable[])vars, (Priority)PropagatorPriority.QUADRATIC, reactToFineEvent);
        this.relation = relation;
    }

    public final R getRelation() {
        return this.relation;
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int[] tuple = new int[((IntVar[])this.vars).length];
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                tuple[i] = ((IntVar[])this.vars)[i].getValue();
            }
            return ESat.eval(((LargeRelation)this.relation).isConsistent(tuple));
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CSPLarge({");
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(((IntVar[])this.vars)[i]).append(", ");
        }
        sb.append("})");
        return sb.toString();
    }

    public Tuples extractTuples() {
        return ((LargeRelation)this.relation).convert();
    }
}

