/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.sort.IntComparator;

public class DisjunctiveTaskIntervalFilter
extends CumulFilter {
    private final ArraySort<?> sort;
    private final StartComparator comp;
    private final int[] tsks;

    public DisjunctiveTaskIntervalFilter(int nbMaxTasks) {
        super(nbMaxTasks);
        this.sort = new ArraySort(nbMaxTasks, false, true);
        this.comp = new StartComparator();
        this.tsks = new int[nbMaxTasks];
    }

    @Override
    public void filter(IntVar[] s, IntVar[] d, IntVar[] e, IntVar[] h, IntVar capa, ISet tasks, Propagator<IntVar> aCause) throws ContradictionException {
        capa.updateUpperBound(1, (ICause)aCause);
        int tskSize = 0;
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int t = tIter.nextInt();
            if (d[t].getLB() <= 0 || h[t].getLB() <= 0) continue;
            this.tsks[tskSize++] = t;
        }
        this.comp.setS(s);
        this.sort.sort(this.tsks, tskSize, this.comp);
        for (int x = 0; x < tskSize; ++x) {
            int task1 = this.tsks[x];
            for (int y = 0; y < tskSize; ++y) {
                if (x == y) continue;
                int task2 = this.tsks[y];
                int t1 = s[task1].getLB();
                int t2 = e[task2].getUB();
                if (e[task1].getLB() > s[task2].getUB()) {
                    s[task1].updateLowerBound(e[task2].getLB(), (ICause)aCause);
                    e[task2].updateUpperBound(s[task1].getUB(), (ICause)aCause);
                    continue;
                }
                if (t1 >= t2 || t1 >= e[task2].getLB() && t2 <= s[task1].getUB()) continue;
                int W = 0;
                for (int z = 0; z < tskSize; ++z) {
                    int task3 = this.tsks[z];
                    if (task3 == task1 || task3 == task2) continue;
                    if (s[task3].getLB() >= t2) break;
                    int pB = d[task3].getLB() * h[task3].getLB();
                    int pbt1 = Math.max(0, pB - Math.max(0, t1 - s[task3].getLB()));
                    int pbt2 = Math.max(0, pB - Math.max(0, e[task3].getUB() - t2));
                    int pbt = Math.min(pbt1, pbt2);
                    W += Math.min(t2 - t1, pbt);
                }
                if (W + d[task1].getLB() + d[task2].getLB() <= t2 - t1) continue;
                s[task1].updateLowerBound(e[task2].getLB(), (ICause)aCause);
                e[task2].updateUpperBound(s[task1].getUB(), (ICause)aCause);
            }
        }
    }

    private static class StartComparator
    implements IntComparator {
        IntVar[] s;

        private StartComparator() {
        }

        void setS(IntVar[] s) {
            this.s = s;
        }

        @Override
        public int compare(int i1, int i2) {
            return this.s[i1].getLB() - this.s[i2].getLB();
        }
    }
}

