% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bvars.r
\name{plot_bvars}
\alias{plot_bvars}
\title{plot_bvars: This function plots the IRFs generated with the BVAR}
\usage{
plot_bvars(
  M,
  significance_level = 0.05,
  central_tendency = "mean",
  variable_names = NULL,
  shock_names = NULL
)
}
\arguments{
\item{M}{IRFs produced by eg bvarSIGNs}

\item{significance_level}{(eg 0.05)}

\item{central_tendency}{eg 'mean' or 'median'}

\item{variable_names}{vector of names of variables (strings)}

\item{shock_names}{vector of names of variables (strings)}
}
\value{
a list of ggplot objects (plots)
}
\description{
plot_bvars: This function plots the IRFs generated with the BVAR
}
\examples{
# Example with simulated IRF data
# Create simulated IRF array (n_vars, n_shocks, n_periods, n_draws)
set.seed(123)
n_vars <- 3
n_shocks <- 3
n_periods <- 10
n_draws <- 50

# Generate IRF responses that decay over time
M <- array(0, dim = c(n_vars, n_shocks, n_periods, n_draws))
for (i in 1:n_vars) {
  for (j in 1:n_shocks) {
    for (t in 1:n_periods) {
      # Create decaying responses with some randomness
      base_response <- ifelse(i == j, 1, 0.3) * exp(-0.1 * (t-1))
      M[i, j, t, ] <- rnorm(n_draws, mean = base_response, sd = 0.1)
    }
  }
}

# Create plots
var_names <- c("GDP", "CPI", "FFR")
shock_names <- c("Supply", "Demand", "Monetary")

plots <- plot_bvars(M, 
                    variable_names = var_names,
                    shock_names = shock_names,
                    significance_level = 0.1)

# plots is a list of ggplot objects
print(length(plots))

}
