% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/founderPop.R
\name{addSegSite}
\alias{addSegSite}
\title{Add segregating site to MapPop}
\usage{
addSegSite(mapPop, siteName, chr, mapPos, haplo)
}
\arguments{
\item{mapPop}{an object of \code{\link{MapPop-class}}}

\item{siteName}{name to give the segregating site}

\item{chr}{which chromosome to add the site}

\item{mapPos}{genetic map position of site in Morgans}

\item{haplo}{haplotypes for the site}
}
\value{
an object of \code{\link{MapPop-class}}
}
\description{
This function allows for adding a new
segregating site with user supplied genotypes to a MapPop.
The position of the site is set using a genetic map position.
}
\examples{
# Creates a populations of 10 outbred individuals
# Their genome consists of 1 chromosome and 2 segregating sites
founderPop = quickHaplo(nInd=10,nChr=1,segSites=2)

# Add a locus a the 0.5 Morgan map position
haplo = matrix(sample(x=0:1, size=20, replace=TRUE), ncol=1)

founderPop2 = addSegSite(founderPop, siteName="x", chr=1, mapPos=0.5, haplo=haplo)

pullSegSiteHaplo(founderPop2)

}
