% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore.R
\name{AutoScore_testing}
\alias{AutoScore_testing}
\title{AutoScore STEP(v): Evaluate the final score with ROC analysis (AutoScore Module 6)}
\usage{
AutoScore_testing(
  test_set,
  final_variables,
  cut_vec,
  scoring_table,
  threshold = "best",
  with_label = TRUE,
  metrics_ci = TRUE
)
}
\arguments{
\item{test_set}{A processed \code{data.frame} that contains data for testing purpose. This \code{data.frame} should have same format as
\code{train_set} (same variable names and outcomes)}

\item{final_variables}{A vector containing the list of selected variables, selected from Step(ii) \code{\link{AutoScore_parsimony}}. Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.}

\item{cut_vec}{Generated from STEP(iii) \code{\link{AutoScore_weighting}}.Please follow the guidebook}

\item{scoring_table}{The final scoring table after fine-tuning, generated from STEP(iv) \code{\link{AutoScore_fine_tuning}}.Please follow the guidebook}

\item{threshold}{Score threshold for the ROC analysis to generate sensitivity, specificity, etc. If set to "best", the optimal threshold will be calculated (Default:"best").}

\item{with_label}{Set to TRUE if there are labels in the test_set and performance will be evaluated accordingly (Default:TRUE).
Set it to "FALSE" if there are not "label" in the "test_set" and the final predicted scores will be the output without performance evaluation.}

\item{metrics_ci}{whether to calculate confidence interval for the metrics of sensitivity, specificity, etc.}
}
\value{
A data frame with predicted score and the outcome for downstream visualization.
}
\description{
AutoScore STEP(v): Evaluate the final score with ROC analysis (AutoScore Module 6)
}
\examples{
## Please see the guidebook or vignettes
}
\references{
\itemize{
 \item{Xie F, Chakraborty B, Ong MEH, Goldstein BA, Liu N. AutoScore: A Machine Learning-Based Automatic Clinical Score Generator and
  Its Application to Mortality Prediction Using Electronic Health Records. JMIR Medical Informatics 2020;8(10):e21798}
}
}
\seealso{
\code{\link{AutoScore_rank}}, \code{\link{AutoScore_parsimony}}, \code{\link{AutoScore_weighting}}, \code{\link{AutoScore_fine_tuning}}, \code{\link{print_roc_performance}}, Run \code{vignette("Guide_book", package = "AutoScore")} to see the guidebook or vignette.
}
