% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token_manual.R
\docType{class}
\name{AzureManualToken}
\alias{AzureManualToken}
\title{Manual Azure Token}
\format{
An R6 object of class \code{AzureManualToken}, inheriting from \code{AzureToken}.
}
\arguments{
\item{token}{A character string containing the access token.}

\item{type}{The token type, usually "Bearer".}

\item{tenant}{Optional tenant ID. If NULL, extracted from JWT claims.}

\item{resource}{Optional resource/audience. If NULL, extracted from JWT claims.}
}
\value{
Returns self invisibly.

Always returns FALSE for manual tokens.

Returns NULL invisibly.

An MD5 hash string based on the token content.
}
\description{
Initialize a manual token from a raw access token string.

Refresh the token. Manual tokens cannot be refreshed.

Check if this token can be refreshed.

Cache the token. Manual tokens are not cached.

Compute a hash for this token.

Print the token object.
}
\details{
Create an Azure token object from a pre-existing access token string. This is useful
when you have obtained a token externally (e.g., via Azure CLI, Python, or another
authentication mechanism) and want to use it with the AzureR ecosystem.

The \code{AzureManualToken} class provides a way to wrap an externally-obtained access
token string so it can be used with packages like \code{AzureGraph}, \code{AzureRMR},
and other AzureR family packages that expect an \code{AzureToken} object.

If the token is a JWT (JSON Web Token), the class will attempt to parse it to extract
metadata such as the tenant ID, audience (resource), and expiration time. If parsing
fails (e.g., for opaque tokens), the class will still function but with limited metadata.

Since manual tokens are managed externally, the \code{refresh()} method cannot obtain
a new token. When the token expires, you must create a new \code{AzureManualToken}
object with a fresh token string.
}
\section{Methods}{

\itemize{
\item \code{new(token, type, tenant, resource)}: Initialize a new manual token object.
\item \code{refresh()}: Cannot refresh a manual token; issues a warning and returns self.
\item \code{validate()}: Checks if the token has expired based on JWT claims.
\item \code{can_refresh()}: Returns FALSE since manual tokens cannot be refreshed.
\item \code{cache()}: No-op; manual tokens are not cached.
}
}

\examples{
\dontrun{
# Get a token externally (e.g., from Azure CLI)
# az account get-access-token --resource https://graph.microsoft.com
raw_token <- "eyJ0eXAiOiJKV1QiLC..."

# Create a manual token object
token <- get_manual_token(raw_token)

# Check if metadata was parsed
print(token$tenant)
print(token$resource)

# Use with AzureGraph
library(AzureGraph)
gr <- ms_graph$new(token = token)
me <- gr$get_user("me")

# Check token validity
token$validate()
}

}
\seealso{
\code{\link{get_manual_token}}, \code{\link{AzureToken}}, \code{\link{decode_jwt}}
}
