% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{hull.alpha}
\alias{hull.alpha}
\title{Alpha diversity using convex hull hypervolumes.}
\usage{
hull.alpha(comm)
}
\arguments{
\item{comm}{A 'convhulln' object or list, preferably built with function hull.build.}
}
\value{
One value or a vector of alpha diversity values for each site.
}
\description{
Estimation of functional richness of one or multiple sites, based on convex hull hypervolumes.
}
\details{
Estimates the functional richness (alpha FD) of one or more communities using convex hull hypervolumes.
Functional richness is expressed as the total volume of the convex hull.
}
\examples{
comm = rbind(c(1,3,0,5,3), c(3,2,5,0,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = hull.build(comm[1,], trait)
hull.alpha(hv)
hvlist = hull.build(comm, trait)
hull.alpha(hvlist)
}
