% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limfactor.R
\name{limfactor}
\alias{limfactor}
\title{Determination of the most limiting factor to biological response}
\usage{
limfactor(...)
}
\arguments{
\item{...}{vectors with predicted values from the boundary line models for
each factor being evaluated.}
}
\value{
A dataframe consisting of the most limiting factor and the minimum
  predicted response
}
\description{
This function determines the most limiting factor based on von Liebig law of
the minimum given results of the predicted boundary line values for the different
factors of interest. Boundary lines for various factors are fitted and the factor
that predicts the minimum response for a particular point is considered as the
most limiting factor (Casanova et al. 1995).
}
\examples{

N<-rnorm(10,50,5)#assuming these are predicted responses using the fitted BL for N,P,K
K<-rnorm(10,50,4)
P<-rnorm(10,50,6)

limfactor(N,K,P)

}
\author{
Chawezi Miti <chawezi.miti@nottingham.ac.uk>
}
