% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixNRMI1.R
\name{plot.NRMI1}
\alias{plot.NRMI1}
\title{Plot the density estimate and the 95\% credible interval}
\usage{
\method{plot}{NRMI1}(x, ...)
}
\arguments{
\item{x}{A fitted object of class NRMI1}

\item{...}{Further arguments to be passed to generic function, ignored at the moment}
}
\value{
A graph with the density estimate, the 95\% credible interval and a
histogram of the data
}
\description{
The density estimate is the mean posterior density computed on the data
points.
}
\examples{

## Example for non censored data

data(acidity)
out <- MixNRMI1(acidity, Nit = 50)
plot(out)

## Example for censored data

data(salinity)
out <- MixNRMI1cens(salinity$left, salinity$right, Nit = 50)
plot(out)
}
