% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_diagnostics.R
\name{convergence_diag}
\alias{convergence_diag}
\title{Check effective sample size and geweke diagnostic}
\usage{
convergence_diag(out, type = "eSS", cutoff = ifelse(type == "eSS", 100, 1.96))
}
\arguments{
\item{out}{Output from BSTFA or BSTFAfull.}

\item{type}{Character specifying which diagnostic to compute.  Options are \code{ess} and \code{geweke}.}

\item{cutoff}{Numeric scalar indicating the cutoff value to flag parameters that haven't converged.}
}
\value{
A list containing the parameters not meeting the convergence cutoff criteria.
}
\description{
Check effective sample size and geweke diagnostic
}
\examples{
data(out.sm)
attach(out.sm)
convergence_diag(out.sm)
}
\author{
Adam Simpson
}
