% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{arguments.regressors}
\alias{arguments.regressors}
\title{Shared documentation for regressors}
\arguments{
\item{xreg}{optional; external regressors. Can be specified as a vector, a
matrix or a list. Default is \code{xreg = NULL}. For details, see the Section
\link[=arguments.regressors]{Regressors format}.}

\item{xnew}{optional; \code{nnew} new observations of the external regressors
(extract and fit only). Follows the same format is the same as \code{xreg}.
Default is \code{xnew = NULL}.}

\item{xreg.start}{optional; initial value for the regressors (to initialize
recursion). Can be specified as a vector or a list. Default is
\code{xreg.start = NULL}, in which case, the average of the first \eqn{p}
values (AR order) is used. Only relevant if \code{xreg} is provided, \code{xregar = TRUE} and \eqn{p > 0}. For details, see the Section
\link[=arguments.regressors]{Regressors format}.}

\item{xregar}{a length 1 or 2 logical vector indicating whether \code{xreg} should
be included in the AR recursion for each part of the model. Default is
\code{xregar = TRUE}. Only relevant if \eqn{p > 0}. If a single value is
provided and \eqn{\nu} is time-varying, the same option is assumed for both
parts of the model. See the Section \sQuote{The BTSR structure} in
\link{btsr-package} for details.}
}
\description{
This is the common documentation for arguments related to the regressors.
}
\section{Regressors format}{
In-sample (\code{xreg}) and out-of-sample values (\code{xnew}) for regressors can be
provided in two formats
\itemize{
\item \strong{Legacy structure:} a vector or matrix. Internally \code{xreg} is
converted to \code{xreg = list(part1 = xreg, part2 = NULL)}. The same applies to
\code{xnew}

\item \strong{New structure:} a list with elements \code{part1} (regressors for
first model component) and \code{part2} (regressors for second model component),
each being a vector or matrix.
}

\code{xreg.start} can be provided in two formats
\itemize{
\item \strong{Legacy structure:} a vector with initial values for each
regressor. Internally \code{xreg.start} is converted to
\code{xreg.start = list(part1 = xreg.start, part2 = NULL)}.

\item \strong{New structure:} a list with elements \code{part1} and \code{part2},
each a vector of initial values for the respective regressors.
}

The following rules apply to \code{xreg}, \code{xnew} and \code{xreg.start}
\itemize{
\item if \code{model} corresponds to a case where \eqn{\nu} is constant over time
(e.g., \code{model = "BARMA"}), \code{part2} is ignored.

\item For simulation, regressors must include \code{n + burn} observations.

\item For model fitting, parameter initialization, or component extraction,
the number of regressor observations must match the length of the observed
time series \code{yt}.

\item When \code{xreg = NULL} or \code{nnew = 0}, \code{xnew} is ignored. If \code{nnew > 0} and
the number of regressors in \code{xnew} does not match \code{xreg} an error message is
issued.

\item If starting values for \code{xreg} are not provided and \eqn{p_i > 0} for
the \eqn{i}th part of the model, the default behavior is to assume
\deqn{
  \displaystyle\boldsymbol{X}_t =
  \frac{1}{p_i}\sum_{k = 1}^{p_i} \boldsymbol{X}_k,
 \quad \text{for } t< 1.
 }
}
}

