% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.infer.R
\name{post.infer}
\alias{post.infer}
\title{Posterior Inference for Simulated Basket Trial Data}
\usage{
post.infer(
  object,
  pnull,
  stopbounds = NULL,
  clusterk = NULL,
  nperclust = NULL,
  beta.a0 = pnull,
  beta.b0 = 1 - pnull,
  seed = 987897,
  ModelFit,
  ...
)
}
\arguments{
\item{object}{returned from \link{generate.data}.}

\item{pnull}{B by 1 vector of null response rates, where B is the number of baskets.}

\item{stopbounds}{B by (stage-1) matrix: stopping boundaries for each basket at each interim.}

\item{clusterk}{only needed for parallel computing.}

\item{nperclust}{only needed for parallel computing.}

\item{beta.a0}{a vector of length B for beta prior parameter a0 in each basket.}

\item{beta.b0}{a vector of length B for beta prior parameter b0 in each basket.}

\item{seed}{random seed for reproducibility.}

\item{ModelFit}{the method function, e.g., \code{localPP}, \code{JSD}, and other user defined methods.}

\item{...}{additional arguments passed to the method function defined by \code{ModelFit}.}
}
\value{
It returns a list including \code{data}, \code{N}, and \code{ORRs}, where \code{data} is an
array with \code{dim=c(nS, ntrial, B, stage)}.
}
\description{
It generates posterior probabilities P(p_j > pnull) after all interim analysis
and calculates rates for early stopping, number of patients and estimated ORR.
}
\examples{
N <- rbind(
c(10, 25),
c(10, 25),
c(10, 25)) # interim sample size and total sample size for each indication
scenarios <- rbind( c(0.15, 0.15, 0.15), c(0.3, 0.3, 0.3) )
res <- generate.data(N = N, ORRs = scenarios, ntrial = 20, seed = 2024)
post <- post.infer(res, pnull = rep(0.15,3), stopbounds = cbind(c(1,1,1)),
ModelFit = "localPP", method = "PEB")
apply(post$earlystop, c(1,3), mean) # early stopping for each basket in each scenario
apply(post$npts, c(1,3), mean) # average number of pts for each basket in each scenario
apply(post$est, c(1,3), mean) # average ORR estimate for each basket in each scenario
}
